/*
 * Decompiled with CFR 0.152.
 */
package manage.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import manage.conf.MetaDataAutoConfiguration;
import manage.model.EntityType;
import org.springframework.core.io.Resource;

public class MetaDataFeedParser {
    private static final List<String> languages = Arrays.asList("en", "nl");
    private static final String ATTRIBUTES = "attributes";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Map<String, Object> importXML(Resource xml, EntityType entityType, Optional<String> entityIDOptional, MetaDataAutoConfiguration metaDataAutoConfiguration) throws XMLStreamException, IOException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(xml.getInputStream());
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        TreeMap metaDataFields = new TreeMap();
        result.put("metaDataFields", metaDataFields);
        boolean inKeyDescriptor = false;
        boolean inContact = true;
        boolean inUIInfo = false;
        boolean inCorrectEntityDescriptor = !entityIDOptional.isPresent();
        boolean inAttributeConsumingService = false;
        result.put("type", entityType.getJanusDbValue());
        boolean isSp = entityType.equals((Object)EntityType.SP);
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        block70: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "EntityDescriptor": {
                            Optional optional = this.getAttributeValue(reader, "entityID");
                            if (!optional.isPresent()) break;
                            if (entityIDOptional.isPresent()) {
                                inCorrectEntityDescriptor = entityIDOptional.get().equalsIgnoreCase((String)optional.get());
                            }
                            if (!inCorrectEntityDescriptor) break;
                            result.put("entityid", optional.get());
                            continue block70;
                        }
                        case "SPSSODescriptor": {
                            if (!inCorrectEntityDescriptor || !isSp) break;
                            Set set = this.arpKeys(EntityType.SP, metaDataAutoConfiguration, isSp);
                            Map map = this.arpAliases(EntityType.SP, metaDataAutoConfiguration, isSp);
                            TreeMap<String, Serializable> arp = new TreeMap<String, Serializable>();
                            arp.put("enabled", Boolean.valueOf(false));
                            TreeMap attributes = new TreeMap();
                            arp.put(ATTRIBUTES, attributes);
                            result.put("arp", arp);
                            continue block70;
                        }
                        case "KeyDescriptor": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            Optional use = this.getAttributeValue(reader, "use");
                            if (use.isPresent() && !((String)use.get()).equals("signing")) break;
                            inKeyDescriptor = true;
                            continue block70;
                        }
                        case "X509Certificate": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            if (!inKeyDescriptor) break;
                            inKeyDescriptor = false;
                            String cert = reader.getElementText().replaceAll("[\n\r]", "").trim();
                            this.addCert(metaDataFields, cert);
                            continue block70;
                        }
                        case "SingleLogoutService": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            if (!isSp) break;
                            this.addMetaDataField(metaDataFields, reader, "Binding", "SingleLogoutService_Binding");
                            this.addMetaDataField(metaDataFields, reader, "Location", "SingleLogoutService_Location");
                            continue block70;
                        }
                        case "AssertionConsumerService": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            if (!isSp) break;
                            Optional bindingOpt = this.getAttributeValue(reader, "Binding");
                            bindingOpt.ifPresent(binding -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Binding", 10, binding));
                            Optional locationOpt = this.getAttributeValue(reader, "Location");
                            locationOpt.ifPresent(location -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Location", 10, location));
                            Optional indexOpt = this.getAttributeValue(reader, "index");
                            indexOpt.ifPresent(index -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:index", 10, index));
                            continue block70;
                        }
                        case "SingleSignOnService": {
                            if (!inCorrectEntityDescriptor) break;
                            if (isSp) continue block70;
                            Optional bindingOpt = this.getAttributeValue(reader, "Binding");
                            bindingOpt.ifPresent(binding -> this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Binding", 10, binding));
                            Optional locationOpt = this.getAttributeValue(reader, "Location");
                            locationOpt.ifPresent(location -> this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Location", 10, location));
                            continue block70;
                        }
                        case "RegistrationInfo": {
                            if (!inCorrectEntityDescriptor) break;
                            this.getAttributeValue(reader, "registrationAuthority").ifPresent(authority -> metaDataFields.put("mdrpi:RegistrationInfo", authority));
                            continue block70;
                        }
                        case "RegistrationPolicy": {
                            if (!inCorrectEntityDescriptor) break;
                            this.addLanguageElement(metaDataFields, reader, "mdrpi:RegistrationPolicy");
                            continue block70;
                        }
                        case "AttributeConsumingService": {
                            inAttributeConsumingService = inCorrectEntityDescriptor;
                            continue block70;
                        }
                        case "UIInfo": {
                            inUIInfo = inCorrectEntityDescriptor;
                            continue block70;
                        }
                        case "DisplayName": {
                            if (!inUIInfo) break;
                            this.addLanguageElement(metaDataFields, reader, "name");
                            continue block70;
                        }
                        case "Logo": {
                            if (!inUIInfo) break;
                            this.addLogo(metaDataFields, reader);
                            continue block70;
                        }
                        case "Description": {
                            if (!inUIInfo) break;
                            this.addLanguageElement(metaDataFields, reader, "description");
                            continue block70;
                        }
                        case "ServiceName": {
                            if (!inAttributeConsumingService) break;
                            this.addLanguageElement(metaDataFields, reader, "name");
                            continue block70;
                        }
                        case "ServiceDescription": {
                            if (!inAttributeConsumingService) break;
                            this.addLanguageElement(metaDataFields, reader, "description");
                            continue block70;
                        }
                        case "RequestedAttribute": {
                            void var16_19;
                            void var15_16;
                            if (!inAttributeConsumingService || !isSp) break;
                            this.addArpAttribute(result, reader, (Set)var15_16, (Map)var16_19);
                            continue block70;
                        }
                        case "OrganizationName": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationName");
                            continue block70;
                        }
                        case "OrganizationDisplayName": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationDisplayName");
                            continue block70;
                        }
                        case "OrganizationURL": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationURL");
                            continue block70;
                        }
                        case "ContactPerson": {
                            if (!inCorrectEntityDescriptor) continue block70;
                            String contactType = this.getAttributeValue(reader, "contactType").orElse("other");
                            this.addMultiplicity(metaDataFields, "contacts:%s:contactType", 4, contactType);
                            inContact = true;
                            continue block70;
                        }
                        case "GivenName": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:givenName", 4, reader.getElementText());
                            continue block70;
                        }
                        case "SurName": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:surName", 4, reader.getElementText());
                            continue block70;
                        }
                        case "EmailAddress": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:emailAddress", 4, reader.getElementText().replaceAll(Pattern.quote("mailto:"), ""));
                            continue block70;
                        }
                        case "TelephoneNumber": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:telephoneNumber", 4, reader.getElementText());
                        }
                    }
                    continue block70;
                }
                case 2: {
                    switch (reader.getLocalName()) {
                        case "ContactPerson": {
                            inContact = false;
                            break;
                        }
                        case "AttributeConsumingService": {
                            inAttributeConsumingService = false;
                            break;
                        }
                        case "UIInfo": {
                            inUIInfo = false;
                            break;
                        }
                        case "EntityDescriptor": {
                            if (!inCorrectEntityDescriptor) break;
                            return result;
                        }
                    }
                    continue block70;
                }
            }
        }
        return result;
    }

    private Set<String> arpKeys(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        return this.arpAttributes(type, metaDataAutoConfiguration, isSp).keySet();
    }

    private Map<String, String> arpAliases(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        Map arp = this.arpAttributes(type, metaDataAutoConfiguration, isSp);
        return arp.entrySet().stream().collect(Collectors.toMap(entry -> ((Map)Map.class.cast(entry.getValue())).getOrDefault("alias", "nope"), entry -> (String)entry.getKey()));
    }

    private Map<String, Object> arpAttributes(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        Map<String, Object> arpAttributes;
        Map schema = metaDataAutoConfiguration.schemaRepresentation(type);
        Map<String, Object> map = arpAttributes = isSp ? (Map)Map.class.cast(schema.get("properties")) : new HashMap<String, Object>();
        if (isSp) {
            for (String s : Arrays.asList("arp", "properties", ATTRIBUTES, "properties")) {
                arpAttributes = (Map)Map.class.cast(arpAttributes.get(s));
            }
        }
        return arpAttributes;
    }

    private void addArpAttribute(Map<String, Object> result, XMLStreamReader reader, Set<String> arpKeys, Map<String, String> arpAliases) {
        Optional name = this.getAttributeValue(reader, "Name");
        Optional friendlyName = this.getAttributeValue(reader, "FriendlyName");
        if (this.shouldAddAttributeToArp(name, arpKeys)) {
            this.doAddArpAttribute(result, arpKeys, (String)name.get());
        } else if (this.shouldAddAttributeToArp(friendlyName, arpKeys)) {
            this.doAddArpAttribute(result, arpKeys, (String)friendlyName.get());
        } else if (name.isPresent() && arpAliases.containsKey(name.get())) {
            this.doAddArpAttribute(result, arpKeys, arpAliases.get(name.get()));
        }
    }

    private boolean shouldAddAttributeToArp(Optional<String> name, Set<String> allowedArpKeys) {
        return name.isPresent() && allowedArpKeys.stream().anyMatch(arpKey -> arpKey.endsWith((String)name.get()));
    }

    private void doAddArpAttribute(Map<String, Object> result, Set<String> arpKeys, String friendlyName) {
        Map arp = (Map)Map.class.cast(result.getOrDefault("arp", new TreeMap()));
        arp.put("enabled", true);
        Map attributes = (Map)Map.class.cast(arp.getOrDefault(ATTRIBUTES, new TreeMap()));
        arpKeys.stream().filter(arpKey -> arpKey.endsWith(friendlyName)).findFirst().ifPresent(arpKey -> {
            List arpEntry = (List)List.class.cast(attributes.getOrDefault(arpKey, new ArrayList()));
            HashMap<String, String> arpValue = new HashMap<String, String>();
            arpValue.put("source", "idp");
            arpValue.put("value", "*");
            arpEntry.add(arpValue);
            attributes.put(arpKey, arpEntry);
        });
        arp.put(ATTRIBUTES, attributes);
        result.put("arp", arp);
    }

    private void addMetaDataField(Map<String, String> metaDataFields, XMLStreamReader reader, String attributeName, String metaDataKey) {
        Optional optional = this.getAttributeValue(reader, attributeName);
        optional.ifPresent(value -> metaDataFields.put(metaDataKey, (String)value));
    }

    private void addLanguageElement(Map<String, String> metaDataFields, XMLStreamReader reader, String elementName) throws XMLStreamException {
        String language = this.getAttributeValue(reader, "lang").orElse("en");
        if (languages.contains(language)) {
            metaDataFields.put(String.format("%s:%s", elementName, language), reader.getElementText());
        }
    }

    private void addMultiplicity(Map<String, String> result, String format, int multiplicity, String value) {
        List keys = IntStream.range(0, multiplicity).mapToObj(nbr -> String.format(format, nbr)).collect(Collectors.toList());
        long count = result.keySet().stream().filter(key -> keys.contains(key)).count();
        if (count < (long)keys.size()) {
            result.put((String)keys.get((int)count), value);
        }
    }

    private void addCert(Map<String, String> result, String cert) {
        List<String> certDataKeys = Arrays.asList("certData", "certData2", "certData3");
        long count = result.keySet().stream().filter(certDataKeys::contains).count();
        if (count < (long)certDataKeys.size() && !certDataKeys.stream().map(key -> cert.equals(result.get(key))).anyMatch(b -> b)) {
            result.put(certDataKeys.get((int)count), cert);
        }
    }

    private void addLogo(Map<String, String> metaDataFields, XMLStreamReader reader) throws XMLStreamException {
        this.getAttributeValue(reader, "width").ifPresent(width -> metaDataFields.put("logo:0:width", (String)width));
        this.getAttributeValue(reader, "height").ifPresent(height -> metaDataFields.put("logo:0:height", (String)height));
        metaDataFields.put("logo:0:url", reader.getElementText());
    }

    private Optional<String> getAttributeValue(XMLStreamReader reader, String attributeName) {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            QName qName = reader.getAttributeName(i);
            if (!qName.getLocalPart().equalsIgnoreCase(attributeName)) continue;
            return Optional.of(reader.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()));
        }
        return Optional.empty();
    }

    private boolean attributeValueMatches(XMLStreamReader reader, String attributeName, String value) {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            QName qName = reader.getAttributeName(i);
            if (!qName.getLocalPart().equalsIgnoreCase(attributeName)) continue;
            return reader.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()).equalsIgnoreCase(value);
        }
        return false;
    }
}

