/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import com.github.mongobee.Mongobee;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import manage.conf.IndexConfiguration;
import manage.conf.MetaDataAutoConfiguration;
import manage.mongo.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Query;

@Configuration
@ChangeLog
public class MongobeeConfiguration {
    public static final String REVISION_POSTFIX = "_revision";
    private static final Logger LOG = LoggerFactory.getLogger(MongobeeConfiguration.class);
    private static MetaDataAutoConfiguration staticMetaDataAutoConfiguration;
    @Autowired
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    @Autowired
    private MappingMongoConverter mongoConverter;

    @PostConstruct
    public void setUpMongoEscapeCharacterConversion() {
        this.mongoConverter.setMapKeyDotReplacement("@");
    }

    @Bean
    public Mongobee mongobee(@Value(value="${spring.data.mongodb.uri}") String uri) {
        Mongobee runner = new Mongobee(uri);
        runner.setChangeLogsScanPackage("manage.mongo");
        staticMetaDataAutoConfiguration = this.metaDataAutoConfiguration;
        return runner;
    }

    @ChangeSet(order="001", id="createCollections", author="Okke Harsta")
    public void createCollections(MongoTemplate mongoTemplate) {
        Set schemaNames = staticMetaDataAutoConfiguration.schemaNames();
        schemaNames.forEach(schema -> {
            if (!mongoTemplate.collectionExists(schema)) {
                mongoTemplate.createCollection(schema);
                staticMetaDataAutoConfiguration.indexConfigurations(schema).stream().map(arg_0 -> this.indexDefinition(arg_0)).forEach(arg_0 -> ((IndexOperations)mongoTemplate.indexOps(schema)).ensureIndex(arg_0));
                String revision = schema.concat(REVISION_POSTFIX);
                mongoTemplate.createCollection(revision);
                mongoTemplate.indexOps(revision).ensureIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
            }
        });
        Arrays.asList("saml20_sp", "saml20_idp").forEach(collection -> {
            IndexOperations indexOps = mongoTemplate.indexOps(collection);
            indexOps.getIndexInfo().stream().filter(indexInfo -> indexInfo.getName().contains("data.eid")).forEach(indexInfo -> indexOps.dropIndex(indexInfo.getName()));
            indexOps.ensureIndex((IndexDefinition)new Index("data.eid", Sort.Direction.ASC).unique());
            if (indexOps.getIndexInfo().stream().anyMatch(indexInfo -> indexInfo.getName().equals("field_entityid"))) {
                indexOps.dropIndex("field_entityid");
            }
            indexOps.ensureIndex((IndexDefinition)new Index("data.entityid", Sort.Direction.ASC).unique());
            indexOps.ensureIndex((IndexDefinition)new Index("data.state", Sort.Direction.ASC));
            indexOps.ensureIndex((IndexDefinition)new Index("data.allowedall", Sort.Direction.ASC));
            indexOps.ensureIndex((IndexDefinition)new Index("data.allowedEntities.name", Sort.Direction.ASC));
            indexOps.ensureIndex((IndexDefinition)new Index("metaDataFields.coin:institution_id", Sort.Direction.ASC));
        });
        Arrays.asList("saml20_sp_revision", "saml20_idp_revision").forEach(collection -> {
            IndexOperations indexOps = mongoTemplate.indexOps(collection);
            indexOps.ensureIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
        });
        long max = Math.max(this.highestEid(mongoTemplate, "saml20_idp"), this.highestEid(mongoTemplate, "saml20_sp"));
        if (mongoTemplate.collectionExists("sequences")) {
            mongoTemplate.dropCollection("sequences");
        }
        mongoTemplate.createCollection("sequences");
        LOG.info("Creating sequence collection with new start seq {}", (Object)(max + 1L));
        mongoTemplate.save((Object)new Sequence("sequence", Long.valueOf(max + 1L)));
    }

    private Long highestEid(MongoTemplate mongoTemplate, String type) {
        Query query = new Query().limit(1).with(new Sort(Sort.Direction.DESC, new String[]{"data.eid"}));
        query.fields().include("data.eid");
        Map res = (Map)mongoTemplate.findOne(query, Map.class, type);
        if (res == null) {
            return 1L;
        }
        return Long.valueOf(((Map)Map.class.cast(res.get("data"))).get("eid").toString());
    }

    private IndexDefinition indexDefinition(IndexConfiguration indexConfiguration) {
        Index index = new Index();
        indexConfiguration.getFields().forEach(field -> index.on("data.".concat((String)field), Sort.Direction.ASC));
        index.named(indexConfiguration.getName());
        if (indexConfiguration.isUnique()) {
            index.unique();
        }
        return index;
    }
}

