/*
 * Decompiled with CFR 0.152.
 */
package manage.format;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import manage.conf.MetaDataAutoConfiguration;
import manage.format.Exporter;
import manage.format.MetaDataFeedParser;
import manage.model.EntityType;
import org.springframework.core.io.Resource;

public class Importer {
    public static final String META_DATA_FIELDS = "metaDataFields";
    public static final String ARP = "arp";
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private MetaDataFeedParser metaDataFeedParser = new MetaDataFeedParser();

    public Importer(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public Map<String, Object> importXML(Resource resource, EntityType entityType, Optional<String> entityId) throws IOException, XMLStreamException {
        return this.metaDataFeedParser.importXML(resource, entityType, entityId, this.metaDataAutoConfiguration);
    }

    public Map<String, Object> importJSON(EntityType entityType, Map<String, Object> data) throws JsonProcessingException {
        data.entrySet().removeIf(entry -> entry.getValue() == null);
        ConcurrentHashMap<String, Object> json = new ConcurrentHashMap<String, Object>(data);
        Object metaDataFieldsMap = json.get(META_DATA_FIELDS);
        if (metaDataFieldsMap == null || !(metaDataFieldsMap instanceof Map)) {
            this.metaDataAutoConfiguration.validate(this.metaDataAutoConfiguration.getObjectMapper().writeValueAsString(json), entityType.getType());
            return Collections.EMPTY_MAP;
        }
        ConcurrentHashMap metaDataFields = new ConcurrentHashMap((Map)metaDataFieldsMap);
        json.put(META_DATA_FIELDS, metaDataFields);
        if (entityType.equals((Object)EntityType.SP) && json.containsKey("disableConsent")) {
            json.remove("disableConsent");
        }
        if (metaDataFields.values().stream().anyMatch(value -> value instanceof Map)) {
            if (json.containsKey("allowedEntities")) {
                List allowedEntities = (List)json.get("allowedEntities");
                json.put("allowedEntities", allowedEntities.stream().map(name -> Collections.singletonMap("name", name)).collect(Collectors.toList()));
            }
            if (json.containsKey("disableConsent")) {
                List disableConsent = (List)json.get("disableConsent");
                json.put("disableConsent", disableConsent.stream().map(name -> Collections.singletonMap("name", name)).collect(Collectors.toList()));
            }
            ConcurrentHashMap flattened = new ConcurrentHashMap();
            metaDataFields.entrySet().stream().forEach(entry -> {
                Object value = entry.getValue();
                if (value instanceof String) {
                    flattened.put(entry.getKey(), value);
                }
                if (value instanceof Map) {
                    String keyPrefix = (String)entry.getKey();
                    this.flatten(keyPrefix, (Map)value, flattened);
                }
            });
            json.put(META_DATA_FIELDS, flattened);
        }
        Exporter.excludedDataFields.forEach(excluded -> json.remove(excluded));
        this.metaDataAutoConfiguration.validate(this.metaDataAutoConfiguration.getObjectMapper().writeValueAsString(json), entityType.getType());
        return new TreeMap<String, Object>(json);
    }

    private void flatten(String keyPrefix, Map<String, Object> value, Map<String, Object> target) {
        value.forEach((key, entryValue) -> {
            if (entryValue instanceof String) {
                target.put(keyPrefix + ":" + key, entryValue);
            }
            if (entryValue instanceof Map) {
                this.flatten(keyPrefix + ":" + key, (Map)entryValue, target);
            }
        });
    }
}

