/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import manage.api.APIUser;
import manage.conf.Features;
import manage.exception.EndpointNotAllowed;
import manage.format.EngineBlockFormatter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.OrphanMetaData;
import manage.push.Delta;
import manage.push.PrePostComparator;
import manage.repository.MetaDataRepository;
import manage.shibboleth.FederatedUser;
import manage.validations.MetaDataValidator;
import manage.web.PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class SystemController {
    private static final Logger LOG = LoggerFactory.getLogger(SystemController.class);
    private RestTemplate restTemplate;
    private String pushUser;
    private String pushPassword;
    private String pushUri;
    private MetaDataRepository metaDataRepository;
    private JdbcTemplate ebJdbcTemplate;
    private Environment environment;
    private MetaDataValidator metaDataValidator;
    private PrePostComparator prePostComparator = new PrePostComparator();

    @Autowired
    public SystemController(MetaDataRepository metaDataRepository, MetaDataValidator metaDataValidator, DataSource ebDataSource, @Value(value="${push.url}") String pushUri, @Value(value="${push.user}") String user, @Value(value="${push.password}") String password, Environment environment) throws MalformedURLException {
        this.metaDataRepository = metaDataRepository;
        this.pushUri = pushUri;
        this.pushUser = user;
        this.pushPassword = password;
        this.restTemplate = new RestTemplate(this.getRequestFactory());
        this.ebJdbcTemplate = new JdbcTemplate(ebDataSource);
        this.environment = environment;
        this.metaDataValidator = metaDataValidator;
    }

    @GetMapping(value={"/client/playground/pushPreview"})
    public Map<String, Map<String, Map<String, Object>>> pushPreview() {
        EngineBlockFormatter formatter = new EngineBlockFormatter();
        HashMap<String, Map<String, Map<String, Object>>> results = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap connections = new HashMap();
        results.put("connections", connections);
        List serviceProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "saml20_sp");
        serviceProviders.forEach(sp -> connections.put(sp.getId(), formatter.parseServiceProvider(sp)));
        List identityProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "saml20_idp");
        identityProviders.forEach(idp -> connections.put(idp.getId(), formatter.parseIdentityProvider(idp)));
        return results;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/push"})
    public ResponseEntity<Map> push(FederatedUser federatedUser) {
        if (!federatedUser.featureAllowed(Features.PUSH)) {
            throw new EndpointNotAllowed();
        }
        return this.doPush();
    }

    @PreAuthorize(value="hasRole('PUSH')")
    @GetMapping(value={"/internal/push"})
    public ResponseEntity<Map> pushInternal(APIUser apiUser) {
        LOG.info("Push initiated by {}", (Object)apiUser.getName());
        return this.doPush();
    }

    private ResponseEntity<Map> doPush() {
        ResponseEntity response;
        List preProvidersData = this.ebJdbcTemplate.queryForList("SELECT * FROM sso_provider_roles_eb5 ORDER BY id ASC");
        Map json = this.pushPreview();
        HttpStatus statusCode = HttpStatus.OK;
        if (!this.environment.acceptsProfiles(new String[]{"dev"})) {
            response = this.restTemplate.postForEntity(this.pushUri, (Object)json, String.class, new Object[0]);
            statusCode = response.getStatusCode();
        } else {
            response = new ResponseEntity((Object)"No performed push because of dev environment", HttpStatus.OK);
        }
        List postProvidersData = this.ebJdbcTemplate.queryForList("SELECT * FROM sso_provider_roles_eb5 ORDER BY id ASC");
        Set deltas = this.prePostComparator.compare(preProvidersData, postProvidersData);
        List<String> knownDeltas = Arrays.asList("id", "name_id_formats");
        List realDeltas = deltas.stream().filter(delta -> !knownDeltas.contains(delta.getAttribute())).collect(Collectors.toList());
        realDeltas.sort(Comparator.comparing(Delta::getEntityId));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", statusCode);
        result.put("response", response);
        result.put("deltas", realDeltas);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @GetMapping(value={"/client/playground/validate"})
    public Map<String, Object> validate(FederatedUser federatedUser) {
        if (!federatedUser.featureAllowed(Features.VALIDATION)) {
            throw new EndpointNotAllowed();
        }
        return this.metaDataValidator.validateMigration();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/playground/deleteOrphans"})
    public void deleteOrphans() {
        this.doDeleteOrphans();
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    @DeleteMapping(value={"/internal/playground/deleteOrphans"})
    public void deleteOrphansInternal() {
        this.doDeleteOrphans();
    }

    private void doDeleteOrphans() {
        List orphans = this.orphans();
        orphans.forEach(orphanMetaData -> {
            MetaData metaData = this.metaDataRepository.findById(orphanMetaData.getId(), orphanMetaData.getCollection());
            List entries = (List)metaData.getData().get(orphanMetaData.getReferencedCollectionName());
            List newEntries = entries.stream().filter(entry -> !entry.get("name").equals(orphanMetaData.getMissingEntityId())).collect(Collectors.toList());
            metaData.getData().put(orphanMetaData.getReferencedCollectionName(), newEntries);
            metaData.getData().put("revisionnote", "Removed reference to non-existent entityID");
            MetaData previous = this.metaDataRepository.findById(metaData.getId(), orphanMetaData.getCollection());
            previous.revision(UUID.randomUUID().toString());
            this.metaDataRepository.save(previous);
            metaData.promoteToLatest("System");
            this.metaDataRepository.update(metaData);
        });
    }

    @GetMapping(value={"/client/playground/orphans", "/internal/playground/orphans"})
    public List<OrphanMetaData> orphans() {
        return Stream.of(EntityType.values()).map(arg_0 -> this.orphanMetaData(arg_0)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private Stream<OrphanMetaData> orphanMetaData(EntityType type) {
        Query query = new Query();
        query.fields().include("data.entityid").include("type").include("data.metaDataFields.name:en").include("data.allowedEntities.name").include("data.disableConsent.name");
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"data.allowedEntities").exists(true), Criteria.where((String)"data.disableConsent").exists(true)}));
        MongoTemplate mongoTemplate = this.metaDataRepository.getMongoTemplate();
        List metaDataWithReferences = mongoTemplate.find(query, MetaData.class, type.getType());
        HashMap groupedByEntityIdReference = new HashMap();
        Stream.of("allowedEntities", "disableConsent").forEach(propertyName -> metaDataWithReferences.stream().forEach(metaData -> {
            List entries = (List)metaData.getData().get(propertyName);
            if (!CollectionUtils.isEmpty((Collection)entries)) {
                entries.forEach(ae -> groupedByEntityIdReference.computeIfAbsent((String)ae.get("name"), k -> new HashMap()).computeIfAbsent(propertyName, m -> new ArrayList()).add(metaData));
            }
        }));
        String oppositeCollectionName = type.equals((Object)EntityType.IDP) ? EntityType.SP.getType() : EntityType.IDP.getType();
        return groupedByEntityIdReference.entrySet().stream().filter(entry -> !mongoTemplate.exists((Query)new BasicQuery("{\"data.entityid\":\"" + (String)entry.getKey() + "\"}"), oppositeCollectionName)).map(entry -> ((Map)entry.getValue()).entrySet().stream().map(m -> ((List)m.getValue()).stream().map(metaData -> new OrphanMetaData((String)entry.getKey(), (String)metaData.getData().get("entityid"), (String)((Map)Map.class.cast(metaData.getData().get("metaDataFields"))).get("name:en"), (String)m.getKey(), metaData.getId(), type.getType())))).flatMap(Function.identity()).flatMap(Function.identity());
    }

    private ClientHttpRequestFactory getRequestFactory() throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(10L, TimeUnit.SECONDS);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.pushUser, this.pushPassword));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, this.pushUri);
    }
}

