/*
 * Decompiled with CFR 0.152.
 */
package manage.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.IntStream;
import manage.model.EntityType;
import manage.model.MetaData;
import org.springframework.util.StringUtils;

public class EngineBlockFormatter {
    private static final Map<String, Optional> commonAttributes = new TreeMap();
    private static final Map<String, Optional> spAttributes = new TreeMap();
    private static final Map<String, Optional> idpAttributes = new TreeMap();
    private static final int BEGIN_INDEX = "metadata:".length();

    public Map<String, Object> parseServiceProvider(MetaData metaDataContainer) {
        Map source = metaDataContainer.getData();
        TreeMap<String, Object> serviceProvider = new TreeMap<String, Object>();
        serviceProvider.put("type", EntityType.SP.getJanusDbValue());
        this.addCommonProviderAttributes(source, serviceProvider);
        this.addNameIDFormats(source, serviceProvider);
        this.addAttributeReleasePolicy(source, serviceProvider);
        this.addAssertionConsumerService(source, serviceProvider);
        spAttributes.forEach((key, value) -> this.addToResult(source, serviceProvider, key, value));
        this.removeEmptyValues(serviceProvider);
        return serviceProvider;
    }

    public Map<String, Object> parseIdentityProvider(MetaData metaDataContainer) {
        Map source = metaDataContainer.getData();
        TreeMap<String, Object> identityProvider = new TreeMap<String, Object>();
        identityProvider.put("type", EntityType.IDP.getJanusDbValue());
        List disableConsent = (List)source.get("disableConsent");
        identityProvider.put("disable_consent_connections", disableConsent == null ? new ArrayList() : disableConsent);
        this.addCommonProviderAttributes(source, identityProvider);
        this.addSingleSignOnService(source, identityProvider);
        idpAttributes.forEach((key, value) -> this.addToResult(source, identityProvider, key, value));
        this.addShibMdScopes(source, identityProvider);
        this.removeEmptyValues(identityProvider);
        return identityProvider;
    }

    private void addCommonProviderAttributes(Map<String, Object> source, Map<String, Object> result) {
        commonAttributes.forEach((key, value) -> this.addToResult(source, result, key, value));
        this.addLogo(source, result);
        this.addContactPersons(source, result);
        this.addSingleLogOutService(source, result);
        this.addRedirectSign(source, result);
        List allowedEntities = (List)source.get("allowedEntities");
        result.put("allowed_connections", allowedEntities == null ? new ArrayList() : allowedEntities);
        result.put("allow_all_entities", source.get("allowedall"));
    }

    private void addLogo(Map<String, Object> source, Map<String, Object> result) {
        result = (Map)result.computeIfAbsent((String)"metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        String height = (String)metaDataFields.get("logo:0:height");
        String url = (String)metaDataFields.get("logo:0:url");
        String width = (String)metaDataFields.get("logo:0:width");
        if (StringUtils.hasText((String)height) || StringUtils.hasText((String)url) || StringUtils.hasText((String)width)) {
            ArrayList logoContainer = new ArrayList();
            HashMap logo = new HashMap();
            this.putIfHasText("height", height, logo);
            this.putIfHasText("url", url, logo);
            this.putIfHasText("width", width, logo);
            logoContainer.add(logo);
            result.put("logo", logoContainer);
        }
    }

    private void removeEmptyValues(Map<String, Object> result) {
        result.entrySet().removeIf(entry -> {
            if (entry.getValue() instanceof Map && !((String)entry.getKey()).equals("arp_attributes")) {
                Map map = (Map)entry.getValue();
                this.removeEmptyValues(map);
                return map.isEmpty();
            }
            return false;
        });
    }

    private void addContactPersons(Map<String, Object> source, Map<String, Object> result) {
        Map metadata = (Map)result.computeIfAbsent("metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        IntStream.range(0, 4).forEach(i -> {
            String contactType = (String)metaDataFields.get("contacts:" + i + ":contactType");
            String emailAddress = (String)metaDataFields.get("contacts:" + i + ":emailAddress");
            String telephoneNumber = (String)metaDataFields.get("contacts:" + i + ":telephoneNumber");
            String givenName = (String)metaDataFields.get("contacts:" + i + ":givenName");
            String surName = (String)metaDataFields.get("contacts:" + i + ":surName");
            if (StringUtils.hasText((String)contactType) || StringUtils.hasText((String)emailAddress) || StringUtils.hasText((String)telephoneNumber) || StringUtils.hasText((String)givenName) || StringUtils.hasText((String)surName)) {
                ArrayList contactsContainer = (ArrayList)metadata.computeIfAbsent("contacts", key -> new ArrayList());
                HashMap contact = new HashMap();
                this.putIfHasText("contactType", contactType, contact);
                this.putIfHasText("emailAddress", emailAddress, contact);
                this.putIfHasText("telephoneNumber", telephoneNumber, contact);
                this.putIfHasText("givenName", givenName, contact);
                this.putIfHasText("surName", surName, contact);
                contactsContainer.add(contact);
            }
        });
    }

    private void putIfHasText(String key, String value, Map<String, String> result) {
        if (StringUtils.hasText((String)value)) {
            result.put(key, value);
        }
    }

    private void addSingleLogOutService(Map<String, Object> source, Map<String, Object> result) {
        result = (Map)result.computeIfAbsent((String)"metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        String location = (String)metaDataFields.get("SingleLogoutService_Location");
        String binding = (String)metaDataFields.get("SingleLogoutService_Binding");
        if (!StringUtils.hasText((String)location) && !StringUtils.hasText((String)binding)) {
            return;
        }
        ArrayList subList = new ArrayList();
        TreeMap map = new TreeMap();
        this.putIfHasText("Location", location, map);
        this.putIfHasText("Binding", binding, map);
        subList.add(map);
        result.put("SingleLogoutService", subList);
    }

    private void addRedirectSign(Map<String, Object> source, Map<String, Object> result) {
        result = (Map)result.computeIfAbsent((String)"metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        String redirectSign = (String)metaDataFields.get("redirect.sign");
        if (StringUtils.hasText((String)redirectSign)) {
            HashMap<String, Boolean> redirect = new HashMap<String, Boolean>();
            redirect.put("sign", redirectSign.equalsIgnoreCase("1"));
            result.put("redirect", redirect);
        }
    }

    private void addNameIDFormats(Map<String, Object> source, Map<String, Object> result) {
        Map metadata = (Map)result.computeIfAbsent("metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        IntStream.range(0, 3).forEach(i -> {
            String nameIdFormat = (String)metaDataFields.get("NameIDFormats:" + i);
            if (StringUtils.hasText((String)nameIdFormat)) {
                Set nameIDFormats = (Set)metadata.computeIfAbsent("NameIDFormats", key -> new HashSet());
                nameIDFormats.add(nameIdFormat);
            }
        });
    }

    private void addAttributeReleasePolicy(Map<String, Object> source, Map<String, Object> result) {
        Object possibleArp = source.get("arp");
        if (possibleArp == null || possibleArp instanceof List) {
            HashMap arpResult = new HashMap();
            result.put("arp_attributes", arpResult);
            return;
        }
        Map arp = (Map)possibleArp;
        Object enabled = arp.get("enabled");
        if (enabled != null && ((Boolean)Boolean.class.cast(enabled)).booleanValue()) {
            Object possibleAttributes = arp.get("attributes");
            if (possibleAttributes != null && possibleAttributes instanceof List) {
                List listAttributes = (List)possibleAttributes;
                result.put("arp_attributes", listAttributes);
            } else if (possibleAttributes != null && possibleAttributes instanceof Map) {
                Map attributes = (Map)possibleAttributes;
                Collection values = attributes.values();
                values.forEach(arpValues -> arpValues.forEach(map -> map.entrySet().removeIf(entry -> ((String)entry.getKey()).equals("source") && ((String)entry.getValue()).equals("idp"))));
                result.put("arp_attributes", attributes);
            }
        }
    }

    private void addSingleSignOnService(Map<String, Object> source, Map<String, Object> result) {
        Map metadata = (Map)result.computeIfAbsent("metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        IntStream.range(0, 10).forEach(i -> {
            String binding = (String)metaDataFields.get("SingleSignOnService:" + i + ":Binding");
            String location = (String)metaDataFields.get("SingleSignOnService:" + i + ":Location");
            if (StringUtils.hasText((String)binding) || StringUtils.hasText((String)location)) {
                ArrayList singleSignOnServiceContainer = (ArrayList)metadata.computeIfAbsent("SingleSignOnService", key -> new ArrayList());
                HashMap singleSignOnService = new HashMap();
                this.putIfHasText("Binding", binding, singleSignOnService);
                this.putIfHasText("Location", location, singleSignOnService);
                singleSignOnServiceContainer.add(singleSignOnService);
            }
        });
    }

    private void addShibMdScopes(Map<String, Object> source, Map<String, Object> result) {
        Map metadata = (Map)result.computeIfAbsent("metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        IntStream.range(0, 5).forEach(i -> {
            String allowed = (String)String.class.cast(metaDataFields.get("shibmd:scope:" + i + ":allowed"));
            String regexp = (String)String.class.cast(metaDataFields.get("shibmd:scope:" + i + ":regexp"));
            if (StringUtils.hasText((String)allowed) || StringUtils.hasText((String)regexp)) {
                Map shibmdContainer = (Map)metadata.computeIfAbsent("shibmd", key -> new HashMap());
                List scopeContainer = shibmdContainer.computeIfAbsent("scope", key -> new ArrayList());
                HashMap<String, String> scope = new HashMap<String, String>();
                if (StringUtils.hasText((String)allowed)) {
                    scope.put("allowed", allowed);
                }
                if (StringUtils.hasText((String)"regexp")) {
                    scope.put("regexp", regexp);
                }
                scopeContainer.add(scope);
            }
        });
    }

    private void addAssertionConsumerService(Map<String, Object> source, Map<String, Object> result) {
        Map metadata = (Map)result.computeIfAbsent("metadata", key -> new TreeMap());
        Map metaDataFields = (Map)source.get("metaDataFields");
        IntStream.range(0, 10).forEach(i -> {
            String binding = (String)metaDataFields.get("AssertionConsumerService:" + i + ":Binding");
            String location = (String)metaDataFields.get("AssertionConsumerService:" + i + ":Location");
            String index = (String)metaDataFields.get("AssertionConsumerService:" + i + ":index");
            if (StringUtils.hasText((String)binding) || StringUtils.hasText((String)location)) {
                ArrayList assertionConsumerServiceContainer = (ArrayList)metadata.computeIfAbsent("AssertionConsumerService", key -> new ArrayList());
                HashMap assertionConsumerService = new HashMap();
                this.putIfHasText("Binding", binding, assertionConsumerService);
                this.putIfHasText("Location", location, assertionConsumerService);
                this.putIfHasText("Index", index, assertionConsumerService);
                assertionConsumerServiceContainer.add(assertionConsumerService);
            }
        });
    }

    protected void addToResult(Map<String, Object> source, Map<String, Object> result, String compoundName, Optional<String> convertTo) {
        List<String> parts = Arrays.asList(compoundName.split(":"));
        if (parts.size() == 1) {
            Object o = source.get(compoundName);
            if (o != null) {
                result.put((String)convertTo.orElse(compoundName), (Object)o);
            }
            return;
        }
        Iterator<String> iterator = parts.iterator();
        String value = null;
        while (iterator.hasNext()) {
            String part = iterator.next();
            if (part.equals("metadata")) {
                result = (Map)result.computeIfAbsent((String)part, key -> new TreeMap());
                value = (String)((Map)source.get("metaDataFields")).get(compoundName.substring(BEGIN_INDEX));
                continue;
            }
            if (iterator.hasNext()) {
                result = (Map)result.computeIfAbsent(part, key -> new TreeMap());
                continue;
            }
            if (value == null) continue;
            result.put(convertTo.orElse(part), value);
        }
    }

    static {
        commonAttributes.put("entityid", Optional.of("name"));
        commonAttributes.put("metadata:name:nl", Optional.empty());
        commonAttributes.put("metadata:name:en", Optional.empty());
        commonAttributes.put("metadata:displayName:en", Optional.empty());
        commonAttributes.put("metadata:displayName:nl", Optional.empty());
        commonAttributes.put("metadata:description:en", Optional.empty());
        commonAttributes.put("metadata:description:nl", Optional.empty());
        commonAttributes.put("metadata:OrganizationName:nl", Optional.empty());
        commonAttributes.put("metadata:OrganizationName:en", Optional.empty());
        commonAttributes.put("metadata:OrganizationDisplayName:nl", Optional.empty());
        commonAttributes.put("metadata:OrganizationDisplayName:en", Optional.empty());
        commonAttributes.put("metadata:OrganizationURL:nl", Optional.empty());
        commonAttributes.put("metadata:OrganizationURL:en", Optional.empty());
        commonAttributes.put("metadata:keywords:en", Optional.empty());
        commonAttributes.put("metadata:keywords:nl", Optional.empty());
        commonAttributes.put("metadata:url:en", Optional.empty());
        commonAttributes.put("metadata:url:nl", Optional.empty());
        commonAttributes.put("metadata:coin:publish_in_edugain", Optional.empty());
        commonAttributes.put("metadata:certData", Optional.empty());
        commonAttributes.put("metadata:certData2", Optional.empty());
        commonAttributes.put("metadata:certData3", Optional.empty());
        commonAttributes.put("state", Optional.empty());
        commonAttributes.put("metadata:NameIDFormat", Optional.empty());
        commonAttributes.put("metadata:coin:disable_scoping", Optional.empty());
        commonAttributes.put("metadata:coin:additional_logging", Optional.empty());
        commonAttributes.put("manipulation", Optional.of("manipulation_code"));
        spAttributes.put("metadata:coin:transparant_issuer", Optional.empty());
        spAttributes.put("metadata:coin:trusted_proxy", Optional.empty());
        spAttributes.put("metadata:coin:display_unconnected_idps_wayf", Optional.empty());
        spAttributes.put("metadata:coin:eula", Optional.empty());
        spAttributes.put("metadata:coin:do_not_add_attribute_aliases", Optional.empty());
        spAttributes.put("metadata:coin:policy_enforcement_decision_required", Optional.empty());
        spAttributes.put("metadata:coin:attribute_aggregation_required", Optional.empty());
        spAttributes.put("metadata:coin:no_consent_required", Optional.empty());
        spAttributes.put("metadata:coin:signature_method", Optional.empty());
        idpAttributes.put("metadata:coin:guest_qualifier", Optional.empty());
        idpAttributes.put("metadata:coin:schachomeorganization", Optional.empty());
        idpAttributes.put("metadata:coin:hidden", Optional.empty());
    }
}

