/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import manage.api.APIUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.exception.DuplicateEntityIdException;
import manage.exception.ResourceNotFoundException;
import manage.format.Exporter;
import manage.format.Importer;
import manage.hook.MetaDataHook;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.MetaDataUpdate;
import manage.model.RevisionRestore;
import manage.model.XML;
import manage.repository.MetaDataRepository;
import manage.shibboleth.FederatedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaDataController {
    public static final String REQUESTED_ATTRIBUTES = "REQUESTED_ATTRIBUTES";
    public static final String ALL_ATTRIBUTES = "ALL_ATTRIBUTES";
    public static final String LOGICAL_OPERATOR_IS_AND = "LOGICAL_OPERATOR_IS_AND";
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataController.class);
    private MetaDataRepository metaDataRepository;
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private MetaDataHook metaDataHook;
    private Importer importer;
    private Exporter exporter;

    @Autowired
    public MetaDataController(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, ResourceLoader resourceLoader, MetaDataHook metaDataHook, @Value(value="${metadata_export_path}") String metadataExportPath) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataHook = metaDataHook;
        this.importer = new Importer(metaDataAutoConfiguration);
        this.exporter = new Exporter(Clock.systemDefaultZone(), resourceLoader, metadataExportPath);
    }

    @GetMapping(value={"/client/template/{type}"})
    public MetaData template(@PathVariable(value="type") String type) {
        return new MetaData(type, (Map)Map.class.cast(this.metaDataAutoConfiguration.metaDataTemplate(type)));
    }

    @GetMapping(value={"/client/metadata/{type}/{id}", "/internal/metadata/{type}/{id}"})
    public MetaData get(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        MetaData metaData = this.metaDataRepository.findById(id, type);
        if (metaData == null) {
            throw new ResourceNotFoundException(String.format("MetaData type %s with id %s does not exist", type, id));
        }
        return metaData;
    }

    @GetMapping(value={"/client/metadata/configuration"})
    public List<Map<String, Object>> configuration() {
        return this.metaDataAutoConfiguration.schemaRepresentations();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/metadata"})
    public MetaData post(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        return this.doPost(metaData, federatedUser.getUid());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/metadata"})
    public MetaData postInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.doPost(metaData, apiUser.getName());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/new-sp"})
    public MetaData newSP(@Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        Map innerJson = this.importer.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        String entityId = (String)String.class.cast(innerJson.get("entityid"));
        List result = this.metaDataRepository.search(EntityType.SP.getType(), Collections.singletonMap("entityid", entityId), Collections.emptyList(), Boolean.valueOf(false), Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty((Collection)result)) {
            throw new DuplicateEntityIdException(entityId);
        }
        this.addDefaultSpData(innerJson);
        MetaData metaData = new MetaData(EntityType.SP.getType(), innerJson);
        return this.doPost(metaData, apiUser.getName());
    }

    private void addDefaultSpData(Map<String, Object> innerJson) {
        innerJson.put("allowedall", true);
        innerJson.put("state", "testaccepted");
        innerJson.put("allowedEntities", new ArrayList());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/update-sp/{id}/{version}"})
    public MetaData updateSP(@PathVariable(value="id") String id, @PathVariable(value="version") Long version, @Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        MetaData metaData = this.get(EntityType.SP.getType(), id);
        Map innerJson = this.importer.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.addDefaultSpData(innerJson);
        metaData.setData(innerJson);
        metaData.setVersion(version);
        return this.doPut(metaData, apiUser.getName());
    }

    @GetMapping(value={"/internal/sp-metadata/{id}"})
    public String exportXml(@PathVariable(value="id") String id) throws IOException, XMLStreamException {
        MetaData metaData = this.get(EntityType.SP.getType(), id);
        return this.exporter.exportToXml(metaData);
    }

    private MetaData doPost(@Validated @RequestBody MetaData metaData, String uid) throws JsonProcessingException {
        this.validate(metaData);
        metaData = this.metaDataHook.prePost(metaData);
        Long eid = this.metaDataRepository.incrementEid();
        metaData.initial(UUID.randomUUID().toString(), uid, eid);
        LOG.info("Saving new metaData {} by {}", (Object)metaData.getId(), (Object)uid);
        return this.metaDataRepository.save(metaData);
    }

    @PreAuthorize(value="hasRole('READ')")
    @PostMapping(value={"/internal/validate/metadata"})
    public ResponseEntity<Object> validateMetaData(@Validated @RequestBody MetaData metaData) throws JsonProcessingException {
        this.validate(metaData);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/metadata/{type}/{id}"})
    public boolean remove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, FederatedUser user) {
        MetaData current = this.metaDataRepository.findById(id, type);
        current = this.metaDataHook.preDelete(current);
        this.metaDataRepository.remove(current);
        LOG.info("Deleted metaData {} by {}", (Object)current.getId(), (Object)user.getUid());
        current.terminate(UUID.randomUUID().toString());
        this.metaDataRepository.save(current);
        return true;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata"})
    @Transactional
    public MetaData put(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        return this.doPut(metaData, federatedUser.getUid());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"/internal/metadata"})
    @Transactional
    public MetaData putInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.doPut(metaData, apiUser.getName());
    }

    private MetaData doPut(@Validated @RequestBody MetaData metaData, String updatedBy) throws JsonProcessingException {
        this.validate(metaData);
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        metaData = this.metaDataHook.prePut(previous, metaData);
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest(updatedBy);
        this.metaDataRepository.update(metaData);
        LOG.info("Updated metaData {} by {}", (Object)metaData.getId(), (Object)updatedBy);
        return metaData;
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"internal/merge"})
    @Transactional
    public MetaData update(@Validated @RequestBody MetaDataUpdate metaDataUpdate, APIUser apiUser) throws JsonProcessingException {
        String id = metaDataUpdate.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        previous.revision(UUID.randomUUID().toString());
        MetaData metaData = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        metaData.promoteToLatest(apiUser.getName());
        metaData.merge(metaDataUpdate);
        this.validate(metaData);
        this.metaDataRepository.save(previous);
        this.metaDataRepository.update(metaData);
        return metaData;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreDeleted"})
    @Transactional
    public MetaData restoreDeleted(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        if (parent != null) {
            throw new IllegalArgumentException("Parent is not null");
        }
        String newId = revision.getRevision().getParentId();
        revision.getRevision().deTerminate(newId);
        this.metaDataRepository.update(revision);
        revision.restoreToLatest(newId, Long.valueOf(0L), federatedUser.getUid(), revision.getRevision().getNumber(), revisionRestore.getParentType());
        this.validate(revision);
        this.metaDataRepository.save(revision);
        LOG.info("Restored deleted revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreRevision"})
    @Transactional
    public MetaData restoreRevision(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        revision.restoreToLatest(parent.getId(), parent.getVersion(), federatedUser.getUid(), parent.getRevision().getNumber(), revisionRestore.getParentType());
        this.validate(revision);
        this.metaDataRepository.update(revision);
        parent.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(parent);
        LOG.info("Restored revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    @GetMapping(value={"/client/revisions/{type}/{parentId}"})
    public List<MetaData> revisions(@PathVariable(value="type") String type, @PathVariable(value="parentId") String parentId) {
        return this.metaDataRepository.revisions(type.concat("_revision"), parentId);
    }

    @GetMapping(value={"/client/autocomplete/{type}"})
    public List<Map> autoCompleteEntities(@PathVariable(value="type") String type, @RequestParam(value="query") String query) {
        return this.metaDataRepository.autoComplete(type, query);
    }

    @GetMapping(value={"/client/whiteListing/{type}"})
    public List<Map> whiteListing(@PathVariable(value="type") String type) {
        return this.metaDataRepository.whiteListing(type);
    }

    @PostMapping(value={"/client/search/{type}", "/internal/search/{type}"})
    public List<Map> searchEntities(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties, @RequestParam(required=false, defaultValue="false") boolean nested) {
        List requestedAttributes = (List)List.class.cast(properties.getOrDefault(REQUESTED_ATTRIBUTES, new ArrayList()));
        Boolean allAttributes = (Boolean)Boolean.class.cast(properties.getOrDefault(ALL_ATTRIBUTES, false));
        Boolean logicalOperatorIsAnd = (Boolean)Boolean.class.cast(properties.getOrDefault(LOGICAL_OPERATOR_IS_AND, true));
        properties.remove(REQUESTED_ATTRIBUTES);
        properties.remove(ALL_ATTRIBUTES);
        properties.remove(LOGICAL_OPERATOR_IS_AND);
        List search = this.metaDataRepository.search(type, properties, requestedAttributes, allAttributes, logicalOperatorIsAnd);
        return nested ? search.stream().map(m -> this.exporter.nestMetaData(m, type)).collect(Collectors.toList()) : search;
    }

    @GetMapping(value={"/client/rawSearch/{type}", "/internal/rawSearch/{type}"})
    public List<MetaData> rawSearch(@PathVariable(value="type") String type, @RequestParam(value="query") String query) throws UnsupportedEncodingException {
        if (query.startsWith("%")) {
            query = URLDecoder.decode(query, "UTF-8");
        }
        return this.metaDataRepository.findRaw(type, query);
    }

    private void validate(MetaData metaData) throws JsonProcessingException {
        String json = this.metaDataAutoConfiguration.getObjectMapper().writeValueAsString((Object)metaData.getData());
        this.metaDataAutoConfiguration.validate(json, metaData.getType());
    }
}

