/*
 * Decompiled with CFR 0.152.
 */
package manage.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import manage.conf.MetaDataAutoConfiguration;
import manage.model.EntityType;
import org.springframework.core.io.Resource;

public class MetaDataFeedParser {
    private static final List<String> languages = Arrays.asList("en", "nl");
    private static final String ATTRIBUTES = "attributes";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Map<String, Object> importXML(Resource xml, EntityType entityType, Optional<String> entityIDOptional, MetaDataAutoConfiguration metaDataAutoConfiguration) throws XMLStreamException, IOException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(xml.getInputStream());
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        TreeMap metaDataFields = new TreeMap();
        result.put("metaDataFields", metaDataFields);
        boolean inKeyDescriptor = false;
        boolean inContact = true;
        boolean inUIInfo = false;
        boolean inCorrectEntityDescriptor = !entityIDOptional.isPresent();
        boolean inAttributeConsumingService = false;
        boolean inEntityAttributes = false;
        result.put("type", entityType.getJanusDbValue());
        boolean isSp = entityType.equals((Object)EntityType.SP);
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        block78: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    switch (reader.getLocalName()) {
                        case "EntityDescriptor": {
                            Optional optional = this.getAttributeValue(reader, "entityID");
                            if (!optional.isPresent()) break;
                            if (entityIDOptional.isPresent()) {
                                inCorrectEntityDescriptor = entityIDOptional.get().equalsIgnoreCase((String)optional.get());
                            }
                            if (!inCorrectEntityDescriptor) break;
                            result.put("entityid", optional.get());
                            continue block78;
                        }
                        case "SPSSODescriptor": {
                            if (!inCorrectEntityDescriptor || !isSp) break;
                            Set set = this.arpKeys(EntityType.SP, metaDataAutoConfiguration, isSp);
                            Map map = this.arpAliases(EntityType.SP, metaDataAutoConfiguration, isSp);
                            TreeMap<String, Serializable> arp = new TreeMap<String, Serializable>();
                            arp.put("enabled", Boolean.valueOf(false));
                            TreeMap attributes = new TreeMap();
                            arp.put(ATTRIBUTES, attributes);
                            result.put("arp", arp);
                            continue block78;
                        }
                        case "KeyDescriptor": {
                            if (!inCorrectEntityDescriptor) continue block78;
                            Optional use = this.getAttributeValue(reader, "use");
                            if (use.isPresent() && !((String)use.get()).equals("signing")) break;
                            inKeyDescriptor = true;
                            continue block78;
                        }
                        case "X509Certificate": {
                            if (!inCorrectEntityDescriptor) continue block78;
                            if (!inKeyDescriptor) break;
                            inKeyDescriptor = false;
                            String cert = reader.getElementText().replaceAll("[\n\r]", "").trim();
                            this.addCert(metaDataFields, cert);
                            continue block78;
                        }
                        case "SingleLogoutService": {
                            if (!inCorrectEntityDescriptor || !isSp) break;
                            this.addMetaDataField(metaDataFields, reader, "Binding", "SingleLogoutService_Binding");
                            this.addMetaDataField(metaDataFields, reader, "Location", "SingleLogoutService_Location");
                            continue block78;
                        }
                        case "AssertionConsumerService": {
                            if (!inCorrectEntityDescriptor || !isSp) break;
                            Optional bindingOpt = this.getAttributeValue(reader, "Binding");
                            bindingOpt.ifPresent(binding -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Binding", 10, binding));
                            Optional locationOpt = this.getAttributeValue(reader, "Location");
                            locationOpt.ifPresent(location -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Location", 10, location));
                            Optional indexOpt = this.getAttributeValue(reader, "index");
                            indexOpt.ifPresent(index -> this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:index", 10, index));
                            continue block78;
                        }
                        case "SingleSignOnService": {
                            if (!inCorrectEntityDescriptor) break;
                            if (isSp) continue block78;
                            Optional bindingOpt = this.getAttributeValue(reader, "Binding");
                            bindingOpt.ifPresent(binding -> this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Binding", 10, binding));
                            Optional locationOpt = this.getAttributeValue(reader, "Location");
                            locationOpt.ifPresent(location -> this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Location", 10, location));
                            continue block78;
                        }
                        case "RegistrationInfo": {
                            if (!inCorrectEntityDescriptor) break;
                            this.getAttributeValue(reader, "registrationAuthority").ifPresent(authority -> metaDataFields.put("mdrpi:RegistrationInfo", authority));
                            continue block78;
                        }
                        case "RegistrationPolicy": {
                            if (!inCorrectEntityDescriptor) break;
                            this.addLanguageElement(metaDataFields, reader, "mdrpi:RegistrationPolicy");
                            continue block78;
                        }
                        case "AttributeConsumingService": {
                            inAttributeConsumingService = inCorrectEntityDescriptor;
                            continue block78;
                        }
                        case "UIInfo": {
                            inUIInfo = inCorrectEntityDescriptor;
                            continue block78;
                        }
                        case "DisplayName": {
                            if (!inUIInfo) break;
                            this.addLanguageElement(metaDataFields, reader, "name");
                            continue block78;
                        }
                        case "Logo": {
                            if (!inUIInfo) break;
                            this.addLogo(metaDataFields, reader);
                            continue block78;
                        }
                        case "Description": {
                            if (!inUIInfo) break;
                            this.addLanguageElement(metaDataFields, reader, "description");
                            continue block78;
                        }
                        case "PrivacyStatementURL": {
                            if (!inUIInfo) break;
                            this.addLanguageElement(metaDataFields, reader, "mdui:PrivacyStatementURL");
                            continue block78;
                        }
                        case "ServiceName": {
                            if (!inAttributeConsumingService) break;
                            this.addLanguageElement(metaDataFields, reader, "name");
                            continue block78;
                        }
                        case "ServiceDescription": {
                            if (!inAttributeConsumingService) break;
                            this.addLanguageElement(metaDataFields, reader, "description");
                            continue block78;
                        }
                        case "RequestedAttribute": {
                            void var17_20;
                            void var16_17;
                            if (!inAttributeConsumingService || !isSp) break;
                            this.addArpAttribute(result, reader, (Set)var16_17, (Map)var17_20);
                            continue block78;
                        }
                        case "OrganizationName": {
                            if (!inCorrectEntityDescriptor) continue block78;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationName");
                            continue block78;
                        }
                        case "OrganizationDisplayName": {
                            if (!inCorrectEntityDescriptor) continue block78;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationDisplayName");
                            continue block78;
                        }
                        case "OrganizationURL": {
                            if (!inCorrectEntityDescriptor) continue block78;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationURL");
                            continue block78;
                        }
                        case "ContactPerson": {
                            if (!inCorrectEntityDescriptor) continue block78;
                            String contactType = this.getAttributeValue(reader, "contactType").orElse("other");
                            this.addMultiplicity(metaDataFields, "contacts:%s:contactType", 4, contactType);
                            inContact = true;
                            continue block78;
                        }
                        case "GivenName": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:givenName", 4, reader.getElementText());
                            continue block78;
                        }
                        case "SurName": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:surName", 4, reader.getElementText());
                            continue block78;
                        }
                        case "EmailAddress": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:emailAddress", 4, reader.getElementText().replaceAll(Pattern.quote("mailto:"), ""));
                            continue block78;
                        }
                        case "TelephoneNumber": {
                            if (!inCorrectEntityDescriptor || !inContact) break;
                            this.addMultiplicity(metaDataFields, "contacts:%s:telephoneNumber", 4, reader.getElementText());
                            continue block78;
                        }
                        case "EntityAttributes": {
                            inEntityAttributes = inCorrectEntityDescriptor;
                            continue block78;
                        }
                        case "AttributeValue": {
                            if (!inEntityAttributes) break;
                            this.addCoinEntityCategories(entityType, metaDataFields, metaDataAutoConfiguration, reader.getElementText());
                        }
                    }
                    continue block78;
                }
                case 2: {
                    switch (reader.getLocalName()) {
                        case "ContactPerson": {
                            inContact = false;
                            break;
                        }
                        case "AttributeConsumingService": {
                            inAttributeConsumingService = false;
                            break;
                        }
                        case "UIInfo": {
                            inUIInfo = false;
                            break;
                        }
                        case "EntityDescriptor": {
                            if (inCorrectEntityDescriptor) {
                                return result;
                            }
                        }
                        case "EntityAttributes": {
                            inEntityAttributes = false;
                        }
                    }
                    continue block78;
                }
            }
        }
        return result;
    }

    private Set<String> arpKeys(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        return this.arpAttributes(type, metaDataAutoConfiguration, isSp).keySet();
    }

    private Map<String, String> arpAliases(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        Map arp = this.arpAttributes(type, metaDataAutoConfiguration, isSp);
        return arp.entrySet().stream().collect(Collectors.toMap(entry -> ((Map)Map.class.cast(entry.getValue())).getOrDefault("alias", "nope"), entry -> (String)entry.getKey()));
    }

    private Map<String, Object> arpAttributes(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        Map<String, Object> arpAttributes;
        Map schema = metaDataAutoConfiguration.schemaRepresentation(type);
        Map<String, Object> map = arpAttributes = isSp ? (Map)Map.class.cast(schema.get("properties")) : new HashMap<String, Object>();
        if (isSp) {
            for (String s : Arrays.asList("arp", "properties", ATTRIBUTES, "properties")) {
                arpAttributes = (Map)Map.class.cast(arpAttributes.get(s));
            }
        }
        return arpAttributes;
    }

    private void addArpAttribute(Map<String, Object> result, XMLStreamReader reader, Set<String> arpKeys, Map<String, String> arpAliases) {
        Optional name = this.getAttributeValue(reader, "Name");
        Optional friendlyName = this.getAttributeValue(reader, "FriendlyName");
        if (this.shouldAddAttributeToArp(name, arpKeys)) {
            this.doAddArpAttribute(result, arpKeys, (String)name.get());
        } else if (this.shouldAddAttributeToArp(friendlyName, arpKeys)) {
            this.doAddArpAttribute(result, arpKeys, (String)friendlyName.get());
        } else if (name.isPresent() && arpAliases.containsKey(name.get())) {
            this.doAddArpAttribute(result, arpKeys, arpAliases.get(name.get()));
        }
    }

    private boolean shouldAddAttributeToArp(Optional<String> name, Set<String> allowedArpKeys) {
        return name.isPresent() && allowedArpKeys.stream().anyMatch(arpKey -> arpKey.endsWith((String)name.get()));
    }

    private void doAddArpAttribute(Map<String, Object> result, Set<String> arpKeys, String friendlyName) {
        Map arp = (Map)Map.class.cast(result.getOrDefault("arp", new TreeMap()));
        arp.put("enabled", true);
        Map attributes = (Map)Map.class.cast(arp.getOrDefault(ATTRIBUTES, new TreeMap()));
        arpKeys.stream().filter(arpKey -> arpKey.endsWith(friendlyName)).findFirst().ifPresent(arpKey -> {
            List arpEntry = (List)List.class.cast(attributes.getOrDefault(arpKey, new ArrayList()));
            HashMap<String, String> arpValue = new HashMap<String, String>();
            arpValue.put("source", "idp");
            arpValue.put("value", "*");
            arpEntry.add(arpValue);
            attributes.put(arpKey, arpEntry);
        });
        arp.put(ATTRIBUTES, attributes);
        result.put("arp", arp);
    }

    private void addMetaDataField(Map<String, String> metaDataFields, XMLStreamReader reader, String attributeName, String metaDataKey) {
        Optional optional = this.getAttributeValue(reader, attributeName);
        optional.ifPresent(value -> metaDataFields.put(metaDataKey, (String)value));
    }

    private void addLanguageElement(Map<String, String> metaDataFields, XMLStreamReader reader, String elementName) throws XMLStreamException {
        String language = this.getAttributeValue(reader, "lang").orElse("en");
        if (languages.contains(language)) {
            metaDataFields.put(String.format("%s:%s", elementName, language), reader.getElementText());
        }
    }

    private void addMultiplicity(Map<String, String> result, String format, int multiplicity, String value) {
        List keys = IntStream.range(0, multiplicity).mapToObj(nbr -> String.format(format, nbr)).collect(Collectors.toList());
        long count = result.keySet().stream().filter(key -> keys.contains(key)).count();
        if (count < (long)keys.size()) {
            result.put((String)keys.get((int)count), value);
        }
    }

    private void addCert(Map<String, String> result, String cert) {
        List<String> certDataKeys = Arrays.asList("certData", "certData2", "certData3");
        long count = result.keySet().stream().filter(certDataKeys::contains).count();
        if (count < (long)certDataKeys.size() && !certDataKeys.stream().map(key -> cert.equals(result.get(key))).anyMatch(b -> b)) {
            result.put(certDataKeys.get((int)count), cert);
        }
    }

    private void addLogo(Map<String, String> metaDataFields, XMLStreamReader reader) throws XMLStreamException {
        this.getAttributeValue(reader, "width").ifPresent(width -> metaDataFields.put("logo:0:width", (String)width));
        this.getAttributeValue(reader, "height").ifPresent(height -> metaDataFields.put("logo:0:height", (String)height));
        metaDataFields.put("logo:0:url", reader.getElementText());
    }

    private Optional<String> getAttributeValue(XMLStreamReader reader, String attributeName) {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            QName qName = reader.getAttributeName(i);
            if (!qName.getLocalPart().equalsIgnoreCase(attributeName)) continue;
            return Optional.of(reader.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()));
        }
        return Optional.empty();
    }

    private void addCoinEntityCategories(EntityType entityType, Map<String, String> metaDataFields, MetaDataAutoConfiguration metaDataAutoConfiguration, String elementText) {
        String strippedValue;
        Map schema = metaDataAutoConfiguration.schemaRepresentation(entityType);
        Map schemaPart = this.unpack(schema, Arrays.asList("properties", "metaDataFields", "patternProperties", "^coin:entity_categories:"));
        List enumeration = (List)schemaPart.get("enum");
        if (!enumeration.contains(strippedValue = elementText.replaceAll("\n", "").trim())) {
            return;
        }
        String entityCategoryKey = "coin:entity_categories:";
        List categories = metaDataFields.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(entityCategoryKey)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (categories.contains(strippedValue)) {
            return;
        }
        int multiplicity = (Integer)schemaPart.get("multiplicity");
        int startIndex = (Integer)schemaPart.get("startIndex");
        metaDataFields.keySet().stream().filter(s -> s.startsWith(entityCategoryKey)).map(s -> Integer.valueOf(s.substring(entityCategoryKey.length()))).max(Integer::compareTo).map(i -> {
            String string;
            if (multiplicity >= startIndex + i) {
                i = i + 1;
                string = "put returns null" + metaDataFields.put(entityCategoryKey + i, strippedValue);
            } else {
                string = "";
            }
            return string;
        }).orElseGet(() -> metaDataFields.put(entityCategoryKey + startIndex, strippedValue));
    }

    private Map<String, Object> unpack(Map<String, Object> schema, List<String> keys) {
        return ((Stream)keys.stream().sequential()).reduce(schema, (map, s) -> s.startsWith("^") ? (Map)Map.class.cast(map.get(map.keySet().stream().filter(k -> k.startsWith((String)s)).findAny().orElseThrow(() -> new IllegalArgumentException("Key not present: " + s)))) : (Map)Map.class.cast(map.get(s)), (acc, com) -> com);
    }
}

