/*
 * Decompiled with CFR 0.152.
 */
package manage.oidc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import manage.oidc.Client;
import manage.oidc.OpenIdConnect;

public class OpenIdConnectMock
implements OpenIdConnect {
    private Map<String, Client> clients = new HashMap();

    public Optional<Client> getClient(String clientId) {
        Client client = this.clients.getOrDefault(clientId, this.defaultClient(clientId));
        return Optional.of(client);
    }

    public Client createClient(Client client) {
        return this.updateClient(client);
    }

    public Client updateClient(Client client) {
        this.clients.put(client.getClientId(), client);
        return client;
    }

    public void deleteClient(String clientId) {
        this.clients.remove(clientId);
    }

    private Client defaultClient(String clientId) {
        Client client = new Client();
        client.setGrantTypes(Collections.singleton("authorization_code"));
        client.setClientId(clientId);
        client.setRedirectUris(Collections.singleton("http://redirect"));
        return client;
    }
}

