/*
 * Decompiled with CFR 0.152.
 */
package manage.oidc;

import java.util.Set;
import manage.oidc.Client;

public class OidcClient {
    private String clientId;
    private String clientSecret;
    private Set<String> redirectUris;
    private String grantType;
    private Set<String> scope;

    public OidcClient(Client client) {
        this.clientId = client.getClientId();
        this.clientSecret = client.getClientSecret();
        this.redirectUris = client.getRedirectUris();
        this.grantType = client.getGrantTypes().isEmpty() ? null : (String)client.getGrantTypes().iterator().next();
        this.scope = client.getScope();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public OidcClient(String clientId, String clientSecret, Set<String> redirectUris, String grantType, Set<String> scope) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUris = redirectUris;
        this.grantType = grantType;
        this.scope = scope;
    }
}

