/*
 * Decompiled with CFR 0.152.
 */
package manage.shibboleth;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import manage.conf.Features;
import manage.conf.Product;
import manage.conf.Push;
import manage.shibboleth.FederatedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String NAME_ID_HEADER_NAME = "name-id";
    public static final String DISPLAY_NAME_HEADER_NAME = "displayname";
    public static final String SCHAC_HOME_HEADER = "schacHomeOrganization";
    private final List<Features> featureToggles;
    private final Product product;
    private final Push push;
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, List<Features> featureToggles, Product product, Push push) {
        this.setAuthenticationManager(authenticationManager);
        this.featureToggles = featureToggles;
        this.product = product;
        this.push = push;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = this.getHeader(NAME_ID_HEADER_NAME, request);
        String displayName = this.getHeader(DISPLAY_NAME_HEADER_NAME, request);
        String schacHomeOrganization = this.getHeader(SCHAC_HOME_HEADER, request);
        if (StringUtils.isEmpty((Object)uid) || StringUtils.isEmpty((Object)displayName)) {
            LOG.error("Missing required attribute(s): uid {} displayName {}", (Object)uid, (Object)displayName);
            return null;
        }
        List authorityList = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_ADMIN"});
        return new FederatedUser(uid, displayName, schacHomeOrganization, authorityList, this.featureToggles, this.product, this.push);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : header;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

