/*
 * Decompiled with CFR 0.152.
 */
package manage.model;

import java.util.regex.Pattern;
import org.springframework.util.Assert;

public enum EntityType {
    IDP("saml20_idp"),
    SP("saml20_sp");

    private final String type;
    private final String janusDbValue;

    private EntityType(String type) {
        this.type = type;
        this.janusDbValue = type.replaceAll("_", "-");
    }

    public String getType() {
        return this.type;
    }

    public String getJanusDbValue() {
        return this.janusDbValue;
    }

    public static EntityType fromType(String type) {
        type = type.replaceAll(Pattern.quote("-"), "_");
        EntityType entityType = IDP.getType().equals(type) ? IDP : (SP.getType().equals(type) ? SP : null);
        Assert.notNull((Object)entityType, (String)("Invalid EntityType " + type));
        return entityType;
    }
}

