/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import manage.api.APIUser;
import manage.model.EntityType;
import manage.model.ProviderIdentifier;
import manage.repository.MetaDataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StatsController {
    private static final Logger LOG = LoggerFactory.getLogger(StatsController.class);
    private MetaDataRepository metaDataRepository;

    @Autowired
    public StatsController(MetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }

    @GetMapping(value={"/internal/stats/revisions"})
    public List<Map> revisions(APIUser apiUser) {
        LOG.info("Revisions request by {}", (Object)apiUser.getName());
        Query query = this.getQueryWithDefaultFields(new Query());
        ArrayList<Map> providers = new ArrayList<Map>();
        Arrays.asList(EntityType.values()).forEach(type -> Arrays.asList(type.getType(), type.getType().concat("_revision")).forEach(collectionName -> providers.addAll(this.metaDataRepository.getMongoTemplate().find(query, Map.class, collectionName))));
        this.sortProvidersByEidRevisionNumber(providers);
        LOG.info("Revisions request by {} returning {} providers", (Object)apiUser.getName(), (Object)providers.size());
        return providers;
    }

    @GetMapping(value={"/internal/stats/uniques/{type}"})
    public List<Map> uniques(@PathVariable(value="type") String type, APIUser apiUser) {
        LOG.info("Uniques request for type {} by {}", (Object)type, (Object)apiUser.getName());
        List<EntityType> entityTypes = Arrays.asList(EntityType.values());
        Assert.isTrue((boolean)entityTypes.stream().anyMatch(entityType -> entityType.getType().equals(type)), (String)String.format("Unknown type metadata, allowed are %s", entityTypes.stream().map(EntityType::getType).collect(Collectors.toList())));
        ArrayList<Map> result = new ArrayList<Map>();
        List providers = this.metaDataRepository.getMongoTemplate().find(this.getQueryWithDefaultFields(new Query()), Map.class, type);
        providers.forEach(provider -> {
            result.add((Map)provider);
            HashSet<ProviderIdentifier> subResult = new HashSet<ProviderIdentifier>();
            ProviderIdentifier parent = new ProviderIdentifier(provider);
            subResult.add(parent);
            String parentId = (String)String.class.cast(provider.get("_id"));
            Query query = this.getQueryWithDefaultFields(new Query((CriteriaDefinition)Criteria.where((String)"revision.parentId").is((Object)parentId)).with(new Sort(Sort.Direction.ASC, new String[]{"revision.number"})));
            List revisions = this.metaDataRepository.getMongoTemplate().find(query, Map.class, type.concat("_revision"));
            for (int i = 0; i < revisions.size(); ++i) {
                Map revision = (Map)revisions.get(i);
                Object ended = revisions.size() == i + 1 ? this.revision(provider).get("created") : this.revision((Map)revisions.get(i + 1)).get("created");
                this.revision(revision).put("ended", ended);
                ProviderIdentifier providerIdentifier = new ProviderIdentifier(revision);
                if (!subResult.add(providerIdentifier)) continue;
                result.add(revision);
            }
        });
        this.sortProvidersByEidRevisionNumber(result);
        LOG.info("Uniques request for type {} returning {} providers", (Object)type, (Object)result.size());
        return result;
    }

    @GetMapping(value={"/internal/stats/connections"})
    public List<Map> connections(APIUser apiUser, @RequestParam(value="from") Optional<String> from) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = from.map(fromDateString -> {
            try {
                return simpleDateFormat.parse((String)fromDateString);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Illegal date format %s, required format %s", fromDateString, "yyyy-MM-dd"));
            }
        }).orElse(new Date());
        String dateString = simpleDateFormat.format(date);
        LOG.info("Connections request for {} by {}", (Object)dateString, (Object)apiUser.getName());
        ArrayList<Map> result = new ArrayList<Map>();
        List uniqueIdentityProviders = this.filterByCreate(date, this.uniques(EntityType.IDP.getType(), apiUser));
        List serviceProviders = this.filterByCreate(date, this.uniques(EntityType.SP.getType(), apiUser));
        uniqueIdentityProviders.forEach(idp -> {
            List spCandidates;
            Map idpRevision = (Map)Map.class.cast(idp.get("revision"));
            Long idpCreated = ((Date)Date.class.cast(idpRevision.get("created"))).getTime();
            Long idpTerminated = this.getTime(idpRevision, "terminated");
            Long idpEnded = this.getTime(idpRevision, "ended");
            Map idpData = (Map)Map.class.cast(idp.get("data"));
            Boolean allowedAll = (Boolean)Boolean.class.cast(idpData.get("allowedall"));
            if (allowedAll.booleanValue()) {
                spCandidates = serviceProviders;
            } else {
                List allowedEntities = ((List)List.class.cast(idpData.getOrDefault("allowedEntities", new ArrayList()))).stream().map(m -> ((Map)Map.class.cast(m)).get("name")).collect(Collectors.toList());
                spCandidates = serviceProviders.stream().filter(sp -> allowedEntities.contains(((Map)Map.class.cast(sp.get("data"))).get("entityid"))).collect(Collectors.toList());
            }
            List connectedServiceProviders = spCandidates.stream().filter(sp -> {
                Map spRevision = (Map)Map.class.cast(sp.get("revision"));
                Long spCreated = ((Date)Date.class.cast(spRevision.get("created"))).getTime();
                Long spTerminated = this.getTime(idpRevision, "terminated");
                Long spEnded = this.getTime(idpRevision, "ended");
                Map spData = (Map)Map.class.cast(sp.get("data"));
                Boolean spAllowedAll = (Boolean)Boolean.class.cast(spData.get("allowedall"));
                List allowedEntities = ((List)List.class.cast(spData.getOrDefault("allowedEntities", new ArrayList()))).stream().map(m -> ((Map)Map.class.cast(m)).get("name")).collect(Collectors.toList());
                boolean whiteListed = allowedEntities.contains(idpData.get("entityid"));
                return !(spAllowedAll == false && !whiteListed || !spData.get("state").equals(idpData.get("state")) || spTerminated != null && spTerminated <= idpCreated || spEnded != null && spEnded <= idpCreated || idpEnded != null && idpEnded <= spCreated || idpTerminated != null && idpTerminated <= spCreated);
            }).map(sp -> {
                Map subResult = new ProviderIdentifier(idp).toMap(EntityType.IDP, Optional.empty());
                Map entry = new ProviderIdentifier(sp).toMap(EntityType.SP, Optional.of(subResult));
                entry.put("date", dateString);
                return entry;
            }).collect(Collectors.toList());
            result.addAll(connectedServiceProviders);
        });
        LOG.info("Connections request for {} by {} returning {} connections", new Object[]{dateString, apiUser.getName(), result.size()});
        return result;
    }

    private List<Map> filterByCreate(Date date, List<Map> providers) {
        long millis = date.getTime();
        return providers.stream().filter(provider -> ((Date)Date.class.cast(((Map)Map.class.cast(provider.get("revision"))).get("created"))).getTime() < millis).collect(Collectors.toList());
    }

    private Long getTime(Map revision, String name) {
        Date date = (Date)Date.class.cast(revision.get(name));
        return date != null ? Long.valueOf(date.getTime()) : null;
    }

    @GetMapping(value={"/internal/stats/new_providers"})
    public List<Map> newProviders(APIUser apiUser) {
        LOG.info("Providers without eid request by {}", (Object)apiUser.getName());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.eid").exists(false));
        query.fields().include("_id").include("revision.parentId").include("type").include("data.entityid");
        ArrayList<Map> providers = new ArrayList<Map>();
        Arrays.asList(EntityType.values()).forEach(type -> Arrays.asList(type.getType(), type.getType().concat("_revision")).forEach(collectionName -> providers.addAll(this.metaDataRepository.getMongoTemplate().find(query, Map.class, collectionName))));
        LOG.info("Providers without eid request by {} returning {} providers", (Object)apiUser.getName(), (Object)providers.size());
        return providers;
    }

    @GetMapping(value={"/internal/stats/none_allowed"})
    public List<Map> noneAllowed(APIUser apiUser) {
        LOG.info("Providers without any connections request by {}", (Object)apiUser.getName());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"data.allowedall").is((Object)false));
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"data.allowedEntities").exists(false), Criteria.where((String)"data.allowedEntities").size(0)}));
        query.fields().include("_id").include("revision.parentId").include("type").include("data.entityid").include("data.allowedall").include("data.allowedEntities");
        ArrayList<Map> providers = new ArrayList<Map>();
        Arrays.asList(EntityType.values()).forEach(type -> Arrays.asList(type.getType(), type.getType().concat("_revision")).forEach(collectionName -> providers.addAll(this.metaDataRepository.getMongoTemplate().find(query, Map.class, collectionName))));
        LOG.info("Providers without any connections request by {} returning {} providers", (Object)apiUser.getName(), (Object)providers.size());
        return providers;
    }

    private Map revision(Map provider) {
        return (Map)Map.class.cast(provider.get("revision"));
    }

    private Query getQueryWithDefaultFields(Query query) {
        query.fields().include("type").include("revision.number").include("revision.parentId").include("revision.created").include("revision.terminated").include("data.eid").include("data.state").include("data.entityid").include("data.allowedall").include("data.allowedEntities").include("data.metaDataFields.name:en").include("data.metaDataFields.name:nl").include("data.metaDataFields.coin:institution_id");
        return query;
    }

    private void sortProvidersByEidRevisionNumber(List<Map> providers) {
        Collections.sort(providers, (m1, m2) -> {
            Long eid2;
            Long eid1 = this.metadataId(m1, "data", "eid");
            if (!eid1.equals(eid2 = this.metadataId(m2, "data", "eid"))) {
                return eid1.compareTo(eid2);
            }
            Long number1 = this.metadataId(m1, "revision", "number");
            Long number2 = this.metadataId(m2, "revision", "number");
            return number1.compareTo(number2);
        });
    }

    private Long metadataId(Map map, String parent, String identifier) {
        Object id = ((Map)Map.class.cast(map.get(parent))).get(identifier);
        if (id instanceof Integer) {
            return (long)((Integer)Integer.class.cast(id));
        }
        if (id instanceof Long) {
            return (long)((Long)Long.class.cast(id));
        }
        if (id == null) {
            throw new RuntimeException(String.format("Identifier %s does not exists in Map %s", identifier, map));
        }
        throw new RuntimeException(String.format("Identifier %s exists in Map %s but is of type %s", identifier, map, id.getClass().getName()));
    }
}

