/*
 * Decompiled with CFR 0.152.
 */
package manage.validations;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;

public class LocalEmailFormatValidator
implements FormatValidator {
    private static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,16}$", 2);

    public Optional<String> validate(String subject) {
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(subject);
        if (matcher.find()) {
            return Optional.empty();
        }
        return Optional.of(String.format("[%s] is not a valid email address", subject));
    }

    public String formatName() {
        return "local-email";
    }
}

