/*
 * Decompiled with CFR 0.152.
 */
package manage.oidc;

import java.util.Optional;
import manage.oidc.Client;
import manage.oidc.OpenIdConnect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthorizationInterceptor;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class OpenIdConnectService
implements OpenIdConnect {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdConnectService.class);
    private String url;
    private RestTemplate restTemplate = new RestTemplate();

    public OpenIdConnectService(String user, String password, String url) {
        this.restTemplate.getInterceptors().add(new BasicAuthorizationInterceptor(user, password));
        this.url = url;
    }

    public Optional<Client> getClient(String clientId) {
        String url = String.format("%s?clientId=%s", this.url, clientId);
        try {
            return Optional.ofNullable(this.restTemplate.getForEntity(url, Client.class, new Object[0]).getBody());
        }
        catch (HttpClientErrorException e) {
            LOG.error("Error in retrieving client " + clientId + " from OIDC", (Throwable)e);
            return Optional.empty();
        }
    }

    public Client createClient(Client client) {
        ResponseEntity clientResponseEntity = this.restTemplate.postForEntity(this.url, (Object)client, Client.class, new Object[0]);
        return (Client)clientResponseEntity.getBody();
    }

    public Client updateClient(Client client) {
        this.restTemplate.put(this.url, (Object)client, new Object[0]);
        return client;
    }

    public void deleteClient(String clientId) {
        try {
            this.restTemplate.delete(String.format("%s?clientId=%s", this.url, clientId), new Object[0]);
        }
        catch (HttpClientErrorException e) {
            LOG.error("Error in deleting client " + clientId + " from OIDC", (Throwable)e);
        }
    }
}

