/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Arrays;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.CompositeMetaDataHook;
import manage.hook.EntityIdConstraintsHook;
import manage.hook.EntityIdReconcilerHook;
import manage.hook.OidcValidationHook;
import manage.hook.OpenIdConnectHook;
import manage.hook.SecretHook;
import manage.hook.TypeSafetyHook;
import manage.oidc.OpenIdConnect;
import manage.repository.MetaDataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetaDataHookConfiguration {
    @Bean
    @Autowired
    CompositeMetaDataHook hooks(MetaDataRepository metaDataRepository, OpenIdConnect openIdConnect, MetaDataAutoConfiguration metaDataAutoConfiguration, @Value(value="${oidc.acsLocation}") String acsLocation) {
        EntityIdReconcilerHook entityIdReconcilerHook = new EntityIdReconcilerHook(metaDataRepository);
        OpenIdConnectHook openIdConnectHook = new OpenIdConnectHook(openIdConnect, acsLocation);
        SecretHook secretHook = new SecretHook();
        TypeSafetyHook typeSafetyHook = new TypeSafetyHook(metaDataAutoConfiguration);
        EntityIdConstraintsHook entityIdConstraintsHook = new EntityIdConstraintsHook(metaDataRepository);
        OidcValidationHook validationHook = new OidcValidationHook(metaDataAutoConfiguration);
        return new CompositeMetaDataHook(Arrays.asList(validationHook, typeSafetyHook, entityIdConstraintsHook, entityIdReconcilerHook, openIdConnectHook, secretHook));
    }
}

