/*
 * Decompiled with CFR 0.152.
 */
package manage.validations;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;
import org.springframework.util.StringUtils;

public class URIFormatValidator
implements FormatValidator {
    private Pattern pattern = Pattern.compile("^[\\w\\.]+:(\\/?\\/?)[^\\s]+$");

    public Optional<String> validate(String subject) {
        if (StringUtils.isEmpty((Object)subject)) {
            return Optional.empty();
        }
        try {
            new URI(subject);
            return this.pattern.matcher(subject).matches() ? Optional.empty() : Optional.of("URL must match pattern: " + this.pattern.pattern());
        }
        catch (URISyntaxException e) {
            return Optional.of(StringUtils.hasText((String)e.getMessage()) ? e.getMessage() : "Invalid URI");
        }
    }

    public String formatName() {
        return "uri";
    }
}

