/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.oidc.Client;
import manage.oidc.OidcClient;
import manage.oidc.OpenIdConnect;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OpenIdConnectHook
extends MetaDataHookAdapter {
    public static final String OIDC_CLIENT_KEY = "oidcClient";
    private OpenIdConnect openIdConnect;
    private String oidcAcsLocation;

    public OpenIdConnectHook(OpenIdConnect openIdConnect, String oidcAcsLocation) {
        this.openIdConnect = openIdConnect;
        this.oidcAcsLocation = oidcAcsLocation;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        if (EntityType.SP.getType().equals(metaData.getType())) {
            Object o = metaData.metaDataFields().get("coin:oidc_client");
            return o instanceof String && "1".equals(o) || o instanceof Boolean && (Boolean)Boolean.class.cast(o) != false;
        }
        return false;
    }

    public MetaData postGet(MetaData metaData) {
        String openIdClientId = this.translateServiceProviderEntityId((String)metaData.getData().get("entityid"));
        Optional clientOptional = this.openIdConnect.getClient(openIdClientId);
        if (!clientOptional.isPresent()) {
            return metaData;
        }
        Client client = (Client)clientOptional.get();
        client.setClientSecret(null);
        metaData.getData().put(OIDC_CLIENT_KEY, new OidcClient(client));
        return metaData;
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        if (this.ignoreForOIDC(newMetaData)) {
            return newMetaData;
        }
        Map clientMap = (Map)newMetaData.getData().get(OIDC_CLIENT_KEY);
        String openIdClientId = this.translateServiceProviderEntityId((String)previous.getData().get("entityid"));
        Optional clientOptional = this.openIdConnect.getClient(openIdClientId);
        if (clientOptional.isPresent()) {
            Client client = (Client)clientOptional.get();
            this.syncClient(newMetaData, clientMap, client);
            this.openIdConnect.updateClient(client);
        }
        newMetaData.getData().remove(OIDC_CLIENT_KEY);
        return newMetaData;
    }

    public MetaData prePost(MetaData metaData) {
        if (this.ignoreForOIDC(metaData)) {
            return metaData;
        }
        Map clientMap = (Map)metaData.getData().get(OIDC_CLIENT_KEY);
        Client client = new Client();
        this.syncClient(metaData, clientMap, client);
        this.openIdConnect.createClient(client);
        metaData.getData().remove(OIDC_CLIENT_KEY);
        metaData.metaDataFields().put("AssertionConsumerService:0:Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        metaData.metaDataFields().put("AssertionConsumerService:0:Location", this.oidcAcsLocation);
        return metaData;
    }

    private boolean ignoreForOIDC(MetaData metaData) {
        Map clientMap = (Map)metaData.getData().get(OIDC_CLIENT_KEY);
        return CollectionUtils.isEmpty((Map)clientMap);
    }

    private void syncClient(MetaData metaData, Map<String, Object> clientMap, Client client) {
        String secret;
        String grantType;
        List redirectUris;
        String entityid = (String)metaData.getData().get("entityid");
        client.setClientId(this.translateServiceProviderEntityId(entityid));
        String name = (String)metaData.metaDataFields().get("name:en");
        if (StringUtils.hasText((String)name)) {
            client.setClientName(name);
        }
        if (!CollectionUtils.isEmpty((Collection)(redirectUris = (List)List.class.cast(clientMap.get("redirectUris"))))) {
            client.setRedirectUris(new HashSet(redirectUris));
            client.setRegisteredRedirectUri(new HashSet());
        }
        if (StringUtils.hasText((String)(grantType = (String)String.class.cast(clientMap.get("grantType"))))) {
            client.setGrantTypes(Collections.singleton(grantType));
        }
        if (StringUtils.hasText((String)(secret = (String)clientMap.get("clientSecret")))) {
            client.setClientSecret(secret);
        }
    }

    public MetaData preDelete(MetaData metaData) {
        String entityid = (String)metaData.getData().get("entityid");
        this.openIdConnect.deleteClient(this.translateServiceProviderEntityId(entityid));
        return metaData;
    }

    private String translateServiceProviderEntityId(String entityId) {
        return entityId.replace("@", "@@").replaceAll(":", "@");
    }
}

