/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import manage.format.EngineBlockFormatter;
import manage.model.MetaData;
import manage.push.Delta;
import manage.push.PrePostComparator;
import manage.repository.MetaDataRepository;
import manage.web.PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Component
@RestController
public class DatabaseController {
    private RestTemplate restTemplate;
    private String pushUri;
    private RestTemplate oidcRestTemplate;
    private String oidcPushUri;
    private boolean oidcEnabled;
    private boolean excludeEduGainImported;
    private boolean excludeOidcRP;
    private MetaDataRepository metaDataRepository;
    private JdbcTemplate ebJdbcTemplate;
    private Environment environment;
    private PrePostComparator prePostComparator = new PrePostComparator();

    @Autowired
    DatabaseController(MetaDataRepository metaDataRepository, DataSource ebDataSource, @Value(value="${push.eb.url}") String pushUri, @Value(value="${push.eb.user}") String user, @Value(value="${push.eb.password}") String password, @Value(value="${push.eb.exclude_edugain_imports}") boolean excludeEduGainImported, @Value(value="${push.eb.exclude_oidc_rp}") boolean excludeOidcRP, @Value(value="${push.oidc.url}") String oidcPushUri, @Value(value="${push.oidc.user}") String oidcUser, @Value(value="${push.oidc.password}") String oidcPassword, @Value(value="${push.oidc.enabled}") boolean oidcEnabled, Environment environment) throws MalformedURLException {
        this.metaDataRepository = metaDataRepository;
        this.pushUri = pushUri;
        this.restTemplate = new RestTemplate(this.getRequestFactory(user, password));
        this.excludeEduGainImported = excludeEduGainImported;
        this.excludeOidcRP = excludeOidcRP;
        this.oidcRestTemplate = new RestTemplate(this.getRequestFactory(oidcUser, oidcPassword));
        this.oidcPushUri = oidcPushUri;
        this.oidcEnabled = oidcEnabled;
        this.ebJdbcTemplate = new JdbcTemplate(ebDataSource);
        this.environment = environment;
    }

    public ResponseEntity<Map> doPush() {
        if (this.environment.acceptsProfiles(new String[]{"dev"})) {
            return new ResponseEntity(Collections.singletonMap("status", 200), HttpStatus.OK);
        }
        List preProvidersData = this.ebJdbcTemplate.queryForList("SELECT * FROM sso_provider_roles_eb5 ORDER BY id ASC");
        Map json = this.pushPreview();
        ResponseEntity response = this.restTemplate.postForEntity(this.pushUri, (Object)json, String.class, new Object[0]);
        HttpStatus statusCode = response.getStatusCode();
        List postProvidersData = this.ebJdbcTemplate.queryForList("SELECT * FROM sso_provider_roles_eb5 ORDER BY id ASC");
        Set deltas = this.prePostComparator.compare(preProvidersData, postProvidersData);
        List<String> knownDeltas = Arrays.asList("id", "name_id_formats");
        List realDeltas = deltas.stream().filter(delta -> !knownDeltas.contains(delta.getAttribute())).collect(Collectors.toList());
        realDeltas.sort(Comparator.comparing(Delta::getEntityId));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", statusCode);
        result.put("response", response);
        result.put("deltas", realDeltas);
        if (!this.environment.acceptsProfiles(new String[]{"dev"}) && this.oidcEnabled) {
            List oidcClients = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "oidc10_rp");
            this.oidcRestTemplate.postForEntity(this.oidcPushUri, (Object)oidcClients, Void.class, new Object[0]);
            result.put("oidc", true);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @GetMapping(value={"/client/playground/pushPreview"})
    public Map<String, Map<String, Map<String, Object>>> pushPreview() {
        EngineBlockFormatter formatter = new EngineBlockFormatter();
        List serviceProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "saml20_sp");
        Stream metaDataStream = this.excludeEduGainImported ? serviceProviders.stream().filter(metaData -> {
            Map metaDataFields = metaData.metaDataFields();
            boolean importedFromEdugain = Boolean.TRUE.equals(metaDataFields.get("coin:imported_from_edugain"));
            boolean pushEnabled = Boolean.TRUE.equals(metaDataFields.get("coin:push_enabled"));
            return !importedFromEdugain || pushEnabled;
        }) : serviceProviders.stream();
        Map<String, Map> serviceProvidersToPush = metaDataStream.filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseServiceProvider(arg_0)));
        List identityProviders = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "saml20_idp");
        this.filterOutNullDisableConsentExplanations(identityProviders);
        Map<String, Map> identityProvidersToPush = identityProviders.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseIdentityProvider(arg_0)));
        if (!this.excludeOidcRP) {
            List oidcClients = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, "oidc10_rp");
            Map<String, Map> oidcClientsToPush = oidcClients.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseOidcClient(arg_0)));
            serviceProvidersToPush.putAll(oidcClientsToPush);
        }
        serviceProvidersToPush.putAll(identityProvidersToPush);
        HashMap<String, Map<String, Map<String, Object>>> results = new HashMap<String, Map<String, Map<String, Object>>>();
        results.put("connections", serviceProvidersToPush);
        return results;
    }

    private boolean excludeFromPush(Map metaDataFields) {
        Boolean excludeFromPush = metaDataFields.getOrDefault("coin:exclude_from_push", false);
        if (excludeFromPush instanceof String) {
            return "1".equals(excludeFromPush);
        }
        return excludeFromPush;
    }

    public void filterOutNullDisableConsentExplanations(List<MetaData> identityProviders) {
        identityProviders.forEach(idp -> {
            Object disableConsentData = idp.getData().get("disableConsent");
            if (disableConsentData instanceof List) {
                List disableConsent = (List)disableConsentData;
                disableConsent.forEach(disableConsentEntry -> {
                    if (disableConsentEntry instanceof Map) {
                        Map disableConsentMap = (Map)disableConsentEntry;
                        disableConsentMap.entrySet().removeIf(entry -> entry.getValue() == null);
                    }
                });
            }
        });
    }

    private ClientHttpRequestFactory getRequestFactory(String user, String password) throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(10L, TimeUnit.SECONDS);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, this.pushUri);
    }
}

