/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.springframework.util.CollectionUtils;

public class EntityIdConstraintsHook
extends MetaDataHookAdapter {
    private MetaDataRepository metaDataRepository;

    public EntityIdConstraintsHook(MetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return !metaData.getType().equals(EntityType.STT.getType());
    }

    public MetaData prePost(MetaData metaData) {
        return this.doPre(metaData);
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        return this.doPre(newMetaData);
    }

    private MetaData doPre(MetaData newMetaData) {
        String metaDataType = newMetaData.getType();
        HashMap<String, List> relationsToCheck = new HashMap<String, List>();
        List<EntityType> reversedEntityType = metaDataType.equals(EntityType.IDP.getType()) ? Arrays.asList(EntityType.SP, EntityType.RP) : Collections.singletonList(EntityType.IDP);
        relationsToCheck.put("allowedEntities", reversedEntityType);
        relationsToCheck.put("disableConsent", reversedEntityType);
        relationsToCheck.put("stepupEntities", Arrays.asList(EntityType.SP, EntityType.RP));
        relationsToCheck.put("allowedResourceServers", Collections.singletonList(EntityType.RP));
        relationsToCheck.forEach((key, value) -> {
            List references;
            if (newMetaData.getData().containsKey(key) && !CollectionUtils.isEmpty((Collection)(references = (List)newMetaData.getData().get(key)))) {
                List strippedReferences = references.stream().filter(map -> value.stream().anyMatch(entityType -> !CollectionUtils.isEmpty((Collection)this.metaDataRepository.findRaw(entityType.getType(), String.format("{\"data.entityid\" : \"%s\"}", map.get("name")))))).collect(Collectors.toList());
                newMetaData.getData().put(key, strippedReferences);
            }
        });
        return newMetaData;
    }
}

