/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.api.APIUser;
import manage.conf.Features;
import manage.control.DatabaseController;
import manage.exception.EndpointNotAllowed;
import manage.hook.EntityIdReconcilerHook;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.OrphanMetaData;
import manage.repository.MetaDataRepository;
import manage.shibboleth.FederatedUser;
import manage.validations.MetaDataValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SystemController {
    private static final Logger LOG = LoggerFactory.getLogger(SystemController.class);
    private MetaDataRepository metaDataRepository;
    private MetaDataValidator metaDataValidator;
    @Autowired
    private DatabaseController databaseController;

    @Autowired
    public SystemController(MetaDataRepository metaDataRepository, MetaDataValidator metaDataValidator) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataValidator = metaDataValidator;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/push"})
    public ResponseEntity<Map> push(FederatedUser federatedUser) {
        if (!federatedUser.featureAllowed(Features.PUSH)) {
            throw new EndpointNotAllowed();
        }
        return this.databaseController.doPush();
    }

    @PreAuthorize(value="hasRole('PUSH')")
    @GetMapping(value={"/internal/push"})
    public ResponseEntity<Map> pushInternal(APIUser apiUser) {
        LOG.info("Push initiated by {}", (Object)apiUser.getName());
        return this.databaseController.doPush();
    }

    @GetMapping(value={"/client/playground/validate"})
    public Map<String, Object> validate(FederatedUser federatedUser) {
        if (!federatedUser.featureAllowed(Features.VALIDATION)) {
            throw new EndpointNotAllowed();
        }
        return this.metaDataValidator.validateMigration();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/playground/deleteOrphans"})
    public void deleteOrphans() {
        this.doDeleteOrphans();
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    @DeleteMapping(value={"/internal/playground/deleteOrphans"})
    public void deleteOrphansInternal() {
        this.doDeleteOrphans();
    }

    private void doDeleteOrphans() {
        List orphans = this.orphans();
        orphans.forEach(orphanMetaData -> {
            MetaData metaData = this.metaDataRepository.findById(orphanMetaData.getId(), orphanMetaData.getCollection());
            List entries = (List)metaData.getData().get(orphanMetaData.getReferencedCollectionName());
            List newEntries = entries.stream().filter(entry -> !entry.get("name").equals(orphanMetaData.getMissingEntityId())).collect(Collectors.toList());
            metaData.getData().put(orphanMetaData.getReferencedCollectionName(), newEntries);
            metaData.getData().put("revisionnote", "Removed reference to non-existent entityID");
            MetaData previous = this.metaDataRepository.findById(metaData.getId(), orphanMetaData.getCollection());
            previous.revision(UUID.randomUUID().toString());
            this.metaDataRepository.save(previous);
            metaData.promoteToLatest("System");
            this.metaDataRepository.update(metaData);
        });
    }

    @GetMapping(value={"/client/playground/orphans", "/internal/playground/orphans"})
    public List<OrphanMetaData> orphans() {
        return Stream.of(EntityType.values()).map(arg_0 -> this.orphanMetaData(arg_0)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private Stream<OrphanMetaData> orphanMetaData(EntityType type) {
        Query query = new Query();
        query.fields().include("data.entityid").include("type").include("data.metaDataFields.name:en").include("data.allowedEntities.name").include("data.allowedResourceServers.name").include("data.stepupEntities.name").include("data.disableConsent.name");
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"data.allowedEntities").exists(true), Criteria.where((String)"data.disableConsent").exists(true), Criteria.where((String)"data.stepupEntities").exists(true), Criteria.where((String)"data.allowedResourceServers").exists(true)}));
        MongoTemplate mongoTemplate = this.metaDataRepository.getMongoTemplate();
        List metaDataWithReferences = mongoTemplate.find(query, MetaData.class, type.getType());
        HashMap groupedByEntityIdReference = new HashMap();
        Stream.of("allowedEntities", "disableConsent", "stepupEntities", "allowedResourceServers").forEach(propertyName -> metaDataWithReferences.stream().forEach(metaData -> {
            List entries = (List)metaData.getData().get(propertyName);
            if (!CollectionUtils.isEmpty((Collection)entries)) {
                entries.forEach(ae -> groupedByEntityIdReference.computeIfAbsent((String)ae.get("name"), k -> new HashMap()).computeIfAbsent(propertyName, m -> new ArrayList()).add(metaData));
            }
        }));
        List types = EntityIdReconcilerHook.metaDataTypesForeignKeyRelations((String)type.getType());
        return groupedByEntityIdReference.entrySet().stream().filter(entry -> types.stream().noneMatch(entityType -> mongoTemplate.exists((Query)new BasicQuery("{\"data.entityid\":\"" + (String)entry.getKey() + "\"}"), entityType))).map(entry -> ((Map)entry.getValue()).entrySet().stream().map(m -> ((List)m.getValue()).stream().map(metaData -> new OrphanMetaData((String)entry.getKey(), (String)metaData.getData().get("entityid"), (String)((Map)Map.class.cast(metaData.getData().get("metaDataFields"))).get("name:en"), (String)m.getKey(), metaData.getId(), type.getType())))).flatMap(Function.identity()).flatMap(Function.identity());
    }
}

