/*
 * Decompiled with CFR 0.152.
 */
package manage.validations;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;
import org.springframework.util.StringUtils;

public class URLFormatValidator
implements FormatValidator {
    private Pattern pattern = Pattern.compile("^(http|https)://(.*)$");

    public Optional<String> validate(String subject) {
        if (StringUtils.isEmpty((Object)subject)) {
            return Optional.empty();
        }
        try {
            new URL(subject);
            return this.pattern.matcher(subject).matches() ? Optional.empty() : Optional.of("URL must match pattern: " + this.pattern.pattern());
        }
        catch (MalformedURLException e) {
            return Optional.of(StringUtils.hasText((String)e.getMessage()) ? e.getMessage() : "Invalid URL");
        }
    }

    public String formatName() {
        return "url";
    }
}

