/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityIdReconcilerHook
extends MetaDataHookAdapter {
    private MetaDataRepository metaDataRepository;

    public EntityIdReconcilerHook(MetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return true;
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        String newEntityId;
        String oldEntityId = this.entityId(previous);
        if (oldEntityId.equals(newEntityId = this.entityId(newMetaData))) {
            return newMetaData;
        }
        String metaDataType = newMetaData.getType();
        Arrays.asList("allowedEntities", "disableConsent", "allowedResourceServers").forEach(name -> {
            List types = EntityIdReconcilerHook.metaDataTypesToReconcile((String)metaDataType);
            types.forEach(type -> {
                List references = this.metaDataRepository.findRaw(type, String.format("{\"data.%s.name\" : \"%s\"}", name, oldEntityId));
                String revisionNote = String.format("Updated after entityId rename of %s to %s", oldEntityId, newEntityId);
                references.forEach(metaData -> {
                    List entities = metaData.getData().getOrDefault(name, new ArrayList());
                    entities.stream().filter(entry -> oldEntityId.equals(entry.get("name"))).findAny().ifPresent(entry -> entry.put("name", newEntityId));
                    metaData.getData().put("revisionnote", revisionNote);
                    this.revision(metaData);
                });
            });
        });
        return newMetaData;
    }

    public MetaData preDelete(MetaData metaDataToBeDeleted) {
        String entityId = this.entityId(metaDataToBeDeleted);
        String metaDataType = metaDataToBeDeleted.getType();
        Arrays.asList("allowedEntities", "disableConsent").forEach(name -> {
            List types = EntityIdReconcilerHook.metaDataTypesToReconcile((String)metaDataType);
            types.forEach(type -> {
                List references = this.metaDataRepository.findRaw(type, String.format("{\"data.%s.name\" : \"%s\"}", name, entityId));
                String revisionNote = String.format("Updated after deletion of entityId %s", entityId);
                references.forEach(metaData -> {
                    List entities = metaData.getData().getOrDefault(name, new ArrayList());
                    entities = entities.stream().filter(entry -> !entityId.equals(entry.get("name"))).collect(Collectors.toList());
                    metaData.getData().put(name, entities);
                    metaData.getData().put("revisionnote", revisionNote);
                    this.revision(metaData);
                });
            });
        });
        return metaDataToBeDeleted;
    }

    public static List<String> metaDataTypesToReconcile(String type) {
        if (type.equals(EntityType.SP.getType())) {
            return Collections.singletonList(EntityType.IDP.getType());
        }
        if (type.equals(EntityType.IDP.getType())) {
            return Arrays.asList(EntityType.SP.getType(), EntityType.RP.getType());
        }
        if (type.equals(EntityType.RP.getType())) {
            return Arrays.asList(EntityType.IDP.getType(), EntityType.RP.getType());
        }
        throw new IllegalArgumentException("Not supported MetaData type " + type);
    }

    private String entityId(MetaData metaData) {
        return (String)metaData.getData().get("entityid");
    }

    private void revision(MetaData metaData) {
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest("System");
        this.metaDataRepository.update(metaData);
    }
}

