/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.springframework.util.CollectionUtils;

public class EntityIdConstraintsHook
extends MetaDataHookAdapter {
    private MetaDataRepository metaDataRepository;

    public EntityIdConstraintsHook(MetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return true;
    }

    public MetaData prePost(MetaData metaData) {
        return this.doPre(metaData);
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        return this.doPre(newMetaData);
    }

    private MetaData doPre(MetaData newMetaData) {
        String metaDataType = newMetaData.getType();
        HashMap<String, EntityType> relationsToCheck = new HashMap<String, EntityType>();
        relationsToCheck.put("allowedEntities", metaDataType.equals(EntityType.SP.getType()) || metaDataType.equals(EntityType.RP.getType()) ? EntityType.IDP : EntityType.SP);
        relationsToCheck.put("disableConsent", metaDataType.equals(EntityType.SP.getType()) || metaDataType.equals(EntityType.RP.getType()) ? EntityType.IDP : EntityType.SP);
        relationsToCheck.put("allowedResourceServers", EntityType.RP);
        relationsToCheck.entrySet().forEach(entry -> {
            List references;
            String key = (String)entry.getKey();
            if (newMetaData.getData().containsKey(key) && !CollectionUtils.isEmpty((Collection)(references = (List)newMetaData.getData().get(key)))) {
                List strippedReferences = references.stream().filter(map -> !CollectionUtils.isEmpty((Collection)this.metaDataRepository.findRaw(((EntityType)entry.getValue()).getType(), String.format("{\"data.entityid\" : \"%s\"}", map.get("name"))))).collect(Collectors.toList());
                newMetaData.getData().put(key, strippedReferences);
            }
        });
        return newMetaData;
    }
}

