/*
 * Decompiled with CFR 0.152.
 */
package manage.format;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import manage.conf.MetaDataAutoConfiguration;
import manage.model.EntityType;
import org.springframework.core.io.Resource;

public class MetaDataFeedParser {
    private static final String ATTRIBUTES = "attributes";
    private List<String> languages;

    public MetaDataFeedParser(List<String> languages) {
        this.languages = languages;
    }

    public List<Map<String, Object>> importFeed(Resource xml, MetaDataAutoConfiguration metaDataAutoConfiguration) throws XMLStreamException, IOException {
        XMLInputFactory factory = this.getFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(xml.getInputStream());
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        while (reader.hasNext()) {
            Map entity = this.parseEntity(EntityType.SP, Optional.empty(), metaDataAutoConfiguration, reader, true);
            results.add(entity);
        }
        return results;
    }

    private XMLInputFactory getFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlInputFactory;
    }

    public Map<String, Object> importXML(Resource xml, EntityType entityType, Optional<String> entityIDOptional, MetaDataAutoConfiguration metaDataAutoConfiguration) throws XMLStreamException, IOException {
        XMLInputFactory factory = this.getFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(xml.getInputStream());
        return this.parseEntity(entityType, entityIDOptional, metaDataAutoConfiguration, reader, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Map<String, Object> parseEntity(EntityType entityType, Optional<String> entityIDOptional, MetaDataAutoConfiguration metaDataAutoConfiguration, XMLStreamReader reader, boolean enforceTypeStrictness) throws XMLStreamException {
        result = new TreeMap<String, Object>();
        metaDataFields = new TreeMap<K, V>();
        result.put("metaDataFields", metaDataFields);
        inKeyDescriptor = false;
        inContact = true;
        inUIInfo = false;
        inCorrectEntityDescriptor = false;
        inAttributeConsumingService = false;
        inEntityAttributes = false;
        typeMismatch = false;
        inCorrectTypeDescriptor = false;
        result.put("type", entityType.getJanusDbValue());
        isSp = entityType.equals((Object)EntityType.SP);
        arpKeys /* !! */  = new HashSet<E>();
        arpAliases /* !! */  = new HashMap<K, V>();
        spSchema = metaDataAutoConfiguration.schemaRepresentation(EntityType.SP);
        assertionConsumerServiceMultiplicity = this.getMultiplicity(spSchema, new String[]{"^AssertionConsumerService:", ":index$"});
        idpSchema = metaDataAutoConfiguration.schemaRepresentation(EntityType.IDP);
        singleSignOnServiceMultiplicity = this.getMultiplicity(idpSchema, new String[]{"^SingleSignOnService:", ":Binding$"});
        contactsMultiplicity = this.getMultiplicity(idpSchema, new String[]{"^contacts:", ":contactType$"});
        validSingleSignOnServiceBindings = this.getValidBindings(idpSchema, "SingleSignOnService_Binding");
        validSingleLogoutServiceBindings = this.getValidBindings(spSchema, "SingleLogoutService_Binding");
        validAssertionConsumerServiceBindings = this.getValidBindings(spSchema, "AssertionConsumerService_Binding");
lbl26:
        // 28 sources

        block86: while (reader.hasNext()) {
            next = reader.next();
            block0 : switch (next) {
                case 1: {
                    var29_29 = startLocalName = reader.getLocalName();
                    var30_30 = -1;
                    switch (var29_29.hashCode()) {
                        case 397194800: {
                            if (!var29_29.equals("EntitiesDescriptor")) break;
                            var30_30 = 0;
                            break;
                        }
                        case -1146906670: {
                            if (!var29_29.equals("EntityDescriptor")) break;
                            var30_30 = 1;
                            break;
                        }
                        case -951056511: {
                            if (!var29_29.equals("SPSSODescriptor")) break;
                            var30_30 = 2;
                            break;
                        }
                        case -703786423: {
                            if (!var29_29.equals("IDPSSODescriptor")) break;
                            var30_30 = 3;
                            break;
                        }
                        case -1815588082: {
                            if (!var29_29.equals("KeyDescriptor")) break;
                            var30_30 = 4;
                            break;
                        }
                        case -314623983: {
                            if (!var29_29.equals("X509Certificate")) break;
                            var30_30 = 5;
                            break;
                        }
                        case 1701216835: {
                            if (!var29_29.equals("SingleLogoutService")) break;
                            var30_30 = 6;
                            break;
                        }
                        case -1547224419: {
                            if (!var29_29.equals("AssertionConsumerService")) break;
                            var30_30 = 7;
                            break;
                        }
                        case 1461245713: {
                            if (!var29_29.equals("SingleSignOnService")) break;
                            var30_30 = 8;
                            break;
                        }
                        case -748289753: {
                            if (!var29_29.equals("RegistrationInfo")) break;
                            var30_30 = 9;
                            break;
                        }
                        case -1645410453: {
                            if (!var29_29.equals("RegistrationPolicy")) break;
                            var30_30 = 10;
                            break;
                        }
                        case -1454163624: {
                            if (!var29_29.equals("AttributeConsumingService")) break;
                            var30_30 = 11;
                            break;
                        }
                        case -1791788702: {
                            if (!var29_29.equals("UIInfo")) break;
                            var30_30 = 12;
                            break;
                        }
                        case -912949683: {
                            if (!var29_29.equals("DisplayName")) break;
                            var30_30 = 13;
                            break;
                        }
                        case 2374091: {
                            if (!var29_29.equals("Logo")) break;
                            var30_30 = 14;
                            break;
                        }
                        case -56677412: {
                            if (!var29_29.equals("Description")) break;
                            var30_30 = 15;
                            break;
                        }
                        case -411096824: {
                            if (!var29_29.equals("PrivacyStatementURL")) break;
                            var30_30 = 16;
                            break;
                        }
                        case -260703552: {
                            if (!var29_29.equals("ServiceName")) break;
                            var30_30 = 17;
                            break;
                        }
                        case 1388400167: {
                            if (!var29_29.equals("ServiceDescription")) break;
                            var30_30 = 18;
                            break;
                        }
                        case -848729362: {
                            if (!var29_29.equals("RequestedAttribute")) break;
                            var30_30 = 19;
                            break;
                        }
                        case 1623084670: {
                            if (!var29_29.equals("OrganizationName")) break;
                            var30_30 = 20;
                            break;
                        }
                        case 1763392282: {
                            if (!var29_29.equals("OrganizationDisplayName")) break;
                            var30_30 = 21;
                            break;
                        }
                        case 329458460: {
                            if (!var29_29.equals("OrganizationURL")) break;
                            var30_30 = 22;
                            break;
                        }
                        case 1316701045: {
                            if (!var29_29.equals("ContactPerson")) break;
                            var30_30 = 23;
                            break;
                        }
                        case -821952632: {
                            if (!var29_29.equals("GivenName")) break;
                            var30_30 = 24;
                            break;
                        }
                        case -189293349: {
                            if (!var29_29.equals("SurName")) break;
                            var30_30 = 25;
                            break;
                        }
                        case -906611496: {
                            if (!var29_29.equals("EmailAddress")) break;
                            var30_30 = 26;
                            break;
                        }
                        case -104783795: {
                            if (!var29_29.equals("TelephoneNumber")) break;
                            var30_30 = 27;
                            break;
                        }
                        case 7105978: {
                            if (!var29_29.equals("EntityAttributes")) break;
                            var30_30 = 28;
                            break;
                        }
                        case 1322714197: {
                            if (!var29_29.equals("AttributeValue")) break;
                            var30_30 = 29;
                        }
                    }
                    switch (var30_30) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            optional = this.getAttributeValue(reader, "entityID");
                            if (optional.isPresent()) {
                                if (entityIDOptional.isPresent()) {
                                    inCorrectEntityDescriptor = entityIDOptional.get().equalsIgnoreCase((String)optional.get());
                                }
                                if (inCorrectEntityDescriptor || !entityIDOptional.isPresent()) {
                                    result.put("entityid", optional.get());
                                    break;
                                }
                            }
                            ** GOTO lbl26
                        }
                        case 2: {
                            if (isSp && !entityIDOptional.isPresent()) {
                                inCorrectEntityDescriptor = true;
                            }
                            if (inCorrectEntityDescriptor) {
                                inCorrectTypeDescriptor = isSp;
                                if (isSp) {
                                    arpKeys /* !! */  = this.arpKeys(EntityType.SP, metaDataAutoConfiguration, isSp);
                                    arpAliases /* !! */  = this.arpAliases(EntityType.SP, metaDataAutoConfiguration, isSp);
                                    arp = new TreeMap<String, Serializable>();
                                    arp.put("enabled", Boolean.valueOf(false));
                                    attributes = new TreeMap<K, V>();
                                    arp.put("attributes", attributes);
                                    result.put("arp", arp);
                                    break;
                                }
                                typeMismatch = true;
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 3: {
                            if (!isSp && !entityIDOptional.isPresent()) {
                                inCorrectEntityDescriptor = true;
                            }
                            if (inCorrectEntityDescriptor) {
                                v0 = inCorrectTypeDescriptor = isSp == false;
                                if (isSp) {
                                    typeMismatch = true;
                                    break;
                                }
                            }
                            ** GOTO lbl26
                        }
                        case 4: {
                            if (inCorrectEntityDescriptor) {
                                if (!inCorrectTypeDescriptor) break;
                                use = this.getAttributeValue(reader, "use");
                                if (!use.isPresent() || ((String)use.get()).equals("signing")) {
                                    inKeyDescriptor = true;
                                    break;
                                }
                            }
                            ** GOTO lbl26
                        }
                        case 5: {
                            if (!inCorrectEntityDescriptor) break;
                            if (inKeyDescriptor) {
                                inKeyDescriptor = false;
                                cert = reader.getElementText().replaceAll("[\n\r]", "").trim();
                                this.addCert(metaDataFields, cert);
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 6: {
                            if (inCorrectEntityDescriptor && isSp) {
                                bindingOpt = this.getAttributeValue(reader, "Binding");
                                if (!bindingOpt.isPresent() || !validSingleLogoutServiceBindings.contains(binding = (String)bindingOpt.get())) continue block86;
                                this.addMetaDataField(metaDataFields, reader, "Binding", "SingleLogoutService_Binding");
                                this.addMetaDataField(metaDataFields, reader, "Location", "SingleLogoutService_Location");
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 7: {
                            if (inCorrectEntityDescriptor && isSp) {
                                bindingOpt = this.getAttributeValue(reader, "Binding");
                                if (!bindingOpt.isPresent() || !validAssertionConsumerServiceBindings.contains(binding = (String)bindingOpt.get())) continue block86;
                                this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Binding", assertionConsumerServiceMultiplicity, binding);
                                locationOpt = this.getAttributeValue(reader, "Location");
                                locationOpt.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseEntity$0(java.util.Map int java.lang.String ), (Ljava/lang/String;)V)((MetaDataFeedParser)this, metaDataFields, (int)assertionConsumerServiceMultiplicity));
                                indexOpt = this.getAttributeValue(reader, "index");
                                indexOpt.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseEntity$1(java.util.Map int java.lang.String ), (Ljava/lang/String;)V)((MetaDataFeedParser)this, metaDataFields, (int)assertionConsumerServiceMultiplicity));
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 8: {
                            if (inCorrectEntityDescriptor) {
                                if (isSp) break;
                                bindingOpt = this.getAttributeValue(reader, "Binding");
                                if (bindingOpt.isPresent()) {
                                    binding = (String)bindingOpt.get();
                                    if (!validSingleSignOnServiceBindings.contains(binding)) continue block86;
                                    this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Binding", singleSignOnServiceMultiplicity, binding);
                                    locationOpt = this.getAttributeValue(reader, "Location");
                                    locationOpt.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseEntity$2(java.util.Map int java.lang.String ), (Ljava/lang/String;)V)((MetaDataFeedParser)this, metaDataFields, (int)singleSignOnServiceMultiplicity));
                                    break;
                                }
                            }
                            ** GOTO lbl26
                        }
                        case 9: {
                            if (inCorrectEntityDescriptor) {
                                this.getAttributeValue(reader, "registrationAuthority").ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseEntity$3(java.util.Map java.lang.String ), (Ljava/lang/String;)V)(metaDataFields));
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 10: {
                            if (inCorrectEntityDescriptor) {
                                this.addLanguageElement(metaDataFields, reader, "mdrpi:RegistrationPolicy");
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 11: {
                            inAttributeConsumingService = inCorrectEntityDescriptor;
                            break;
                        }
                        case 12: {
                            inUIInfo = inCorrectEntityDescriptor;
                            break;
                        }
                        case 13: {
                            if (inUIInfo) {
                                this.addLanguageElement(metaDataFields, reader, "name");
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 14: {
                            if (inUIInfo) {
                                this.addLogo(metaDataFields, reader);
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 15: {
                            if (inUIInfo) {
                                this.addLanguageElement(metaDataFields, reader, "description");
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 16: {
                            if (inUIInfo) {
                                this.addLanguageElement(metaDataFields, reader, "mdui:PrivacyStatementURL");
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 17: {
                            if (inAttributeConsumingService) {
                                this.addLanguageElement(metaDataFields, reader, "name");
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 18: {
                            if (inAttributeConsumingService) {
                                this.addLanguageElement(metaDataFields, reader, "description");
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 19: {
                            if (inAttributeConsumingService && isSp) {
                                this.addArpAttribute(result, reader, arpKeys /* !! */ , arpAliases /* !! */ );
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 20: {
                            if (!inCorrectEntityDescriptor) break;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationName");
                            break;
                        }
                        case 21: {
                            if (!inCorrectEntityDescriptor) break;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationDisplayName");
                            break;
                        }
                        case 22: {
                            if (!inCorrectEntityDescriptor) break;
                            this.addLanguageElement(metaDataFields, reader, "OrganizationURL");
                            break;
                        }
                        case 23: {
                            if (!inCorrectEntityDescriptor) break;
                            contactType = this.getAttributeValue(reader, "contactType").orElse("other");
                            this.addMultiplicity(metaDataFields, "contacts:%s:contactType", contactsMultiplicity, contactType);
                            inContact = true;
                            break;
                        }
                        case 24: {
                            if (inCorrectEntityDescriptor && inContact) {
                                this.addMultiplicity(metaDataFields, "contacts:%s:givenName", contactsMultiplicity, reader.getElementText());
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 25: {
                            if (inCorrectEntityDescriptor && inContact) {
                                this.addMultiplicity(metaDataFields, "contacts:%s:surName", contactsMultiplicity, reader.getElementText());
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 26: {
                            if (inCorrectEntityDescriptor && inContact) {
                                this.addMultiplicity(metaDataFields, "contacts:%s:emailAddress", contactsMultiplicity, reader.getElementText().replaceAll(Pattern.quote("mailto:"), ""));
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 27: {
                            if (inCorrectEntityDescriptor && inContact) {
                                this.addMultiplicity(metaDataFields, "contacts:%s:telephoneNumber", contactsMultiplicity, reader.getElementText());
                                break;
                            }
                            ** GOTO lbl26
                        }
                        case 28: {
                            inEntityAttributes = inCorrectEntityDescriptor;
                            break;
                        }
                        case 29: {
                            if (inEntityAttributes) {
                                this.addCoinEntityCategories(entityType, metaDataFields, metaDataAutoConfiguration, reader.getElementText());
                            } else {
                                break;
                            }
                        }
                    }
                    continue block86;
                }
                case 2: {
                    var30_31 = localName = reader.getLocalName();
                    var31_33 = -1;
                    switch (var30_31.hashCode()) {
                        case 1316701045: {
                            if (!var30_31.equals("ContactPerson")) break;
                            var31_33 = 0;
                            break;
                        }
                        case -1454163624: {
                            if (!var30_31.equals("AttributeConsumingService")) break;
                            var31_33 = 1;
                            break;
                        }
                        case -1791788702: {
                            if (!var30_31.equals("UIInfo")) break;
                            var31_33 = 2;
                            break;
                        }
                        case -703786423: {
                            if (!var30_31.equals("IDPSSODescriptor")) break;
                            var31_33 = 3;
                            break;
                        }
                        case -951056511: {
                            if (!var30_31.equals("SPSSODescriptor")) break;
                            var31_33 = 4;
                            break;
                        }
                        case -1146906670: {
                            if (!var30_31.equals("EntityDescriptor")) break;
                            var31_33 = 5;
                            break;
                        }
                        case 7105978: {
                            if (!var30_31.equals("EntityAttributes")) break;
                            var31_33 = 6;
                        }
                    }
                    switch (var31_33) {
                        case 0: {
                            inContact = false;
                            break block0;
                        }
                        case 1: {
                            inAttributeConsumingService = false;
                            break block0;
                        }
                        case 2: {
                            inUIInfo = false;
                            break block0;
                        }
                        case 3: {
                            inCorrectTypeDescriptor = isSp == false;
                            break block0;
                        }
                        case 4: {
                            inCorrectTypeDescriptor = isSp;
                            break block0;
                        }
                        case 5: {
                            if (inCorrectEntityDescriptor) {
                                return typeMismatch != false && enforceTypeStrictness != false ? new HashMap<K, V>() : this.enrichMetaData(result);
                            }
                            ** GOTO lbl26
                        }
                        case 6: {
                            inEntityAttributes = false;
                        }
                    }
                }
            }
        }
        return new HashMap<String, Object>();
    }

    private int getMultiplicity(Map<String, Object> schema, String ... keyParts) {
        List<String> keyPartsList = Arrays.asList(keyParts);
        Map patternProperties = (Map)((Map)((Map)schema.get("properties")).get("metaDataFields")).get("patternProperties");
        Optional<String> optionalKey = patternProperties.keySet().stream().filter(key -> keyPartsList.stream().allMatch(part -> key.contains((CharSequence)part))).findAny();
        String key2 = optionalKey.orElseThrow(() -> new IllegalArgumentException(String.format("No key %s in schema %s", keyPartsList, patternProperties)));
        return (Integer)((Map)patternProperties.get(key2)).get("multiplicity");
    }

    private List<String> getValidBindings(Map<String, Object> schema, String key) {
        return (List)((Map)((Map)schema.get("definitions")).get(key)).get("enum");
    }

    private Map<String, Object> enrichMetaData(Map<String, Object> metaData) {
        Map metaDataFields = (Map)metaData.get("metaDataFields");
        this.languages.forEach(language -> {
            if (!metaDataFields.containsKey("name:" + language) && metaDataFields.containsKey("OrganizationName:" + language)) {
                metaDataFields.put("name:" + language, metaDataFields.get("OrganizationName:" + language));
            }
        });
        return metaData;
    }

    private Set<String> arpKeys(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        return this.arpAttributes(type, metaDataAutoConfiguration, isSp).keySet();
    }

    private Map<String, String> arpAliases(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        Map arp = this.arpAttributes(type, metaDataAutoConfiguration, isSp);
        return arp.entrySet().stream().filter(entry -> ((Map)Map.class.cast(entry.getValue())).containsKey("alias")).collect(Collectors.toMap(entry -> (String)((Map)Map.class.cast(entry.getValue())).get("alias"), entry -> (String)entry.getKey(), (alias1, alias2) -> alias1));
    }

    private Map<String, Object> arpAttributes(EntityType type, MetaDataAutoConfiguration metaDataAutoConfiguration, boolean isSp) {
        Map<String, Object> arpAttributes;
        Map schema = metaDataAutoConfiguration.schemaRepresentation(type);
        Map<String, Object> map = arpAttributes = isSp ? (Map)Map.class.cast(schema.get("properties")) : new HashMap<String, Object>();
        if (isSp) {
            for (String s : Arrays.asList("arp", "properties", ATTRIBUTES, "properties")) {
                arpAttributes = (Map)Map.class.cast(arpAttributes.get(s));
            }
        }
        return arpAttributes;
    }

    private void addArpAttribute(Map<String, Object> result, XMLStreamReader reader, Set<String> arpKeys, Map<String, String> arpAliases) {
        Optional name = this.getAttributeValue(reader, "Name");
        Optional friendlyName = this.getAttributeValue(reader, "FriendlyName");
        if (this.shouldAddAttributeToArp(name, arpKeys)) {
            this.doAddArpAttribute(result, arpKeys, (String)name.get());
        } else if (this.shouldAddAttributeToArp(friendlyName, arpKeys)) {
            this.doAddArpAttribute(result, arpKeys, (String)friendlyName.get());
        } else if (name.isPresent() && arpAliases.containsKey(name.get())) {
            this.doAddArpAttribute(result, arpKeys, arpAliases.get(name.get()));
        }
    }

    private boolean shouldAddAttributeToArp(Optional<String> name, Set<String> allowedArpKeys) {
        return name.isPresent() && allowedArpKeys.stream().anyMatch(arpKey -> arpKey.endsWith((String)name.get()));
    }

    private void doAddArpAttribute(Map<String, Object> result, Set<String> arpKeys, String friendlyName) {
        Map arp = (Map)Map.class.cast(result.getOrDefault("arp", new TreeMap()));
        arp.put("enabled", true);
        Map attributes = (Map)Map.class.cast(arp.getOrDefault(ATTRIBUTES, new TreeMap()));
        arpKeys.stream().filter(arpKey -> arpKey.endsWith(friendlyName)).findFirst().ifPresent(arpKey -> {
            List arpEntry = (List)List.class.cast(attributes.getOrDefault(arpKey, new ArrayList()));
            HashMap<String, String> arpValue = new HashMap<String, String>();
            arpValue.put("source", "idp");
            arpValue.put("value", "*");
            arpEntry.add(arpValue);
            attributes.put(arpKey, arpEntry);
        });
        arp.put(ATTRIBUTES, attributes);
        result.put("arp", arp);
    }

    private void addMetaDataField(Map<String, String> metaDataFields, XMLStreamReader reader, String attributeName, String metaDataKey) {
        Optional optional = this.getAttributeValue(reader, attributeName);
        optional.ifPresent(value -> metaDataFields.put(metaDataKey, (String)value));
    }

    private void addLanguageElement(Map<String, String> metaDataFields, XMLStreamReader reader, String elementName) throws XMLStreamException {
        String language = this.getAttributeValue(reader, "lang").orElse("en");
        if (this.languages.contains(language)) {
            metaDataFields.put(String.format("%s:%s", elementName, language), reader.getElementText());
        }
    }

    private void addMultiplicity(Map<String, String> result, String format, int multiplicity, String value) {
        List keys = IntStream.range(0, multiplicity).mapToObj(nbr -> String.format(format, nbr)).collect(Collectors.toList());
        long count = result.keySet().stream().filter(key -> keys.contains(key)).count();
        if (count < (long)keys.size()) {
            result.put((String)keys.get((int)count), value);
        }
    }

    private void addCert(Map<String, String> result, String cert) {
        List<String> certDataKeys = Arrays.asList("certData", "certData2", "certData3");
        long count = result.keySet().stream().filter(certDataKeys::contains).count();
        if (count < (long)certDataKeys.size() && !certDataKeys.stream().map(key -> cert.equals(result.get(key))).anyMatch(b -> b)) {
            result.put(certDataKeys.get((int)count), cert);
        }
    }

    private void addLogo(Map<String, String> metaDataFields, XMLStreamReader reader) throws XMLStreamException {
        this.getAttributeValue(reader, "width").ifPresent(width -> metaDataFields.put("logo:0:width", (String)width));
        this.getAttributeValue(reader, "height").ifPresent(height -> metaDataFields.put("logo:0:height", (String)height));
        metaDataFields.put("logo:0:url", reader.getElementText());
    }

    private Optional<String> getAttributeValue(XMLStreamReader reader, String attributeName) {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            QName qName = reader.getAttributeName(i);
            if (!qName.getLocalPart().equalsIgnoreCase(attributeName)) continue;
            return Optional.of(reader.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()));
        }
        return Optional.empty();
    }

    private void addCoinEntityCategories(EntityType entityType, Map<String, String> metaDataFields, MetaDataAutoConfiguration metaDataAutoConfiguration, String elementText) {
        String strippedValue;
        Map schema = metaDataAutoConfiguration.schemaRepresentation(entityType);
        Map schemaPart = this.unpack(schema, Arrays.asList("properties", "metaDataFields", "patternProperties", "^coin:entity_categories:"));
        List enumeration = (List)schemaPart.get("enum");
        if (!enumeration.contains(strippedValue = elementText.replaceAll("\n", "").trim())) {
            return;
        }
        String entityCategoryKey = "coin:entity_categories:";
        List categories = metaDataFields.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(entityCategoryKey)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (categories.contains(strippedValue)) {
            return;
        }
        int multiplicity = (Integer)schemaPart.get("multiplicity");
        int startIndex = (Integer)schemaPart.get("startIndex");
        metaDataFields.keySet().stream().filter(s -> s.startsWith(entityCategoryKey)).map(s -> Integer.valueOf(s.substring(entityCategoryKey.length()))).max(Integer::compareTo).map(i -> {
            String string;
            if (multiplicity >= startIndex + i) {
                i = i + 1;
                string = "put returns null" + metaDataFields.put(entityCategoryKey + i, strippedValue);
            } else {
                string = "";
            }
            return string;
        }).orElseGet(() -> metaDataFields.put(entityCategoryKey + startIndex, strippedValue));
    }

    private Map<String, Object> unpack(Map<String, Object> schema, List<String> keys) {
        return ((Stream)keys.stream().sequential()).reduce(schema, (map, s) -> s.startsWith("^") ? (Map)Map.class.cast(map.get(map.keySet().stream().filter(k -> k.startsWith((String)s)).findAny().orElseThrow(() -> new IllegalArgumentException("Key not present: " + s)))) : (Map)Map.class.cast(map.get(s)), (acc, com) -> com);
    }

    private static /* synthetic */ void lambda$parseEntity$3(Map metaDataFields, String authority) {
        metaDataFields.put("mdrpi:RegistrationInfo", authority);
    }

    private /* synthetic */ void lambda$parseEntity$2(Map metaDataFields, int singleSignOnServiceMultiplicity, String location) {
        this.addMultiplicity(metaDataFields, "SingleSignOnService:%s:Location", singleSignOnServiceMultiplicity, location);
    }

    private /* synthetic */ void lambda$parseEntity$1(Map metaDataFields, int assertionConsumerServiceMultiplicity, String index) {
        this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:index", assertionConsumerServiceMultiplicity, index);
    }

    private /* synthetic */ void lambda$parseEntity$0(Map metaDataFields, int assertionConsumerServiceMultiplicity, String location) {
        this.addMultiplicity(metaDataFields, "AssertionConsumerService:%s:Location", assertionConsumerServiceMultiplicity, location);
    }
}

