/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;

public class TypeSafetyHook
extends MetaDataHookAdapter {
    private MetaDataAutoConfiguration metaDataAutoConfiguration;

    public TypeSafetyHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public MetaData preValidate(MetaData metaData) {
        Map schema = this.metaDataAutoConfiguration.schemaRepresentation(EntityType.fromType((String)metaData.getType()));
        Map schemaMetaDataFields = (Map)Map.class.cast(((Map)Map.class.cast(schema.get("properties"))).get("metaDataFields"));
        List booleanPatternKeys = this.typedProperties(schemaMetaDataFields, "boolean", "patternProperties");
        List numberPatternKeys = this.typedProperties(schemaMetaDataFields, "number", "patternProperties");
        List booleanKeys = this.typedProperties(schemaMetaDataFields, "boolean", "properties");
        List numberKeys = this.typedProperties(schemaMetaDataFields, "number", "properties");
        Map metaDataFields = metaData.metaDataFields();
        metaDataFields.forEach((key, value) -> {
            if ((this.propertyMatches(key, booleanKeys) || this.patternPopertyMatches(key, booleanPatternKeys)) && value instanceof String) {
                metaDataFields.put(key, "1".equals(value));
            }
            if ((this.propertyMatches(key, numberKeys) || this.patternPopertyMatches(key, numberPatternKeys)) && value instanceof String) {
                metaDataFields.put(key, Integer.parseInt((String)value));
            }
        });
        return metaData;
    }

    private boolean propertyMatches(String key, List<String> properties) {
        return properties.contains(key);
    }

    private boolean patternPopertyMatches(String key, List<String> patternProperties) {
        return patternProperties.stream().filter(prop -> Pattern.compile(prop).matcher(key).matches()).count() > 0L;
    }

    private List<String> typedProperties(Map metaDataFields, String type, String name) {
        Map patternProperties = (Map)metaDataFields.get(name);
        return patternProperties.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey("type") && ((Map)e.getValue()).get("type").equals(type)).map(e -> (String)e.getKey()).collect(Collectors.toList());
    }
}

