/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import manage.api.APIUser;
import manage.api.Scope;
import manage.conf.MetaDataAutoConfiguration;
import manage.exception.DuplicateEntityIdException;
import manage.exception.ResourceNotFoundException;
import manage.format.Exporter;
import manage.format.Importer;
import manage.format.SaveURLResource;
import manage.hook.MetaDataHook;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.MetaData;
import manage.model.MetaDataUpdate;
import manage.model.RevisionRestore;
import manage.model.ServiceProvider;
import manage.model.XML;
import manage.repository.MetaDataRepository;
import manage.shibboleth.FederatedUser;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaDataController {
    static final String REQUESTED_ATTRIBUTES = "REQUESTED_ATTRIBUTES";
    static final String ALL_ATTRIBUTES = "ALL_ATTRIBUTES";
    static final String LOGICAL_OPERATOR_IS_AND = "LOGICAL_OPERATOR_IS_AND";
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataController.class);
    private MetaDataRepository metaDataRepository;
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private MetaDataHook metaDataHook;
    private Importer importer;
    private Exporter exporter;
    private Environment environment;

    @Autowired
    public MetaDataController(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, ResourceLoader resourceLoader, MetaDataHook metaDataHook, Environment environment, @Value(value="${metadata_export_path}") String metadataExportPath, @Value(value="${product.supported_languages}") String supportedLanguages) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataHook = metaDataHook;
        List languages = Stream.of(supportedLanguages.split(",")).map(String::trim).collect(Collectors.toList());
        this.importer = new Importer(metaDataAutoConfiguration, languages);
        this.exporter = new Exporter(Clock.systemDefaultZone(), resourceLoader, metadataExportPath, languages);
        this.environment = environment;
    }

    @GetMapping(value={"/client/template/{type}"})
    public MetaData template(@PathVariable(value="type") String type) {
        Map data = this.metaDataAutoConfiguration.metaDataTemplate(type);
        return new MetaData(type, data);
    }

    @GetMapping(value={"/client/metadata/{type}/{id}", "/internal/metadata/{type}/{id}"})
    public MetaData get(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        MetaData metaData = this.metaDataRepository.findById(id, type);
        this.checkNull(type, id, metaData);
        return this.metaDataHook.postGet(metaData);
    }

    private void checkNull(@PathVariable(value="type") String type, @PathVariable(value="id") String id, MetaData metaData) {
        if (metaData == null) {
            throw new ResourceNotFoundException(String.format("MetaData type %s with id %s does not exist", type, id));
        }
    }

    @GetMapping(value={"/client/metadata/configuration"})
    public List<Map<String, Object>> configuration() {
        return this.metaDataAutoConfiguration.schemaRepresentations();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/metadata"})
    public MetaData post(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        return this.doPost(metaData, federatedUser.getUid(), false);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/includeInPush/{type}/{id}"})
    public MetaData includeInPush(@PathVariable(value="type") String type, @PathVariable(value="id") String id, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData metaData = this.get(type, id);
        Map metaDataFields = metaData.metaDataFields();
        metaDataFields.remove("coin:exclude_from_push");
        metaData.getData().remove("oidcClient");
        return this.doPut(metaData, federatedUser.getUid(), false);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/metadata"})
    public MetaData postInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.doPost(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/new-sp"})
    public MetaData newSP(@Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        Map innerJson = this.importer.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        String entityId = (String)String.class.cast(innerJson.get("entityid"));
        List result = this.metaDataRepository.search(EntityType.SP.getType(), Collections.singletonMap("entityid", entityId), Collections.emptyList(), Boolean.valueOf(false), Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty((Collection)result)) {
            throw new DuplicateEntityIdException(entityId);
        }
        this.addDefaultSpData(innerJson);
        MetaData metaData = new MetaData(EntityType.SP.getType(), innerJson);
        return this.doPost(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/delete/feed"})
    public Map<String, Integer> deleteFeed() {
        int deleted = this.metaDataRepository.deleteAllImportedServiceProviders();
        return Collections.singletonMap("deleted", deleted);
    }

    @GetMapping(value={"/client/count/feed"})
    public Map<String, Long> countFeed() {
        long count = this.metaDataRepository.countAllImportedServiceProviders();
        return Collections.singletonMap("count", count);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/feed"})
    public Map<String, List> importFeed(@Validated @RequestBody Import importRequest) {
        try {
            Map<String, ServiceProvider> serviceProviderMap = this.metaDataRepository.allServiceProviderEntityIds().stream().map(ServiceProvider::new).collect(Collectors.toMap(sp -> sp.getEntityId(), sp -> sp));
            String feedUrl = importRequest.getUrl();
            SaveURLResource resource = new SaveURLResource(new URL(feedUrl), this.environment.acceptsProfiles(new String[]{"dev"}));
            List allImports = this.importer.importFeed((Resource)resource);
            List<Map> imports = allImports.stream().filter(m -> !m.isEmpty()).collect(Collectors.toList());
            HashMap<String, List> results = new HashMap<String, List>();
            EntityType entityType = EntityType.SP;
            imports.forEach(sp -> {
                block11: {
                    String entityId = (String)sp.get("entityid");
                    sp.put("metadataurl", feedUrl);
                    Map metaDataFields = (Map)Map.class.cast(sp.get("metaDataFields"));
                    metaDataFields.put("coin:imported_from_edugain", true);
                    metaDataFields.put("coin:interfed_source", "eduGAIN");
                    ServiceProvider existingServiceProvider = (ServiceProvider)serviceProviderMap.get(entityId);
                    if (existingServiceProvider != null) {
                        if (existingServiceProvider.isPublishedInEduGain()) {
                            List publishedInEdugain = results.computeIfAbsent("published_in_edugain", s -> new ArrayList());
                            publishedInEdugain.add(existingServiceProvider);
                        } else if (existingServiceProvider.isImportedFromEduGain()) {
                            try {
                                MetaDataUpdate metaDataUpdate = this.importToMetaDataUpdate(existingServiceProvider.getId(), entityType, sp, feedUrl);
                                Optional metaData = this.doMergeUpdate(metaDataUpdate, "edugain-import", false);
                                if (metaData.isPresent()) {
                                    List merged = results.computeIfAbsent("merged", s -> new ArrayList());
                                    merged.add(existingServiceProvider);
                                    break block11;
                                }
                                List noChanges = results.computeIfAbsent("no_changes", s -> new ArrayList());
                                noChanges.add(existingServiceProvider);
                            }
                            catch (JsonProcessingException | ValidationException e) {
                                this.addNoValid(results, entityId, (Exception)e);
                            }
                        } else {
                            List notImported = results.computeIfAbsent("not_imported", s -> new ArrayList());
                            notImported.add(existingServiceProvider);
                        }
                    } else {
                        try {
                            MetaData metaData = this.importToMetaData(sp, entityType);
                            MetaData persistedMetaData = this.doPost(metaData, "edugain-import", false);
                            List imported = results.computeIfAbsent("imported", s -> new ArrayList());
                            imported.add(new ServiceProvider(persistedMetaData.getId(), entityId, false, false, null));
                        }
                        catch (JsonProcessingException | ValidationException e) {
                            this.addNoValid(results, entityId, (Exception)e);
                        }
                    }
                }
            });
            List<ServiceProvider> notInFeedAnymore = serviceProviderMap.values().stream().filter(sp -> sp.isImportedFromEduGain() && !imports.stream().anyMatch(map -> sp.getEntityId().equals(map.get("entityid")))).collect(Collectors.toList());
            notInFeedAnymore.forEach(sp -> this.doRemove(entityType.getType(), sp.getId(), "edugain-import"));
            List deleted = results.computeIfAbsent("deleted", s -> new ArrayList());
            deleted.addAll(notInFeedAnymore.stream().map(sp -> sp.getEntityId()).collect(Collectors.toList()));
            results.put("total", Collections.singletonList(imports.size()));
            return results;
        }
        catch (IOException | XMLStreamException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    private void addNoValid(Map<String, List> results, String entityId, Exception e) {
        String msg = e instanceof ValidationException ? String.join((CharSequence)", ", ((ValidationException)((Object)ValidationException.class.cast(e))).getAllMessages()) : e.getClass().getName();
        List notValid = results.computeIfAbsent("not_valid", s -> new ArrayList());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("validationException", msg);
        result.put("entityId", entityId);
        notValid.add(result);
    }

    private MetaData importToMetaData(Map<String, Object> m, EntityType entityType) {
        MetaData template = this.template(entityType.getType());
        template.getData().putAll(m);
        template.getData().put("state", "prodaccepted");
        return template;
    }

    private MetaDataUpdate importToMetaDataUpdate(String id, EntityType entityType, Map<String, Object> m, String feedUrl) {
        Map metaDataFields = (Map)Map.class.cast(m.get("metaDataFields"));
        HashMap<String, String> pathUpdates = new HashMap<String, String>();
        metaDataFields.forEach((k, v) -> pathUpdates.put("metaDataFields.".concat((String)k), (String)v));
        pathUpdates.put("metadataurl", feedUrl);
        MetaDataUpdate metaDataUpdate = new MetaDataUpdate(id, entityType.getType(), pathUpdates, Collections.emptyMap());
        return metaDataUpdate;
    }

    private void addDefaultSpData(Map<String, Object> innerJson) {
        innerJson.put("allowedall", true);
        innerJson.put("state", "testaccepted");
        innerJson.put("allowedEntities", new ArrayList());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/update-sp/{id}/{version}"})
    public MetaData updateSP(@PathVariable(value="id") String id, @PathVariable(value="version") Long version, @Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        MetaData metaData = this.get(EntityType.SP.getType(), id);
        Map innerJson = this.importer.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.addDefaultSpData(innerJson);
        metaData.setData(innerJson);
        metaData.setVersion(version);
        return this.doPut(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @GetMapping(value={"/internal/sp-metadata/{id}"})
    public String exportXml(@PathVariable(value="id") String id) throws IOException {
        MetaData metaData = this.get(EntityType.SP.getType(), id);
        return this.exporter.exportToXml(metaData);
    }

    private MetaData doPost(@Validated @RequestBody MetaData metaData, String uid, boolean excludeFromPushRequired) throws JsonProcessingException {
        this.sanitizeExcludeFromPush(metaData, excludeFromPushRequired);
        metaData = this.metaDataHook.prePost(metaData);
        metaData = this.validate(metaData);
        Long eid = this.metaDataRepository.incrementEid();
        metaData.initial(UUID.randomUUID().toString(), uid, eid);
        LOG.info("Saving new metaData {} by {}", (Object)metaData.getId(), (Object)uid);
        this.metaDataRepository.save(metaData);
        return this.get(metaData.getType(), metaData.getId());
    }

    private void sanitizeExcludeFromPush(@RequestBody @Validated MetaData metaData, boolean excludeFromPushRequired) {
        Map metaDataFields = metaData.metaDataFields();
        if (excludeFromPushRequired && !"1".equals(metaDataFields.get("coin:exclude_from_push"))) {
            metaDataFields.put("coin:exclude_from_push", "1");
        }
    }

    @PreAuthorize(value="hasRole('READ')")
    @PostMapping(value={"/internal/validate/metadata"})
    public ResponseEntity<Object> validateMetaData(@Validated @RequestBody MetaData metaData) throws JsonProcessingException {
        this.validate(metaData);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/metadata/{type}/{id}"})
    public boolean remove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, FederatedUser user) {
        return this.doRemove(type, id, user.getUid());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @DeleteMapping(value={"/internal/metadata/{type}/{id}"})
    public boolean removeInternal(@PathVariable(value="type") String type, @PathVariable(value="id") String id, APIUser apiUser) {
        return this.doRemove(type, id, apiUser.getName());
    }

    private boolean doRemove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, String uid) {
        MetaData current = this.metaDataRepository.findById(id, type);
        this.checkNull(type, id, current);
        current = this.metaDataHook.preDelete(current);
        this.metaDataRepository.remove(current);
        LOG.info("Deleted metaData {} by {}", (Object)current.getId(), (Object)uid);
        current.terminate(UUID.randomUUID().toString());
        this.metaDataRepository.save(current);
        return true;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata"})
    @Transactional
    public MetaData put(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        return this.doPut(metaData, federatedUser.getUid(), false);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"/internal/metadata"})
    @Transactional
    public MetaData putInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.doPut(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    private MetaData doPut(@Validated @RequestBody MetaData metaData, String updatedBy, boolean excludeFromPushRequired) throws JsonProcessingException {
        this.sanitizeExcludeFromPush(metaData, excludeFromPushRequired);
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        this.checkNull(metaData.getType(), id, previous);
        metaData = this.metaDataHook.prePut(previous, metaData);
        metaData = this.validate(metaData);
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest(updatedBy);
        this.metaDataRepository.update(metaData);
        LOG.info("Updated metaData {} by {}", (Object)metaData.getId(), (Object)updatedBy);
        return this.get(metaData.getType(), metaData.getId());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"internal/merge"})
    @Transactional
    public MetaData update(@Validated @RequestBody MetaDataUpdate metaDataUpdate, APIUser apiUser) throws JsonProcessingException {
        String name = apiUser.getName();
        return (MetaData)this.doMergeUpdate(metaDataUpdate, name, true).get();
    }

    private Optional<MetaData> doMergeUpdate(MetaDataUpdate metaDataUpdate, String name, boolean forceNewRevision) throws JsonProcessingException {
        boolean somethingChanged;
        String id = metaDataUpdate.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        this.checkNull(metaDataUpdate.getType(), id, previous);
        previous.revision(UUID.randomUUID().toString());
        MetaData metaData = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        metaData.promoteToLatest(name);
        metaData.merge(metaDataUpdate);
        if (!CollectionUtils.isEmpty((Map)metaDataUpdate.getExternalReferenceData())) {
            metaData.getData().putAll(metaDataUpdate.getExternalReferenceData());
        }
        metaData = this.metaDataHook.prePut(previous, metaData);
        boolean bl = somethingChanged = !(metaData = this.validate(metaData)).getData().equals(previous.getData());
        if (somethingChanged || forceNewRevision) {
            this.metaDataRepository.save(previous);
            this.metaDataRepository.update(metaData);
            LOG.info("Merging new metaData {} by {}", (Object)metaData.getId(), (Object)name);
            return Optional.of(this.get(metaData.getType(), metaData.getId()));
        }
        return Optional.empty();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreDeleted"})
    @Transactional
    public MetaData restoreDeleted(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        if (parent != null) {
            throw new IllegalArgumentException("Parent is not null");
        }
        String newId = revision.getRevision().getParentId();
        revision.getRevision().deTerminate(newId);
        this.metaDataRepository.update(revision);
        revision.restoreToLatest(newId, Long.valueOf(0L), federatedUser.getUid(), revision.getRevision().getNumber(), revisionRestore.getParentType());
        revision = this.validate(revision);
        this.metaDataRepository.save(revision);
        LOG.info("Restored deleted revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreRevision"})
    @Transactional
    public MetaData restoreRevision(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        revision.restoreToLatest(parent.getId(), parent.getVersion(), federatedUser.getUid(), parent.getRevision().getNumber(), revisionRestore.getParentType());
        revision = this.validate(revision);
        this.metaDataRepository.update(revision);
        parent.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(parent);
        LOG.info("Restored revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    @GetMapping(value={"/client/revisions/{type}/{parentId}"})
    public List<MetaData> revisions(@PathVariable(value="type") String type, @PathVariable(value="parentId") String parentId) {
        return this.metaDataRepository.revisions(type.concat("_revision"), parentId);
    }

    @GetMapping(value={"/client/autocomplete/{type}"})
    public List<Map> autoCompleteEntities(@PathVariable(value="type") String type, @RequestParam(value="query") String query) {
        return this.metaDataRepository.autoComplete(type, query);
    }

    @GetMapping(value={"/client/whiteListing/{type}"})
    public List<Map> whiteListing(@PathVariable(value="type") String type, @RequestParam(value="state") String state) {
        return this.metaDataRepository.whiteListing(type, state);
    }

    @PostMapping(value={"/client/search/{type}", "/internal/search/{type}"})
    public List<Map> searchEntities(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties, @RequestParam(required=false, defaultValue="false") boolean nested) {
        List requestedAttributes = properties.getOrDefault(REQUESTED_ATTRIBUTES, new ArrayList());
        Boolean allAttributes = (Boolean)properties.getOrDefault(ALL_ATTRIBUTES, false);
        Boolean logicalOperatorIsAnd = (Boolean)properties.getOrDefault(LOGICAL_OPERATOR_IS_AND, true);
        properties.remove(REQUESTED_ATTRIBUTES);
        properties.remove(ALL_ATTRIBUTES);
        properties.remove(LOGICAL_OPERATOR_IS_AND);
        List search = this.metaDataRepository.search(type, properties, requestedAttributes, allAttributes, logicalOperatorIsAnd);
        return nested ? search.stream().map(m -> this.exporter.nestMetaData(m, type)).collect(Collectors.toList()) : search;
    }

    @GetMapping(value={"/client/rawSearch/{type}", "/internal/rawSearch/{type}"})
    public List<MetaData> rawSearch(@PathVariable(value="type") String type, @RequestParam(value="query") String query) throws UnsupportedEncodingException {
        if (query.startsWith("%")) {
            query = URLDecoder.decode(query, "UTF-8");
        }
        return this.metaDataRepository.findRaw(type, query);
    }

    private MetaData validate(MetaData metaData) throws JsonProcessingException {
        metaData = this.metaDataHook.preValidate(metaData);
        this.metaDataAutoConfiguration.validate(metaData.getData(), metaData.getType());
        return metaData;
    }
}

