/*
 * Decompiled with CFR 0.152.
 */
package manage.model;

import java.io.Serializable;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="scopes")
public class Scope
implements Serializable {
    @Id
    private String id;
    @Version
    private Long version;
    @NotNull
    @Indexed(unique=true)
    private String name;
    private Map<String, String> descriptions;

    public Scope(String name, Map<String, String> descriptions) {
        this.name = name;
        this.descriptions = descriptions;
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public Scope() {
    }

    public Scope(String id, Long version, String name, Map<String, String> descriptions) {
        this.id = id;
        this.version = version;
        this.name = name;
        this.descriptions = descriptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Scope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "Scope(id=" + this.getId() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", descriptions=" + this.getDescriptions() + ")";
    }
}

