/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.websocket.server.PathParam;
import manage.exception.ScopeDuplicateNameException;
import manage.exception.ScopeInUseException;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.Scope;
import manage.repository.ScopeRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ScopeController {
    private static final Logger LOG = LoggerFactory.getLogger(ScopeController.class);
    private ObjectMapper objectMapper;
    private MongoTemplate mongoTemplate;
    private ScopeRepository scopeRepository;
    private List<String> supportedLanguages;

    @Autowired
    public ScopeController(MongoTemplate mongoTemplate, ScopeRepository scopeRepository, ObjectMapper objectMapper, @Value(value="${product.supported_languages}") String supportedLanguages) {
        this.mongoTemplate = mongoTemplate;
        this.scopeRepository = scopeRepository;
        this.objectMapper = objectMapper;
        this.supportedLanguages = Stream.of(supportedLanguages.split(",")).map(String::trim).collect(Collectors.toList());
    }

    @GetMapping(value={"/client/scopes_languages"})
    public List<String> supportedLanguages() {
        return this.supportedLanguages;
    }

    @GetMapping(value={"/client/scopes", "/internal/scopes"})
    public List<Scope> allScopes() {
        return this.scopeRepository.findAll();
    }

    @DeleteMapping(value={"/client/scopes/{id}"})
    public boolean delete(@PathVariable(value="id") String id) throws JsonProcessingException {
        Scope scope = (Scope)this.scopeRepository.findOne((Serializable)((Object)id));
        this.checkScopeInUse(scope);
        LOG.info("Deleting scope {}", (Object)id);
        this.scopeRepository.delete((Serializable)((Object)id));
        return true;
    }

    @GetMapping(value={"/client/fetch/{value}"}, produces={"application/json"})
    public List<String> fetchValues(@PathParam(value="value") String value) {
        return this.scopeRepository.findAll().stream().map(Scope::getName).collect(Collectors.toList());
    }

    @GetMapping(value={"/client/scopes/{id}"})
    public Scope get(@PathVariable(value="id") String id) {
        return (Scope)this.scopeRepository.findOne((Serializable)((Object)id));
    }

    @PutMapping(value={"/client/scopes"})
    public Scope update(@RequestBody Scope scope) throws JsonProcessingException {
        Scope previous = (Scope)this.scopeRepository.findOne((Serializable)((Object)scope.getId()));
        if (!previous.getName().equals(scope.getName())) {
            this.checkScopeInUse(previous);
        }
        LOG.info("Updating scope {}", (Object)scope);
        return this.saveScope(scope);
    }

    private Scope saveScope(@RequestBody Scope scope) {
        try {
            return (Scope)this.scopeRepository.save((Object)scope);
        }
        catch (com.mongodb.DuplicateKeyException | DuplicateKeyException e) {
            throw new ScopeDuplicateNameException(e.getMessage());
        }
    }

    @PostMapping(value={"/client/scopes"})
    public Scope save(@RequestBody Scope scope) {
        LOG.info("Saving scope {}", (Object)scope);
        return this.saveScope(scope);
    }

    private void checkScopeInUse(Scope scope) throws JsonProcessingException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"data.metaDataFields.scopes").is((Object)scope.getName()));
        List metaData = this.mongoTemplate.find(query, MetaData.class, EntityType.RP.getType());
        if (!metaData.isEmpty()) {
            ArrayList message = new ArrayList();
            metaData.forEach(md -> {
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("id", md.getId());
                entry.put("entityid", (String)md.getData().get("entityid"));
                message.add(entry);
            });
            throw new ScopeInUseException(this.objectMapper.writeValueAsString(message));
        }
    }
}

