/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import manage.exception.DuplicateEntityIdException;
import manage.exception.ScopeInUseException;
import org.everit.json.schema.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
public class ErrorController
implements org.springframework.boot.autoconfigure.web.ErrorController {
    private final ErrorAttributes errorAttributes;

    @Autowired
    public ErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus statusCode;
        HttpStatus status;
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request);
        Map result = this.errorAttributes.getErrorAttributes((RequestAttributes)requestAttributes, false);
        Throwable error = this.errorAttributes.getError((RequestAttributes)requestAttributes);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean isInternalCall = StringUtils.hasText((String)request.getHeader("Authorization"));
        HttpStatus httpStatus = status = isInternalCall ? HttpStatus.BAD_REQUEST : HttpStatus.OK;
        if (error instanceof ValidationException) {
            ValidationException validationException = (ValidationException)((Object)ValidationException.class.cast(error));
            result.put("validations", String.join((CharSequence)", ", validationException.getAllMessages()));
            result.put("status", status.value());
            result.put("error", ValidationException.class.getName());
            return new ResponseEntity((Object)result, status);
        }
        if (error instanceof OptimisticLockingFailureException) {
            result.put("validations", "Optimistic locking failure e.g. mid-air collision. Refresh your screen to get the latest version.");
            result.put("status", status.value());
            result.put("error", OptimisticLockingFailureException.class.getName());
            return new ResponseEntity((Object)result, status);
        }
        if (error instanceof DuplicateEntityIdException) {
            result.put("status", status.value());
            result.put("error", DuplicateEntityIdException.class.getName());
            result.put("message", error.getMessage());
            return new ResponseEntity((Object)result, status);
        }
        if (error instanceof HttpClientErrorException) {
            HttpClientErrorException httpClientErrorException = (HttpClientErrorException)error;
            result.put("status", httpClientErrorException.getStatusCode().toString());
            result.put("error", HttpClientErrorException.class.getName());
            result.put("message", httpClientErrorException.getResponseBodyAsString());
            return new ResponseEntity((Object)result, status);
        }
        if (error instanceof ScopeInUseException) {
            result.put("message", error.getMessage());
        }
        HttpStatus httpStatus2 = statusCode = result.containsKey("status") ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR;
        if (error != null) {
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            statusCode = annotation != null ? annotation.value() : statusCode;
        }
        return new ResponseEntity((Object)result, statusCode);
    }
}

