/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import manage.api.APIUser;
import manage.api.Scope;
import manage.conf.MetaDataAutoConfiguration;
import manage.control.DatabaseController;
import manage.exception.DuplicateEntityIdException;
import manage.exception.EndpointNotAllowed;
import manage.exception.ResourceNotFoundException;
import manage.format.Exporter;
import manage.format.Importer;
import manage.format.SaveURLResource;
import manage.hook.MetaDataHook;
import manage.hook.OpenIdConnectHook;
import manage.model.DashboardConnectOption;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.MetaData;
import manage.model.MetaDataKeyDelete;
import manage.model.MetaDataUpdate;
import manage.model.RevisionRestore;
import manage.model.ServiceProvider;
import manage.model.StatsEntry;
import manage.model.XML;
import manage.oidc.Client;
import manage.oidc.OpenIdConnect;
import manage.repository.MetaDataRepository;
import manage.shibboleth.FederatedUser;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaDataController {
    static final String REQUESTED_ATTRIBUTES = "REQUESTED_ATTRIBUTES";
    static final String ALL_ATTRIBUTES = "ALL_ATTRIBUTES";
    static final String LOGICAL_OPERATOR_IS_AND = "LOGICAL_OPERATOR_IS_AND";
    private static final String DASHBOARD_CONNECT_OPTION = "coin:dashboard_connect_option";
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataController.class);
    private static final List<String> entityTypesSuggestions = Arrays.asList(EntityType.RP.getType(), EntityType.SP.getType());
    private MetaDataRepository metaDataRepository;
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private MetaDataHook metaDataHook;
    private Importer importer;
    private Exporter exporter;
    private OpenIdConnect openIdConnect;
    private String baseDomain;
    private Environment environment;
    @Autowired
    DatabaseController databaseController;

    @Autowired
    public MetaDataController(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, ResourceLoader resourceLoader, MetaDataHook metaDataHook, OpenIdConnect openIdConnect, Environment environment, @Value(value="${metadata_export_path}") String metadataExportPath, @Value(value="${base_domain}") String baseDomain, @Value(value="${product.supported_languages}") String supportedLanguages) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataHook = metaDataHook;
        List languages = Stream.of(supportedLanguages.split(",")).map(String::trim).collect(Collectors.toList());
        this.importer = new Importer(metaDataAutoConfiguration, languages);
        this.exporter = new Exporter(Clock.systemDefaultZone(), resourceLoader, metadataExportPath, languages);
        this.openIdConnect = openIdConnect;
        this.baseDomain = baseDomain;
        this.environment = environment;
    }

    @GetMapping(value={"/client/template/{type}"})
    public MetaData template(@PathVariable(value="type") String type) {
        Map data = this.metaDataAutoConfiguration.metaDataTemplate(type);
        return new MetaData(type, data);
    }

    @GetMapping(value={"/client/metadata/{type}/{id}", "/internal/metadata/{type}/{id}"})
    public MetaData get(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        MetaData metaData = this.metaDataRepository.findById(id, type);
        this.checkNull(type, id, metaData);
        return this.metaDataHook.postGet(metaData);
    }

    private void checkNull(String type, String id, MetaData metaData) {
        if (metaData == null) {
            throw new ResourceNotFoundException(String.format("MetaData type %s with id %s does not exist", type, id));
        }
    }

    @GetMapping(value={"/client/metadata/configuration"})
    public List<Map<String, Object>> configuration() {
        return this.metaDataAutoConfiguration.schemaRepresentations();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/metadata"})
    public MetaData post(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        return this.doPost(metaData, federatedUser.getUid(), false);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/includeInPush/{type}/{id}"})
    public MetaData includeInPush(@PathVariable(value="type") String type, @PathVariable(value="id") String id, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData metaData = this.get(type, id);
        Map metaDataFields = metaData.metaDataFields();
        metaDataFields.remove("coin:exclude_from_push");
        metaData.getData().remove("oidcClient");
        return this.doPut(metaData, federatedUser.getUid(), false);
    }

    @GetMapping(value={"/client/metadata/stats"})
    public List<StatsEntry> stats() {
        return this.metaDataRepository.stats();
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/metadata"})
    public MetaData postInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.doPost(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/new-sp"})
    public MetaData newSP(@Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        Map innerJson = this.importer.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.addDefaultSpData(innerJson);
        MetaData metaData = new MetaData(EntityType.SP.getType(), innerJson);
        return this.doPost(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/delete/feed"})
    public Map<String, Long> deleteFeed() {
        long deleted = this.metaDataRepository.deleteAllImportedServiceProviders();
        return Collections.singletonMap("deleted", deleted);
    }

    @GetMapping(value={"/client/count/feed"})
    public Map<String, Long> countFeed() {
        long count = this.metaDataRepository.countAllImportedServiceProviders();
        return Collections.singletonMap("count", count);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/feed"})
    public Map<String, List> importFeed(@Validated @RequestBody Import importRequest) {
        try {
            Map<String, ServiceProvider> serviceProviderMap = this.metaDataRepository.allServiceProviderEntityIds().stream().map(ServiceProvider::new).collect(Collectors.toMap(sp -> sp.getEntityId(), sp -> sp));
            String feedUrl = importRequest.getUrl();
            SaveURLResource resource = new SaveURLResource(new URL(feedUrl), this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})));
            List allImports = this.importer.importFeed((Resource)resource);
            List<Map> imports = allImports.stream().filter(m -> !m.isEmpty()).collect(Collectors.toList());
            HashMap<String, List> results = new HashMap<String, List>();
            EntityType entityType = EntityType.SP;
            imports.forEach(sp -> {
                block11: {
                    String entityId = (String)sp.get("entityid");
                    sp.put("metadataurl", feedUrl);
                    Map metaDataFields = (Map)Map.class.cast(sp.get("metaDataFields"));
                    metaDataFields.put("coin:imported_from_edugain", true);
                    metaDataFields.put("coin:interfed_source", "eduGAIN");
                    ServiceProvider existingServiceProvider = (ServiceProvider)serviceProviderMap.get(entityId);
                    if (existingServiceProvider != null) {
                        if (existingServiceProvider.isPublishedInEduGain()) {
                            List publishedInEdugain = results.computeIfAbsent("published_in_edugain", s -> new ArrayList());
                            publishedInEdugain.add(existingServiceProvider);
                        } else if (existingServiceProvider.isImportedFromEduGain()) {
                            try {
                                MetaDataUpdate metaDataUpdate = this.importToMetaDataUpdate(existingServiceProvider.getId(), entityType, sp, feedUrl);
                                Optional metaData = this.doMergeUpdate(metaDataUpdate, "edugain-import", "edugain-import", false);
                                if (metaData.isPresent()) {
                                    List merged = results.computeIfAbsent("merged", s -> new ArrayList());
                                    merged.add(existingServiceProvider);
                                    break block11;
                                }
                                List noChanges = results.computeIfAbsent("no_changes", s -> new ArrayList());
                                noChanges.add(existingServiceProvider);
                            }
                            catch (JsonProcessingException | ValidationException e) {
                                this.addNoValid(results, entityId, (Exception)e);
                            }
                        } else {
                            List notImported = results.computeIfAbsent("not_imported", s -> new ArrayList());
                            notImported.add(existingServiceProvider);
                        }
                    } else {
                        try {
                            MetaData metaData = this.importToMetaData(sp, entityType);
                            MetaData persistedMetaData = this.doPost(metaData, "edugain-import", false);
                            List imported = results.computeIfAbsent("imported", s -> new ArrayList());
                            imported.add(new ServiceProvider(persistedMetaData.getId(), entityId, false, false, null));
                        }
                        catch (JsonProcessingException | ValidationException e) {
                            this.addNoValid(results, entityId, (Exception)e);
                        }
                    }
                }
            });
            List<ServiceProvider> notInFeedAnymore = serviceProviderMap.values().stream().filter(sp -> sp.isImportedFromEduGain() && !imports.stream().anyMatch(map -> sp.getEntityId().equals(map.get("entityid")))).collect(Collectors.toList());
            notInFeedAnymore.forEach(sp -> this.doRemove(entityType.getType(), sp.getId(), "edugain-import", "Removed from eduGain feed"));
            List deleted = results.computeIfAbsent("deleted", s -> new ArrayList());
            deleted.addAll(notInFeedAnymore.stream().map(sp -> sp.getEntityId()).collect(Collectors.toList()));
            results.put("total", Collections.singletonList(imports.size()));
            return results;
        }
        catch (IOException | XMLStreamException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    private void addNoValid(Map<String, List> results, String entityId, Exception e) {
        String msg = e instanceof ValidationException ? String.join((CharSequence)", ", ((ValidationException)((Object)ValidationException.class.cast(e))).getAllMessages()) : e.getClass().getName();
        List notValid = results.computeIfAbsent("not_valid", s -> new ArrayList());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("validationException", msg);
        result.put("entityId", entityId);
        notValid.add(result);
    }

    private MetaData importToMetaData(Map<String, Object> m, EntityType entityType) {
        MetaData template = this.template(entityType.getType());
        template.getData().putAll(m);
        template.getData().put("state", "prodaccepted");
        return template;
    }

    private MetaDataUpdate importToMetaDataUpdate(String id, EntityType entityType, Map<String, Object> m, String feedUrl) {
        Map metaDataFields = (Map)Map.class.cast(m.get("metaDataFields"));
        HashMap<String, String> pathUpdates = new HashMap<String, String>();
        metaDataFields.forEach((k, v) -> pathUpdates.put("metaDataFields.".concat((String)k), (String)v));
        pathUpdates.put("metadataurl", feedUrl);
        MetaDataUpdate metaDataUpdate = new MetaDataUpdate(id, entityType.getType(), pathUpdates, Collections.emptyMap());
        return metaDataUpdate;
    }

    private void addDefaultSpData(Map<String, Object> innerJson) {
        innerJson.put("allowedall", true);
        innerJson.put("state", "testaccepted");
        innerJson.put("allowedEntities", new ArrayList());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/update-sp/{id}/{version}"})
    public MetaData updateSP(@PathVariable(value="id") String id, @PathVariable(value="version") Long version, @Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        MetaData metaData = this.get(EntityType.SP.getType(), id);
        Map innerJson = this.importer.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.addDefaultSpData(innerJson);
        metaData.setData(innerJson);
        metaData.setVersion(version);
        return this.doPut(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @GetMapping(value={"/internal/sp-metadata/{id}"})
    public String exportXml(@PathVariable(value="id") String id) throws IOException {
        MetaData metaData = this.get(EntityType.SP.getType(), id);
        return this.exporter.exportToXml(metaData);
    }

    @GetMapping(value={"/internal/xml/metadata/{type}/{id}"}, produces={"text/xml"})
    public String exportMetadataXml(@PathVariable(value="type") String type, @PathVariable(value="id") String id) throws IOException {
        MetaData metaData = this.get(EntityType.fromType((String)type).getType(), id);
        return this.exporter.exportToXml(metaData);
    }

    private MetaData doPost(@Validated @RequestBody MetaData metaData, String uid, boolean excludeFromPushRequired) throws JsonProcessingException {
        String entityid = (String)metaData.getData().get("entityid");
        List result = this.uniqueEntityId(metaData.getType(), Collections.singletonMap("entityid", entityid));
        if (!CollectionUtils.isEmpty((Collection)result)) {
            throw new DuplicateEntityIdException(entityid);
        }
        this.sanitizeExcludeFromPush(metaData, excludeFromPushRequired);
        metaData = this.metaDataHook.prePost(metaData);
        metaData = this.validate(metaData);
        Long eid = this.metaDataRepository.incrementEid();
        metaData.initial(UUID.randomUUID().toString(), uid, eid);
        LOG.info("Saving new metaData {} by {}", (Object)metaData.getId(), (Object)uid);
        this.metaDataRepository.save(metaData);
        return this.get(metaData.getType(), metaData.getId());
    }

    private void sanitizeExcludeFromPush(@RequestBody @Validated MetaData metaData, boolean excludeFromPushRequired) {
        Map metaDataFields = metaData.metaDataFields();
        Object val = metaDataFields.get("coin:exclude_from_push");
        if (excludeFromPushRequired && ("0".equals(val) || Boolean.FALSE == val)) {
            metaDataFields.put("coin:exclude_from_push", true);
        }
    }

    @PreAuthorize(value="hasRole('READ')")
    @PostMapping(value={"/internal/validate/metadata"})
    public ResponseEntity<Object> validateMetaData(@Validated @RequestBody MetaData metaData) throws JsonProcessingException {
        this.validate(metaData);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata/{type}/{id}"})
    public boolean remove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestBody(required=false) Map body, FederatedUser user) {
        String defaultValue = "Deleted by " + user.getUid();
        String revisionNote = body != null ? body.getOrDefault("revisionNote", defaultValue) : defaultValue;
        return this.doRemove(type, id, user.getUid(), revisionNote);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @DeleteMapping(value={"/internal/metadata/{type}/{id}"})
    public boolean removeInternal(@PathVariable(value="type") String type, @PathVariable(value="id") String id, APIUser apiUser) {
        return this.doRemove(type, id, apiUser.getName(), "Deleted by APIUser " + apiUser.getName());
    }

    private boolean doRemove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, String uid, String revisionNote) {
        MetaData current = this.metaDataRepository.findById(id, type);
        this.checkNull(type, id, current);
        current = this.metaDataHook.preDelete(current);
        this.metaDataRepository.remove(current);
        LOG.info("Deleted metaData {} by {}", (Object)current.getId(), (Object)uid);
        current.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(current);
        current.terminate(UUID.randomUUID().toString(), revisionNote);
        this.metaDataRepository.save(current);
        return true;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata"})
    @Transactional
    public MetaData put(@Validated @RequestBody MetaData metaData, Authentication authentication) throws JsonProcessingException {
        return this.doPut(metaData, authentication.getName(), false);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"/internal/metadata"})
    @Transactional
    public MetaData putInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.doPut(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    private MetaData doPut(@Validated @RequestBody MetaData metaData, String updatedBy, boolean excludeFromPushRequired) throws JsonProcessingException {
        String entityid = (String)metaData.getData().get("entityid");
        List result = this.uniqueEntityId(metaData.getType(), Collections.singletonMap("entityid", entityid));
        if (result.size() > 1) {
            throw new DuplicateEntityIdException(entityid);
        }
        this.sanitizeExcludeFromPush(metaData, excludeFromPushRequired);
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        this.checkNull(metaData.getType(), id, previous);
        metaData = this.metaDataHook.prePut(previous, metaData);
        metaData = this.validate(metaData);
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest(updatedBy, (String)metaData.getData().get("revisionnote"));
        this.metaDataRepository.update(metaData);
        LOG.info("Updated metaData {} by {}", (Object)metaData.getId(), (Object)updatedBy);
        return this.get(metaData.getType(), metaData.getId());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"/internal/delete-metadata-key"})
    @Transactional
    public List<String> deleteMetaDataKey(@Validated @RequestBody MetaDataKeyDelete metaDataKeyDelete, APIUser apiUser) throws IOException {
        String keyToDelete = metaDataKeyDelete.getMetaDataKey();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)("data.metaDataFields." + keyToDelete)).exists(true));
        List metaDataList = this.metaDataRepository.getMongoTemplate().find(query, MetaData.class, metaDataKeyDelete.getType());
        for (MetaData metaData2 : metaDataList) {
            metaData2.metaDataFields().remove(keyToDelete);
            metaData2 = this.validate(metaData2);
            MetaData previous = this.metaDataRepository.findById(metaData2.getId(), metaData2.getType());
            previous.revision(UUID.randomUUID().toString());
            this.metaDataRepository.save(previous);
            metaData2.promoteToLatest(apiUser.getName(), String.format("API call for deleting %s by %s", keyToDelete, apiUser.getName()));
            this.metaDataRepository.update(metaData2);
        }
        return metaDataList.stream().map(metaData -> (String)metaData.getData().get("entityid")).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"internal/merge"})
    @Transactional
    public MetaData update(@Validated @RequestBody MetaDataUpdate metaDataUpdate, APIUser apiUser) throws JsonProcessingException {
        String name = apiUser.getName();
        return (MetaData)this.doMergeUpdate(metaDataUpdate, name, "Internal API merge", true).get();
    }

    private Optional<MetaData> doMergeUpdate(MetaDataUpdate metaDataUpdate, String name, String revisionNote, boolean forceNewRevision) throws JsonProcessingException {
        boolean somethingChanged;
        String id = metaDataUpdate.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        this.checkNull(metaDataUpdate.getType(), id, previous);
        previous.revision(UUID.randomUUID().toString());
        MetaData metaData = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        metaData.promoteToLatest(name, revisionNote);
        metaData.merge(metaDataUpdate);
        if (!CollectionUtils.isEmpty((Map)metaDataUpdate.getExternalReferenceData())) {
            metaData.getData().putAll(metaDataUpdate.getExternalReferenceData());
        }
        metaData = this.metaDataHook.prePut(previous, metaData);
        boolean bl = somethingChanged = !(metaData = this.validate(metaData)).metaDataFields().equals(previous.metaDataFields());
        if (somethingChanged || forceNewRevision) {
            this.metaDataRepository.save(previous);
            this.metaDataRepository.update(metaData);
            LOG.info("Merging new metaData {} by {}", (Object)metaData.getId(), (Object)name);
            return Optional.of(this.get(metaData.getType(), metaData.getId()));
        }
        return Optional.empty();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreDeleted"})
    @Transactional
    public MetaData restoreDeleted(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        if (parent != null) {
            throw new IllegalArgumentException("Parent is not null");
        }
        String newId = revision.getRevision().getParentId();
        revision.getRevision().deTerminate(newId);
        this.metaDataRepository.update(revision);
        revision.restoreToLatest(newId, Long.valueOf(0L), federatedUser.getUid(), revision.getRevision().getNumber(), revisionRestore.getParentType());
        revision = this.validate(revision);
        this.metaDataRepository.save(revision);
        LOG.info("Restored deleted revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreRevision"})
    @Transactional
    public MetaData restoreRevision(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        revision.restoreToLatest(parent.getId(), parent.getVersion(), federatedUser.getUid(), parent.getRevision().getNumber(), revisionRestore.getParentType());
        revision = this.validate(revision);
        this.metaDataRepository.update(revision);
        parent.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(parent);
        LOG.info("Restored revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    @GetMapping(value={"/client/revisions/{type}/{parentId}"})
    public List<MetaData> revisions(@PathVariable(value="type") String type, @PathVariable(value="parentId") String parentId) {
        return this.metaDataRepository.revisions(type.concat("_revision"), parentId);
    }

    @GetMapping(value={"/client/autocomplete/{type}"})
    public Map<String, List<Map>> autoCompleteEntities(@PathVariable(value="type") String type, @RequestParam(value="query") String query) {
        List suggestions = this.metaDataRepository.autoComplete(type, query);
        HashMap<String, List<Map>> results = new HashMap<String, List<Map>>();
        results.put("suggestions", suggestions);
        if (suggestions.isEmpty() && entityTypesSuggestions.contains(type)) {
            ArrayList alternatives = new ArrayList();
            entityTypesSuggestions.stream().filter(s -> !s.equals(type)).forEach(s -> alternatives.addAll(this.metaDataRepository.autoComplete(s, query)));
            results.put("alternatives", alternatives);
        }
        return results;
    }

    @GetMapping(value={"/client/whiteListing/{type}"})
    public List<Map> whiteListing(@PathVariable(value="type") String type, @RequestParam(value="state") String state) {
        return this.metaDataRepository.whiteListing(type, state);
    }

    @PostMapping(value={"/client/uniqueEntityId/{type}", "/internal/uniqueEntityId/{type}"})
    public List<Map> uniqueEntityId(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties) {
        List results;
        EntityType entityType = EntityType.fromType((String)type);
        if (entityType.equals((Object)EntityType.IDP) || entityType.equals((Object)EntityType.STT)) {
            results = this.metaDataRepository.search(type, properties, new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(true));
        } else {
            results = this.metaDataRepository.search(entityType.getType(), properties, new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(true));
            results.addAll(this.metaDataRepository.search(entityType.equals((Object)EntityType.RP) ? EntityType.SP.getType() : EntityType.RP.getType(), properties, new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(true)));
        }
        return results;
    }

    @PostMapping(value={"/client/search/{type}", "/internal/search/{type}"})
    public List<Map> searchEntities(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties, @RequestParam(required=false, defaultValue="false") boolean nested) {
        List requestedAttributes = properties.getOrDefault(REQUESTED_ATTRIBUTES, new ArrayList());
        Boolean allAttributes = (Boolean)properties.getOrDefault(ALL_ATTRIBUTES, false);
        Boolean logicalOperatorIsAnd = (Boolean)properties.getOrDefault(LOGICAL_OPERATOR_IS_AND, true);
        properties.remove(REQUESTED_ATTRIBUTES);
        properties.remove(ALL_ATTRIBUTES);
        properties.remove(LOGICAL_OPERATOR_IS_AND);
        List search = this.metaDataRepository.search(type, properties, requestedAttributes, allAttributes, logicalOperatorIsAnd);
        return nested ? search.stream().map(m -> this.exporter.nestMetaData(m, type)).collect(Collectors.toList()) : search;
    }

    @GetMapping(value={"/client/rawSearch/{type}", "/internal/rawSearch/{type}"})
    public List<MetaData> rawSearch(@PathVariable(value="type") String type, @RequestParam(value="query") String query) throws UnsupportedEncodingException {
        if (query.startsWith("%")) {
            query = URLDecoder.decode(query, "UTF-8");
        }
        return this.metaDataRepository.findRaw(type, query);
    }

    private MetaData validate(MetaData metaData) throws JsonProcessingException {
        metaData = this.metaDataHook.preValidate(metaData);
        this.metaDataAutoConfiguration.validate(metaData.getData(), metaData.getType());
        return metaData;
    }

    @Secured(value={"WRITE"})
    @PutMapping(value={"/internal/connectWithoutInteraction"})
    public HttpEntity<HttpStatus> connectWithoutInteraction(@RequestBody Map<String, String> connectionData, APIUser apiUser) throws JsonProcessingException {
        boolean shareInstitutionId;
        LOG.debug("connectWithoutInteraction, connectionData: " + connectionData);
        String idpEntityId = connectionData.get("idpId");
        MetaData idp = this.findByEntityId(idpEntityId, EntityType.IDP.getType());
        String spEntityId = connectionData.get("spId");
        String spType = connectionData.get("spType");
        MetaData sp = this.findByEntityId(spEntityId, spType);
        String dashboardConnectType = (String)sp.metaDataFields().get(DASHBOARD_CONNECT_OPTION);
        boolean connectWithoutInteraction = StringUtils.hasText((String)dashboardConnectType) && DashboardConnectOption.fromType((String)dashboardConnectType).connectWithoutInteraction();
        Object idpInstitutionId = idp.metaDataFields().get("coin:institution_id");
        Object spInstitutionId = sp.metaDataFields().get("coin:institution_id");
        boolean bl = shareInstitutionId = idpInstitutionId != null && idpInstitutionId.equals(spInstitutionId) && !"connect_with_interaction".equals("dashboardConnectType");
        if (!connectWithoutInteraction && !shareInstitutionId) {
            throw new EndpointNotAllowed(String.format("SP %s does not allow an automatic connection with IdP %s. SP dashboardConnectType: %s, idpInstitutionId: %s, spInstitutionId %s", spEntityId, idpEntityId, dashboardConnectType, idpInstitutionId, spInstitutionId));
        }
        this.addAllowedEntity(sp, idpEntityId, connectionData, apiUser);
        this.addAllowedEntity(idp, spEntityId, connectionData, apiUser);
        this.databaseController.doPush();
        return new HttpEntity((Object)HttpStatus.OK);
    }

    @Secured(value={"WRITE"})
    @PutMapping(value={"internal/oidc/merge"})
    public List<MetaData> oidcMerge(@RequestBody List<String> spEntityIds, APIUser apiUser) throws JsonProcessingException {
        LOG.debug("Starting OIDC Merge by {} for spEntityIds {}", (Object)apiUser.getName(), spEntityIds);
        ArrayList<MetaData> metaDataResult = new ArrayList<MetaData>();
        for (String spEntityId : spEntityIds) {
            MetaData sp = this.findByEntityId(spEntityId, EntityType.SP.getType());
            Map data = sp.getData();
            String entityId = (String)data.get("entityid");
            String openIdClientId = OpenIdConnectHook.translateServiceProviderEntityId((String)entityId);
            Optional clientOptional = this.openIdConnect.getClient(openIdClientId);
            if (!clientOptional.isPresent()) continue;
            Client client = (Client)clientOptional.get();
            String newEntityId = entityId.replaceFirst("^(http[s]?://)", "");
            if (newEntityId.equals(entityId)) {
                throw new DuplicateEntityIdException(String.format("Could not merge due to entityId conflict. Current: %s, new: %s", entityId, newEntityId));
            }
            data.put("entityid", newEntityId);
            Map metaDataFields = (Map)data.get("metaDataFields");
            String secret = UUID.randomUUID().toString();
            metaDataFields.put("secret", secret);
            Map schema = this.metaDataAutoConfiguration.schemaRepresentation(EntityType.RP);
            Map topLevelProperties = (Map)Map.class.cast(schema.get("properties"));
            Map metaDataFieldProperties = (Map)Map.class.cast(topLevelProperties.get("metaDataFields"));
            Map properties = (Map)metaDataFieldProperties.get("properties");
            Map patternProperties = (Map)metaDataFieldProperties.get("patternProperties");
            List validGrants = (List)((Map)((Map)properties.get("grants")).get("items")).get("enum");
            metaDataFields.put("grants", client.getGrantTypes().stream().filter(validGrants::contains).collect(Collectors.toList()));
            List validScopes = this.metaDataRepository.getMongoTemplate().findAll(manage.model.Scope.class).stream().map(manage.model.Scope::getName).collect(Collectors.toList());
            Set clientScopes = client.getScope();
            List scopes = clientScopes.stream().filter(validScopes::contains).collect(Collectors.toList());
            scopes = CollectionUtils.isEmpty(scopes) ? Collections.singletonList("openid") : scopes;
            metaDataFields.put("scopes", scopes);
            metaDataFields.put("accessTokenValidity", client.getAccessTokenValiditySeconds());
            metaDataFields.put("refreshTokenValidity", client.getRefreshTokenValiditySeconds());
            ArrayList<String> redirectUris = CollectionUtils.isEmpty((Collection)client.getRedirectUris()) ? new ArrayList<String>() : new ArrayList(client.getRedirectUris());
            redirectUris.remove("https://authz-playground." + this.baseDomain + "/redirect");
            redirectUris.add("https://oidc-playground." + this.baseDomain + "/redirect");
            metaDataFields.put("redirectUrls", redirectUris);
            metaDataFields.entrySet().removeIf(entry -> !properties.containsKey(entry.getKey()) && !patternProperties.keySet().stream().anyMatch(prop -> Pattern.compile(prop).matcher((CharSequence)entry.getKey()).matches()));
            data.entrySet().removeIf(entry -> !topLevelProperties.containsKey(entry.getKey()));
            data.put("type", "oidc10-rp");
            data.put("revisionnote", String.format("Connection created by OIDC Merge for %s on request of %s", spEntityId, apiUser.getName()));
            MetaData oidcRP = new MetaData(EntityType.RP.getType(), data);
            oidcRP = this.doPost(oidcRP, apiUser.getName(), false);
            oidcRP.metaDataFields().put("secret", secret);
            metaDataResult.add(oidcRP);
            List identityProviders = this.metaDataRepository.findRaw(EntityType.IDP.getType(), String.format("{\"data.%s.name\" : \"%s\"}", "allowedEntities", spEntityId));
            identityProviders.forEach(idp -> {
                MetaData previous = this.metaDataRepository.findById(idp.getId(), idp.getType());
                previous.revision(UUID.randomUUID().toString());
                this.metaDataRepository.save(previous);
                List allowedEntities = (List)idp.getData().get("allowedEntities");
                allowedEntities.add(Collections.singletonMap("name", newEntityId));
                idp.promoteToLatest(apiUser.getName(), String.format("Added OIDC RP to allowedEntities during API internal/oidc/merge for %s by %s", spEntityId, apiUser.getName()));
                this.metaDataRepository.update(idp);
            });
        }
        if (metaDataResult.size() > 0) {
            this.databaseController.doPush();
        }
        return metaDataResult;
    }

    private void addAllowedEntity(MetaData metaData, String entityId, Map<String, String> connectionData, APIUser apiUser) throws JsonProcessingException {
        Map data = metaData.getData();
        List allowedEntities = data.getOrDefault("allowedEntities", new ArrayList());
        boolean allowedAll = data.getOrDefault("allowedall", true);
        if (!allowedAll && allowedEntities.stream().noneMatch(allowedEntity -> ((String)allowedEntity.get("name")).equals(entityId))) {
            allowedEntities.add(Collections.singletonMap("name", entityId));
            data.put("allowedEntities", allowedEntities);
            data.put("revisionnote", String.format("Connection created by Dashboard on request of %s - %s", connectionData.get("user"), connectionData.get("userUrn")));
            this.doPut(metaData, apiUser.getName(), false);
        }
    }

    private MetaData findByEntityId(String entityId, String type) {
        List searchResults = this.uniqueEntityId(type, Collections.singletonMap("entityid", entityId));
        if (CollectionUtils.isEmpty((Collection)searchResults)) {
            throw new ResourceNotFoundException(String.format("Type %s with entityId %s does not exists", type, entityId));
        }
        return this.metaDataRepository.findById((String)((Map)searchResults.get(0)).get("_id"), type);
    }
}

