/*
 * Decompiled with CFR 0.152.
 */
package manage.api;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import manage.api.APIUser;
import manage.api.APIUserConfiguration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class APIAuthenticationManager
implements AuthenticationManager {
    private APIUserConfiguration apiUserConfiguration;

    public APIAuthenticationManager(APIUserConfiguration apiUserConfiguration) {
        this.apiUserConfiguration = apiUserConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String name = (String)String.class.cast(authentication.getPrincipal());
        Optional<APIUser> apiUserOptional = this.apiUserConfiguration.getApiUsers().stream().filter(apiUser -> apiUser.getName().equals(name)).findFirst();
        APIUser apiUser2 = apiUserOptional.orElseThrow(() -> new UsernameNotFoundException("Unknown user: " + name));
        if (!apiUser2.getPassword().equals(authentication.getCredentials())) {
            throw new BadCredentialsException("Bad credentials");
        }
        return new UsernamePasswordAuthenticationToken((Object)apiUser2, authentication.getCredentials(), (Collection)apiUser2.getScopes().stream().map(scope -> new SimpleGrantedAuthority("ROLE_".concat(scope.name()))).collect(Collectors.toList()));
    }
}

