/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class OidcValidationHook
extends MetaDataHookAdapter {
    private MetaDataAutoConfiguration metaDataAutoConfiguration;

    public OidcValidationHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.RP.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        this.validate(newMetaData);
        return super.prePut(previous, newMetaData);
    }

    public MetaData prePost(MetaData metaData) {
        this.validate(metaData);
        return super.prePost(metaData);
    }

    private void validate(MetaData newMetaData) {
        Map metaDataFields = newMetaData.metaDataFields();
        List redirectUrls = metaDataFields.getOrDefault("redirectUrls", new ArrayList());
        List grants = metaDataFields.getOrDefault("grants", new ArrayList());
        if (grants.stream().anyMatch(grant -> Arrays.asList("authorization_code", "implicit").contains(grant)) && redirectUrls.isEmpty()) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.RP.getType());
            throw new ValidationException(schema, "Redirect URI is required with selected grant types", "redirectUris");
        }
        if (grants.size() == 1 && ((String)grants.get(0)).equals("client_credentials") && redirectUrls.size() > 0) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.RP.getType());
            throw new ValidationException(schema, "Redirect URI is not allowed with selected grant type", "redirectUris");
        }
        if (grants.size() == 1 && ((String)grants.get(0)).equals("refresh_token")) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.RP.getType());
            throw new ValidationException(schema, "Refresh token grant must be combined with another grant type", "grants");
        }
    }
}

