/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import manage.conf.MetaDataAutoConfiguration;
import manage.format.Importer;
import manage.format.SaveURLResource;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.XML;
import org.apache.commons.io.IOUtils;
import org.everit.json.schema.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ImportController {
    private Importer importer;
    private ObjectMapper objectMapper;
    private Environment environment;

    @Autowired
    public ImportController(MetaDataAutoConfiguration metaDataAutoConfiguration, ObjectMapper objectMapper, Environment environment, @Value(value="${product.supported_languages}") String supportedLanguages) {
        List languages = Stream.of(supportedLanguages.split(",")).map(String::trim).collect(Collectors.toList());
        this.importer = new Importer(metaDataAutoConfiguration, languages);
        this.objectMapper = objectMapper;
        this.environment = environment;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/endpoint/xml/{type}"})
    public Map<String, Object> importXMLUrl(@PathVariable(value="type") String type, @Validated @RequestBody Import importRequest) {
        try {
            SaveURLResource resource = new SaveURLResource(new URL(importRequest.getUrl()), this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})));
            Map result = this.importer.importXML((Resource)resource, EntityType.fromType((String)type), Optional.ofNullable(importRequest.getEntityId()));
            if (result.isEmpty()) {
                return Collections.singletonMap("errors", Collections.singletonList("URL did not contain valid SAML metadata"));
            }
            result.put("metadataurl", importRequest.getUrl());
            return result;
        }
        catch (IOException | XMLStreamException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/xml/{type}"})
    public Map<String, Object> importXml(@PathVariable(value="type") String type, @Validated @RequestBody XML container) {
        try {
            return this.importer.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.fromType((String)type), Optional.ofNullable(container.getEntityId()));
        }
        catch (IOException | XMLStreamException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/json/{type}"})
    public Map<String, Object> importJson(@PathVariable(value="type") String type, @RequestBody Map<String, Object> json) throws IOException {
        EntityType entityType = this.getType(type, json);
        try {
            return this.importer.importJSON(entityType, json);
        }
        catch (ValidationException e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("errors", e.getAllMessages());
            result.put("type", entityType.getType());
            return result;
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/endpoint/json/{type}"})
    public Map<String, Object> importJsonUrl(@PathVariable(value="type") String type, @Validated @RequestBody Import importRequest) {
        try {
            SaveURLResource resource = new SaveURLResource(new URL(importRequest.getUrl()), this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})));
            String json = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
            Map map = (Map)this.objectMapper.readValue(json, Map.class);
            return this.importJson(type, map);
        }
        catch (IOException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    private EntityType getType(String type, Map<String, Object> json) {
        EntityType entityType;
        Object object = EntityType.IDP.getType().equals(type) ? EntityType.IDP : (entityType = EntityType.SP.getType().equals(type) ? EntityType.SP : null);
        if (entityType == null) {
            Object jsonType = json.get("type");
            if (jsonType == null) {
                throw new IllegalArgumentException("Expected a 'type' attribute in the JSON with value 'saml20-idp' or 'saml20-sp'");
            }
            return EntityType.fromType((String)((String)String.class.cast(jsonType)));
        }
        return entityType;
    }
}

