/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Arrays;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.CompositeMetaDataHook;
import manage.hook.EmptyRevisionHook;
import manage.hook.EntityIdConstraintsHook;
import manage.hook.EntityIdReconcilerHook;
import manage.hook.OidcValidationHook;
import manage.hook.SSIDValidationHook;
import manage.hook.SecretHook;
import manage.hook.TypeSafetyHook;
import manage.repository.MetaDataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetaDataHookConfiguration {
    @Bean
    @Autowired
    CompositeMetaDataHook hooks(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, @Value(value="${oidc.acsLocation}") String acsLocation) {
        EmptyRevisionHook emptyRevisionHook = new EmptyRevisionHook(metaDataAutoConfiguration);
        EntityIdReconcilerHook entityIdReconcilerHook = new EntityIdReconcilerHook(metaDataRepository);
        SecretHook secretHook = new SecretHook();
        TypeSafetyHook typeSafetyHook = new TypeSafetyHook(metaDataAutoConfiguration);
        EntityIdConstraintsHook entityIdConstraintsHook = new EntityIdConstraintsHook(metaDataRepository);
        OidcValidationHook validationHook = new OidcValidationHook(metaDataAutoConfiguration);
        SSIDValidationHook ssidValidationHook = new SSIDValidationHook(metaDataRepository, metaDataAutoConfiguration);
        return new CompositeMetaDataHook(Arrays.asList(emptyRevisionHook, validationHook, typeSafetyHook, entityIdConstraintsHook, entityIdReconcilerHook, ssidValidationHook, secretHook));
    }
}

