/*
 * Decompiled with CFR 0.152.
 */
package manage.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import manage.model.MetaData;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExporterService {
    static final List<String> excludedDataFields = Arrays.asList("id", "eid", "revisionid", "user", "created", "ip", "revisionnote", "notes");
    private static final List<String> validMetadataExportTypes = Arrays.asList("saml20_idp", "saml20_sp", "single_tenant_template");
    private static final MustacheFactory MUSTACHE_FACTORY = new DefaultMustacheFactory();
    private static final List<String> excludeMetaDataOnlyKeys = Arrays.asList("allowedEntities", "arp", "disableConsent", "active", "manipulation");
    private final ResourceLoader resourceLoader;
    private final Clock clock;
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Value(value="#{'${product.supported_languages}'.split(',')}")
    private List<String> languages;
    @Value(value="${metadata_export_path}")
    private String metadataExportPath;

    public ExporterService(ResourceLoader resourceLoader) {
        this.clock = Clock.systemDefaultZone();
        this.resourceLoader = resourceLoader;
    }

    public Map<String, Object> export(MetaData metaData) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        metaData.getData().entrySet().removeIf(entry -> entry.getValue() == null);
        Map nested = this.exportToMap(metaData, true);
        Map flat = this.exportToMap(metaData, false);
        ObjectWriter objectWriter = this.objectMapper.writerWithDefaultPrettyPrinter();
        result.put("json", objectWriter.writeValueAsString((Object)nested));
        result.put("jsonFlat", objectWriter.writeValueAsString((Object)flat));
        if (validMetadataExportTypes.contains(metaData.getType())) {
            result.put("xml", this.exportToXml(metaData));
        }
        TreeMap metaDataOnlyNested = new TreeMap(nested);
        excludeMetaDataOnlyKeys.forEach(metaDataOnlyNested::remove);
        result.put("jsonMetaDataOnly", objectWriter.writeValueAsString(metaDataOnlyNested));
        TreeMap metaDataOnlyFlat = new TreeMap(flat);
        excludeMetaDataOnlyKeys.forEach(metaDataOnlyFlat::remove);
        result.put("jsonMetaDataOnlyFlat", objectWriter.writeValueAsString(metaDataOnlyFlat));
        return result;
    }

    public String exportToXml(MetaData metaData) throws IOException {
        String type = metaData.getType();
        if (!validMetadataExportTypes.contains(type)) {
            throw new IllegalArgumentException(String.format("Not allowed metaData type %s. Allowed are %s", type, validMetadataExportTypes));
        }
        String path = String.format("%s/%s.xml", this.metadataExportPath, type);
        Resource resource = this.resourceLoader.getResource(path);
        String template = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
        Mustache mustache = MUSTACHE_FACTORY.compile((Reader)new StringReader(template), type);
        StringWriter writer = new StringWriter();
        try {
            Map data = (Map)Map.class.cast(metaData.getData());
            this.addOrganizationName(data);
            this.addValidUntil(data);
            this.addAttributeConsumingService(data);
            this.addUIInfoExtension(data);
            this.addUILogo(data);
            mustache.execute((Writer)writer, (Object)data).flush();
            String xml = writer.toString();
            return xml;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> nestMetaData(Map metaData, String type) {
        return this.doExportToMap(true, metaData, type);
    }

    public Map<String, Object> exportToMap(MetaData metaData, boolean nested) {
        Map data = metaData.getData();
        return this.doExportToMap(nested, data, metaData.getType().replaceAll("_", "-"));
    }

    private Map<String, Object> doExportToMap(boolean nested, Map<String, Object> data, String type) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        if (nested) {
            data.forEach((key, value) -> this.addKeyValue(key, value, result));
        } else {
            result.putAll(data);
            result.put("metaDataFields", new TreeMap((Map)Map.class.cast(result.get("metaDataFields"))));
        }
        excludedDataFields.forEach(result::remove);
        result.put("type", type);
        return result;
    }

    private void addKeyValue(String key, Object value, Map<String, Object> result) {
        if (value instanceof Map) {
            TreeMap map = new TreeMap();
            result.put((String)key, map);
            ((Map)Map.class.cast(value)).forEach((mapKey, mapValue) -> this.addKeyValue((String)String.class.cast(mapKey), mapValue, map));
            return;
        }
        if (value instanceof List) {
            if ("allowedEntities".equals(key) || "disableConsent".equals(key)) {
                List values = (List)List.class.cast(value);
                ArrayList list = new ArrayList();
                result.put((String)key, list);
                values.forEach(mapValue -> list.add(mapValue.get("name")));
                return;
            }
            result.put((String)key, (Object)value);
            return;
        }
        List<String> parts = Arrays.asList(key.split(":"));
        if (parts.size() == 1) {
            result.put((String)key, (Object)value);
        } else {
            Map reference = result;
            List<String> subParts = parts.subList(0, parts.size() - 1);
            for (String subKey : subParts) {
                if (!reference.containsKey(subKey)) {
                    reference.put((String)subKey, new TreeMap());
                }
                reference = (Map)Map.class.cast(reference.get(subKey));
            }
            reference.put((String)parts.get(parts.size() - 1), (Object)value);
        }
    }

    private void addValidUntil(Map data) {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(LocalDateTime.now(this.clock), TimeZone.getTimeZone("UTC").toZoneId());
        String validUntil = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime.plusYears(1L));
        data.put("validUntil", validUntil);
    }

    private void addOrganizationName(Map data) {
        Map metaDataFields = (Map)Map.class.cast(data.get("metaDataFields"));
        String name = this.addLanguageFallbackValue(metaDataFields, "OrganizationName");
        String displayName = this.addLanguageFallbackValue(metaDataFields, "OrganizationDisplayName");
        String url = this.addLanguageFallbackValue(metaDataFields, "OrganizationName");
        metaDataFields.put("OrganizationInfo", StringUtils.hasText((String)name) || StringUtils.hasText((String)displayName) || StringUtils.hasText((String)url));
    }

    private void addAttributeConsumingService(Map data) {
        Object attributesObject;
        Map arp;
        boolean arpAttributes = false;
        Object possibleArp = data.get("arp");
        if (possibleArp instanceof Map && ((Boolean)Boolean.class.cast((arp = (Map)Map.class.cast(possibleArp)).getOrDefault("enabled", false))).booleanValue() && (attributesObject = arp.get("attributes")) != null) {
            if (attributesObject instanceof Map) {
                Map attributes = (Map)Map.class.cast(attributesObject);
                boolean bl = arpAttributes = !attributes.isEmpty();
                if (arpAttributes) {
                    data.put("requestedAttributes", attributes.keySet());
                }
            } else if (attributesObject instanceof List) {
                List attributes = (List)List.class.cast(attributesObject);
                boolean bl = arpAttributes = !attributes.isEmpty();
                if (arpAttributes) {
                    data.put("requestedAttributes", new HashSet(attributes));
                }
            }
        }
        data.put("AttributeConsumingService", arpAttributes);
    }

    private void addUIInfoExtension(Map data) {
        Map metaDataFields = (Map)Map.class.cast(data.get("metaDataFields"));
        String name = this.addLanguageFallbackValue(metaDataFields, "name");
        String description = this.addLanguageFallbackValue(metaDataFields, "description");
        data.put("UIInfoExtension", StringUtils.hasText((String)name) || StringUtils.hasText((String)description));
    }

    private String addLanguageFallbackValue(Map metaDataFields, String attribute) {
        AtomicReference reference = new AtomicReference();
        this.languages.forEach(lang -> {
            if (StringUtils.isEmpty(reference.get())) {
                reference.set((String)metaDataFields.get(attribute + ":" + lang));
            }
        });
        if (StringUtils.hasText((String)((String)reference.get()))) {
            this.languages.forEach(lang -> metaDataFields.computeIfAbsent(attribute + ":" + lang, key -> (String)reference.get()));
        }
        return (String)reference.get();
    }

    private void addUILogo(Map data) {
        Map metaDataFields = (Map)Map.class.cast(data.get("metaDataFields"));
        Object height = metaDataFields.get("logo:0:height");
        Object width = metaDataFields.get("logo:0:width");
        String url = (String)metaDataFields.get("logo:0:url");
        data.put("Logo", height != null && width != null && StringUtils.hasText((String)url));
    }
}

