/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Map;
import java.util.regex.Pattern;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.CollectionUtils;

public class SecretHook
extends MetaDataHookAdapter {
    private BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private Pattern pattern = Pattern.compile("^\\$2[ayb]\\$.{56}$");

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.RP.getType()) || metaData.getType().equals(EntityType.RS.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        return this.encryptSecret(newMetaData);
    }

    public MetaData prePost(MetaData metaData) {
        return this.encryptSecret(metaData);
    }

    private MetaData encryptSecret(MetaData newMetaData) {
        String secret;
        Map data = newMetaData.metaDataFields();
        if (!CollectionUtils.isEmpty((Map)data) && data.containsKey("secret") && !this.isBCryptEncoded(secret = (String)data.get("secret"))) {
            String encoded = this.passwordEncoder.encode((CharSequence)secret);
            data.put("secret", encoded);
        }
        return newMetaData;
    }

    boolean isBCryptEncoded(String secret) {
        return this.pattern.matcher(secret).matches();
    }
}

