/*
 * Decompiled with CFR 0.152.
 */
package manage.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import manage.api.APIUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.control.DatabaseController;
import manage.exception.DuplicateEntityIdException;
import manage.exception.EndpointNotAllowed;
import manage.exception.ResourceNotFoundException;
import manage.format.SaveURLResource;
import manage.hook.MetaDataHook;
import manage.model.DashboardConnectOption;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.MetaData;
import manage.model.MetaDataKeyDelete;
import manage.model.MetaDataUpdate;
import manage.model.RevisionRestore;
import manage.model.ServiceProvider;
import manage.repository.MetaDataRepository;
import manage.service.ExporterService;
import manage.service.ImporterService;
import manage.shibboleth.FederatedUser;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class MetaDataService {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataService.class);
    public static final String REQUESTED_ATTRIBUTES = "REQUESTED_ATTRIBUTES";
    public static final String ALL_ATTRIBUTES = "ALL_ATTRIBUTES";
    public static final String LOGICAL_OPERATOR_IS_AND = "LOGICAL_OPERATOR_IS_AND";
    private static final String DASHBOARD_CONNECT_OPTION = "coin:dashboard_connect_option";
    private static final List<String> entityTypesSuggestions = Arrays.asList(EntityType.RP.getType(), EntityType.SP.getType(), EntityType.RS.getType());
    private MetaDataRepository metaDataRepository;
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private MetaDataHook metaDataHook;
    private DatabaseController databaseController;
    private Environment environment;
    private ImporterService importerService;
    private ExporterService exporterService;

    public MetaDataService(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, MetaDataHook metaDataHook, DatabaseController databaseController, ImporterService importerService, ExporterService exporterService, Environment environment) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataHook = metaDataHook;
        this.databaseController = databaseController;
        this.exporterService = exporterService;
        this.environment = environment;
        this.importerService = importerService;
    }

    public MetaData getMetaDataAndValidate(String type, String id) {
        MetaData metaData = this.metaDataRepository.findById(id, type);
        this.checkNull(type, id, metaData);
        return this.metaDataHook.postGet(metaData);
    }

    public Map<String, List> importFeed(Import importRequest) {
        try {
            Map<String, ServiceProvider> serviceProviderMap = this.metaDataRepository.allServiceProviderEntityIds().stream().map(ServiceProvider::new).collect(Collectors.toMap(ServiceProvider::getEntityId, sp -> sp));
            String feedUrl = importRequest.getUrl();
            SaveURLResource resource = new SaveURLResource(new URL(feedUrl), this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})));
            List allImports = this.importerService.importFeed((Resource)resource);
            List<Map> imports = allImports.stream().filter(m -> !m.isEmpty()).collect(Collectors.toList());
            HashMap<String, List> results = new HashMap<String, List>();
            EntityType entityType = EntityType.SP;
            imports.forEach(sp -> {
                block11: {
                    String entityId = (String)sp.get("entityid");
                    sp.put("metadataurl", feedUrl);
                    Map metaDataFields = (Map)Map.class.cast(sp.get("metaDataFields"));
                    metaDataFields.put("coin:imported_from_edugain", true);
                    metaDataFields.put("coin:interfed_source", "eduGAIN");
                    ServiceProvider existingServiceProvider = (ServiceProvider)serviceProviderMap.get(entityId);
                    if (existingServiceProvider != null) {
                        if (existingServiceProvider.isPublishedInEduGain()) {
                            List publishedInEdugain = results.computeIfAbsent("published_in_edugain", s -> new ArrayList());
                            publishedInEdugain.add(existingServiceProvider);
                        } else if (existingServiceProvider.isImportedFromEduGain()) {
                            try {
                                MetaDataUpdate metaDataUpdate = this.importToMetaDataUpdate(existingServiceProvider.getId(), entityType, sp, feedUrl);
                                Optional metaData = this.doMergeUpdate(metaDataUpdate, "edugain-import", "edugain-import", false);
                                if (metaData.isPresent()) {
                                    List merged = results.computeIfAbsent("merged", s -> new ArrayList());
                                    merged.add(existingServiceProvider);
                                    break block11;
                                }
                                List noChanges = results.computeIfAbsent("no_changes", s -> new ArrayList());
                                noChanges.add(existingServiceProvider);
                            }
                            catch (JsonProcessingException | ValidationException e) {
                                this.addNoValid(results, entityId, (Exception)e);
                            }
                        } else {
                            List notImported = results.computeIfAbsent("not_imported", s -> new ArrayList());
                            notImported.add(existingServiceProvider);
                        }
                    } else {
                        try {
                            MetaData metaData = this.importToMetaData(sp, entityType);
                            MetaData persistedMetaData = this.doPost(metaData, "edugain-import", false);
                            List imported = results.computeIfAbsent("imported", s -> new ArrayList());
                            imported.add(new ServiceProvider(persistedMetaData.getId(), entityId, false, false, null));
                        }
                        catch (JsonProcessingException | ValidationException e) {
                            this.addNoValid(results, entityId, (Exception)e);
                        }
                    }
                }
            });
            List<ServiceProvider> notInFeedAnymore = serviceProviderMap.values().stream().filter(sp -> sp.isImportedFromEduGain() && imports.stream().noneMatch(map -> sp.getEntityId().equals(map.get("entityid")))).collect(Collectors.toList());
            notInFeedAnymore.forEach(sp -> this.doRemove(entityType.getType(), sp.getId(), "edugain-import", "Removed from eduGain feed"));
            List deleted = results.computeIfAbsent("deleted", s -> new ArrayList());
            deleted.addAll(notInFeedAnymore.stream().map(ServiceProvider::getEntityId).collect(Collectors.toList()));
            results.put("total", Collections.singletonList(imports.size()));
            return results;
        }
        catch (IOException | XMLStreamException e) {
            return Collections.singletonMap("errors", Collections.singletonList(e.getClass().getName()));
        }
    }

    public MetaData doPost(@Validated MetaData metaData, String uid, boolean excludeFromPushRequired) throws JsonProcessingException {
        String entityid = (String)metaData.getData().get("entityid");
        List result = this.uniqueEntityId(metaData.getType(), entityid);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            throw new DuplicateEntityIdException(entityid);
        }
        this.sanitizeExcludeFromPush(metaData, excludeFromPushRequired);
        metaData = this.metaDataHook.prePost(metaData);
        metaData = this.validate(metaData);
        Long eid = this.metaDataRepository.incrementEid();
        metaData.initial(UUID.randomUUID().toString(), uid, eid);
        LOG.info("Saving new metaData {} by {}", (Object)metaData.getId(), (Object)uid);
        this.metaDataRepository.save(metaData);
        return this.getMetaDataAndValidate(metaData.getType(), metaData.getId());
    }

    public boolean doRemove(String type, String id, String uid, String revisionNote) {
        MetaData current = this.metaDataRepository.findById(id, type);
        this.checkNull(type, id, current);
        current = this.metaDataHook.preDelete(current);
        this.metaDataRepository.remove(current);
        LOG.info("Deleted metaData {} by {}", (Object)current.getId(), (Object)uid);
        current.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(current);
        current.terminate(UUID.randomUUID().toString(), revisionNote, uid);
        this.metaDataRepository.save(current);
        return true;
    }

    public MetaData doPut(@Validated MetaData metaData, String updatedBy, boolean excludeFromPushRequired) throws JsonProcessingException {
        String entityid = (String)metaData.getData().get("entityid");
        List result = this.uniqueEntityId(metaData.getType(), entityid);
        if (result.size() > 1) {
            throw new DuplicateEntityIdException(entityid);
        }
        this.sanitizeExcludeFromPush(metaData, excludeFromPushRequired);
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        this.checkNull(metaData.getType(), id, previous);
        metaData = this.metaDataHook.prePut(previous, metaData);
        metaData = this.validate(metaData);
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest(updatedBy, (String)metaData.getData().get("revisionnote"));
        this.metaDataRepository.update(metaData);
        LOG.info("Updated metaData {} by {}", (Object)metaData.getId(), (Object)updatedBy);
        return this.getMetaDataAndValidate(metaData.getType(), metaData.getId());
    }

    public List<String> deleteMetaDataKey(MetaDataKeyDelete metaDataKeyDelete, APIUser apiUser) throws JsonProcessingException {
        String keyToDelete = metaDataKeyDelete.getMetaDataKey();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)("data.metaDataFields." + keyToDelete)).exists(true));
        List metaDataList = this.metaDataRepository.getMongoTemplate().find(query, MetaData.class, metaDataKeyDelete.getType());
        for (MetaData metaData2 : metaDataList) {
            metaData2.metaDataFields().remove(keyToDelete);
            metaData2 = this.validate(metaData2);
            MetaData previous = this.metaDataRepository.findById(metaData2.getId(), metaData2.getType());
            previous.revision(UUID.randomUUID().toString());
            this.metaDataRepository.save(previous);
            metaData2.promoteToLatest(apiUser.getName(), String.format("API call for deleting %s by %s", keyToDelete, apiUser.getName()));
            this.metaDataRepository.update(metaData2);
        }
        return metaDataList.stream().map(metaData -> (String)metaData.getData().get("entityid")).collect(Collectors.toList());
    }

    public Optional<MetaData> doMergeUpdate(MetaDataUpdate metaDataUpdate, String name, String revisionNote, boolean forceNewRevision) throws JsonProcessingException {
        boolean somethingChanged;
        String id = metaDataUpdate.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        this.checkNull(metaDataUpdate.getType(), id, previous);
        previous.revision(UUID.randomUUID().toString());
        MetaData metaData = this.metaDataRepository.findById(id, metaDataUpdate.getType());
        metaData.promoteToLatest(name, revisionNote);
        metaData.merge(metaDataUpdate);
        if (!CollectionUtils.isEmpty((Map)metaDataUpdate.getExternalReferenceData())) {
            metaData.getData().putAll(metaDataUpdate.getExternalReferenceData());
        }
        if (!name.equals("edugain-import")) {
            metaData = this.metaDataHook.prePut(previous, metaData);
        }
        boolean bl = somethingChanged = !(metaData = this.validate(metaData)).metaDataFields().equals(previous.metaDataFields());
        if (somethingChanged || forceNewRevision) {
            this.metaDataRepository.save(previous);
            this.metaDataRepository.update(metaData);
            LOG.info("Merging new metaData {} by {}", (Object)metaData.getId(), (Object)name);
            return Optional.of(this.getMetaDataAndValidate(metaData.getType(), metaData.getId()));
        }
        return Optional.empty();
    }

    public MetaData restoreDeleted(RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        if (parent != null) {
            throw new IllegalArgumentException("Parent is not null");
        }
        String newId = revision.getRevision().getParentId();
        revision.getRevision().deTerminate(newId);
        this.metaDataRepository.update(revision);
        revision.restoreToLatest(newId, Long.valueOf(0L), federatedUser.getUid(), revision.getRevision().getNumber(), revisionRestore.getParentType());
        revision = this.validate(revision);
        this.metaDataRepository.save(revision);
        LOG.info("Restored deleted revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    public MetaData restoreRevision(RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData revision = this.metaDataRepository.findById(revisionRestore.getId(), revisionRestore.getType());
        MetaData parent = this.metaDataRepository.findById(revision.getRevision().getParentId(), revisionRestore.getParentType());
        revision.restoreToLatest(parent.getId(), parent.getVersion(), federatedUser.getUid(), parent.getRevision().getNumber(), revisionRestore.getParentType());
        revision = this.validate(revision);
        this.metaDataRepository.update(revision);
        parent.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(parent);
        LOG.info("Restored revision {} with Id {} by {}", new Object[]{revisionRestore, revision.getId(), federatedUser.getUid()});
        return revision;
    }

    public Map<String, List<Map>> autoCompleteEntities(String type, String query) {
        List suggestions = this.metaDataRepository.autoComplete(type, query);
        HashMap<String, List<Map>> results = new HashMap<String, List<Map>>();
        results.put("suggestions", suggestions);
        if (suggestions.isEmpty() && entityTypesSuggestions.contains(type)) {
            ArrayList alternatives = new ArrayList();
            entityTypesSuggestions.stream().filter(s -> !s.equals(type)).forEach(s -> alternatives.addAll(this.metaDataRepository.autoComplete(s, query)));
            results.put("alternatives", alternatives);
        }
        return results;
    }

    public List<Map> uniqueEntityId(String type, String entityId) {
        List results;
        EntityType entityType = EntityType.fromType((String)type);
        if (entityType.equals((Object)EntityType.IDP) || entityType.equals((Object)EntityType.STT)) {
            results = this.metaDataRepository.findByEntityId(entityType.getType(), entityId);
        } else if (entityType.equals((Object)EntityType.RS)) {
            results = this.metaDataRepository.findByEntityId(entityType.getType(), entityId);
            results.addAll(this.metaDataRepository.findByEntityId(EntityType.RP.getType(), entityId));
        } else {
            results = this.metaDataRepository.findByEntityId(entityType.getType(), entityId);
            String otherType = entityType.equals((Object)EntityType.RP) ? EntityType.SP.getType() : EntityType.RP.getType();
            results.addAll(this.metaDataRepository.findByEntityId(otherType, entityId));
            if (entityType.equals((Object)EntityType.RP)) {
                results.addAll(this.metaDataRepository.findByEntityId(EntityType.RS.getType(), entityId));
            }
        }
        return results;
    }

    public List<Map> searchEntityByType(String type, Map<String, Object> properties, boolean nested) {
        List requestedAttributes = properties.getOrDefault(REQUESTED_ATTRIBUTES, new ArrayList());
        Boolean allAttributes = (Boolean)properties.getOrDefault(ALL_ATTRIBUTES, false);
        Boolean logicalOperatorIsAnd = (Boolean)properties.getOrDefault(LOGICAL_OPERATOR_IS_AND, true);
        properties.remove(REQUESTED_ATTRIBUTES);
        properties.remove(ALL_ATTRIBUTES);
        properties.remove(LOGICAL_OPERATOR_IS_AND);
        List search = this.metaDataRepository.search(type, properties, requestedAttributes, allAttributes, logicalOperatorIsAnd);
        return nested ? search.stream().map(m -> this.exporterService.nestMetaData(m, type)).collect(Collectors.toList()) : search;
    }

    public List<MetaData> retrieveRawSearch(String type, String query) throws UnsupportedEncodingException {
        if (query.startsWith("%")) {
            query = URLDecoder.decode(query, "UTF-8");
        }
        return this.metaDataRepository.findRaw(type, query);
    }

    public List<MetaData> retrieveRecentActivity(Map<String, Object> properties) {
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        Object limit = properties.getOrDefault("limit", 25);
        int max = 25;
        if (limit instanceof Integer) {
            max = (Integer)limit;
        }
        List types = properties.getOrDefault("types", Arrays.asList(EntityType.IDP.getType(), EntityType.SP.getType(), EntityType.RP.getType(), EntityType.RS.getType())).stream().map(EntityType::fromType).collect(Collectors.toList());
        return this.metaDataRepository.recentActivity(types, max);
    }

    public void createConnectWithoutInteraction(Map<String, String> connectionData, APIUser apiUser) throws JsonProcessingException {
        boolean shareInstitutionId;
        String spType;
        String idpEntityId = connectionData.get("idpId");
        MetaData idp = this.findByEntityId(idpEntityId, EntityType.IDP.getType());
        String spEntityId = connectionData.get("spId");
        MetaData sp = this.findByEntityId(spEntityId, spType = connectionData.get("spType"));
        String dashboardConnectType = (String)sp.metaDataFields().get(DASHBOARD_CONNECT_OPTION);
        boolean connectWithoutInteraction = StringUtils.hasText((String)dashboardConnectType) && DashboardConnectOption.fromType((String)dashboardConnectType).connectWithoutInteraction();
        Object idpInstitutionId = idp.metaDataFields().get("coin:institution_id");
        Object spInstitutionId = sp.metaDataFields().get("coin:institution_id");
        boolean bl = shareInstitutionId = idpInstitutionId != null && idpInstitutionId.equals(spInstitutionId) && !"connect_with_interaction".equals(dashboardConnectType);
        if (!connectWithoutInteraction && !shareInstitutionId) {
            throw new EndpointNotAllowed(String.format("SP %s does not allow an automatic connection with IdP %s. SP dashboardConnectType: %s, idpInstitutionId: %s, spInstitutionId %s", spEntityId, idpEntityId, dashboardConnectType, idpInstitutionId, spInstitutionId));
        }
        this.addAllowedEntity(sp, idpEntityId, connectionData, apiUser);
        this.addAllowedEntity(idp, spEntityId, connectionData, apiUser);
        this.databaseController.doPush();
    }

    private void addAllowedEntity(MetaData metaData, String entityId, Map<String, String> connectionData, APIUser apiUser) throws JsonProcessingException {
        Map data = metaData.getData();
        List allowedEntities = data.getOrDefault("allowedEntities", new ArrayList());
        boolean allowedAll = data.getOrDefault("allowedall", true);
        if (!allowedAll && allowedEntities.stream().noneMatch(allowedEntity -> ((String)allowedEntity.get("name")).equals(entityId))) {
            allowedEntities.add(Collections.singletonMap("name", entityId));
            data.put("allowedEntities", allowedEntities);
            String revisionNote = String.format("Connected %s on request of %s - %s via Dashboard.", entityId, connectionData.get("user"), connectionData.get("userUrn"));
            data.put("revisionnote", revisionNote);
            this.doPut(metaData, apiUser.getName(), false);
        }
    }

    private MetaData findByEntityId(String entityId, String type) {
        List searchResults = this.uniqueEntityId(type, entityId);
        if (CollectionUtils.isEmpty((Collection)searchResults)) {
            throw new ResourceNotFoundException(String.format("Type %s with entityId %s does not exists", type, entityId));
        }
        return this.metaDataRepository.findById((String)((Map)searchResults.get(0)).get("_id"), type);
    }

    public MetaData validate(MetaData metaData) throws JsonProcessingException {
        metaData = this.metaDataHook.preValidate(metaData);
        this.metaDataAutoConfiguration.validate(metaData.getData(), metaData.getType());
        return metaData;
    }

    private void checkNull(String type, String id, MetaData metaData) {
        if (metaData == null) {
            throw new ResourceNotFoundException(String.format("MetaData type %s with id %s does not exist", type, id));
        }
    }

    private void sanitizeExcludeFromPush(@RequestBody @Validated MetaData metaData, boolean excludeFromPushRequired) {
        Map metaDataFields = metaData.metaDataFields();
        Object val = metaDataFields.get("coin:exclude_from_push");
        if (excludeFromPushRequired && ("0".equals(val) || Boolean.FALSE == val)) {
            metaDataFields.put("coin:exclude_from_push", true);
        }
    }

    private void addNoValid(Map<String, List> results, String entityId, Exception e) {
        String msg = e instanceof ValidationException ? String.join((CharSequence)", ", ((ValidationException)((Object)ValidationException.class.cast(e))).getAllMessages()) : e.getClass().getName();
        List notValid = results.computeIfAbsent("not_valid", s -> new ArrayList());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("validationException", msg);
        result.put("entityId", entityId);
        notValid.add(result);
    }

    private MetaData importToMetaData(Map<String, Object> m, EntityType entityType) {
        Map data = this.metaDataAutoConfiguration.metaDataTemplate(entityType.getType());
        MetaData template = new MetaData(entityType.getType(), data);
        template.getData().putAll(m);
        template.getData().put("state", "prodaccepted");
        return template;
    }

    private MetaDataUpdate importToMetaDataUpdate(String id, EntityType entityType, Map<String, Object> m, String feedUrl) {
        Map metaDataFields = (Map)Map.class.cast(m.get("metaDataFields"));
        HashMap<String, String> pathUpdates = new HashMap<String, String>();
        metaDataFields.forEach((k, v) -> pathUpdates.put("metaDataFields.".concat((String)k), (String)v));
        pathUpdates.put("metadataurl", feedUrl);
        MetaDataUpdate metaDataUpdate = new MetaDataUpdate(id, entityType.getType(), pathUpdates, Collections.emptyMap());
        return metaDataUpdate;
    }

    public void addDefaultSpData(Map<String, Object> innerJson) {
        innerJson.put("allowedall", true);
        innerJson.put("state", "testaccepted");
        innerJson.put("allowedEntities", new ArrayList());
    }
}

