/*
 * Decompiled with CFR 0.152.
 */
package manage.shibboleth.mock;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import manage.shibboleth.mock.MockShibbolethFilter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class MockShibbolethFilter
extends GenericFilterBean {
    public static final String SAML2_USER = "saml2_user.com";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            SetHeader wrapper = new SetHeader((HttpServletRequest)servletRequest);
            wrapper.setHeader("name-id", SAML2_USER);
            wrapper.setHeader("displayname", "John Doe");
            wrapper.setHeader("schacHomeOrganization", "http://mock-idp");
            filterChain.doFilter((ServletRequest)wrapper, servletResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

