/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import crypto.KeyStore;
import crypto.RSAKeyStore;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.CompositeMetaDataHook;
import manage.hook.EmptyRevisionHook;
import manage.hook.EncryptionHook;
import manage.hook.EntityIdConstraintsHook;
import manage.hook.EntityIdReconcilerHook;
import manage.hook.OidcValidationHook;
import manage.hook.ProvisioningHook;
import manage.hook.RequiredAttributesHook;
import manage.hook.SSIDValidationHook;
import manage.hook.SecretHook;
import manage.hook.TypeSafetyHook;
import manage.repository.MetaDataRepository;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class MetaDataHookConfiguration {
    @Bean
    @Autowired
    CompositeMetaDataHook hooks(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, @Value(value="${crypto.public-key-location}") Resource publicKeyResource, @Value(value="${crypto.development-mode}") Boolean developmentMode) {
        EmptyRevisionHook emptyRevisionHook = new EmptyRevisionHook(metaDataAutoConfiguration);
        EntityIdReconcilerHook entityIdReconcilerHook = new EntityIdReconcilerHook(metaDataRepository);
        SecretHook secretHook = new SecretHook(metaDataAutoConfiguration);
        TypeSafetyHook typeSafetyHook = new TypeSafetyHook(metaDataAutoConfiguration);
        EntityIdConstraintsHook entityIdConstraintsHook = new EntityIdConstraintsHook(metaDataRepository);
        OidcValidationHook validationHook = new OidcValidationHook(metaDataAutoConfiguration);
        SSIDValidationHook ssidValidationHook = new SSIDValidationHook(metaDataRepository, metaDataAutoConfiguration);
        RequiredAttributesHook requiredAttributesHook = new RequiredAttributesHook(metaDataAutoConfiguration);
        ProvisioningHook provisioningHook = new ProvisioningHook(metaDataRepository, metaDataAutoConfiguration);
        RSAKeyStore keyStore = developmentMode != false ? new RSAKeyStore() : new RSAKeyStore(IOUtils.toString((InputStream)publicKeyResource.getInputStream(), (Charset)Charset.defaultCharset()), true);
        EncryptionHook encryptionHook = new EncryptionHook((KeyStore)keyStore);
        return new CompositeMetaDataHook(Arrays.asList(emptyRevisionHook, validationHook, typeSafetyHook, entityIdConstraintsHook, entityIdReconcilerHook, ssidValidationHook, secretHook, requiredAttributesHook, provisioningHook, encryptionHook));
    }
}

