/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.util.StringUtils;

public class ProvisioningHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final MetaDataRepository metaDataRepository;

    public ProvisioningHook(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.PROV.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        String newProvisioningType;
        String previousProvisioningType = (String)previous.metaDataFields().get("provisioning_type");
        if (!previousProvisioningType.equals(newProvisioningType = (String)newMetaData.metaDataFields().get("provisioning_type"))) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PROV.getType());
            throw new ValidationException(schema, String.format("Not allowed the change the provisioning_type for provisioning metadata (changed from %s to %s). Delete this entity and create new provisioning", previousProvisioningType, newProvisioningType), "metaDataFields.provisioning_type");
        }
        this.prePost(newMetaData);
        return this.filterInvalidApplications(newMetaData);
    }

    public MetaData prePost(MetaData metaData) {
        this.validate(metaData);
        return this.filterInvalidApplications(metaData);
    }

    private void validate(MetaData newMetaData) {
        Map metaDataFields = newMetaData.metaDataFields();
        ArrayList failures = new ArrayList();
        Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PROV.getType());
        String provisioningType = (String)metaDataFields.get("provisioning_type");
        Map.of("scim", List.of("scim_url", "scim_user", "scim_password"), "graph", List.of("graph_client_id", "graph_secret", "graph_tenant"), "eva", List.of("eva_url", "eva_token")).forEach((type, required) -> {
            if (type.equals(provisioningType)) {
                required.forEach(attribute -> {
                    if (!StringUtils.hasText((String)((String)metaDataFields.get(attribute)))) {
                        failures.add(new ValidationException(schema, String.format("%s is required with provisioningType %s", attribute, provisioningType), attribute));
                    }
                });
            }
        });
        ValidationException.throwFor((Schema)schema, failures);
    }

    private MetaData filterInvalidApplications(MetaData metaData) {
        List applications = metaData.getData().getOrDefault("applications", Collections.emptyList());
        List newApplications = applications.stream().filter(application -> this.metaDataRepository.findById((String)application.get("id"), (String)application.get("type")) != null).collect(Collectors.toList());
        metaData.getData().put("applications", newApplications);
        return metaData;
    }
}

