/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import manage.api.APIUser;
import manage.api.AbstractUser;
import manage.api.Scope;
import manage.conf.MetaDataAutoConfiguration;
import manage.model.ChangeRequest;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.MetaData;
import manage.model.MetaDataChangeRequest;
import manage.model.MetaDataKeyDelete;
import manage.model.MetaDataUpdate;
import manage.model.PathUpdates;
import manage.model.RevisionRestore;
import manage.model.StatsEntry;
import manage.model.XML;
import manage.repository.MetaDataRepository;
import manage.service.ExporterService;
import manage.service.ImporterService;
import manage.service.MetaDataService;
import manage.shibboleth.FederatedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetaDataController {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataController.class);
    private MetaDataRepository metaDataRepository;
    private MetaDataAutoConfiguration metaDataAutoConfiguration;
    private MetaDataService metaDataService;
    private ExporterService exporterService;
    private ImporterService importerService;

    public MetaDataController(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, ExporterService exporterService, ImporterService importerService, MetaDataService metaDataService) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.exporterService = exporterService;
        this.importerService = importerService;
        this.metaDataService = metaDataService;
    }

    @PreAuthorize(value="hasRole('USER')")
    @GetMapping(value={"/client/template/{type}"})
    public MetaData template(@PathVariable(value="type") String type) {
        Map data = this.metaDataAutoConfiguration.metaDataTemplate(type);
        return new MetaData(type, data);
    }

    @PreAuthorize(value="hasAnyRole('USER', 'READ')")
    @GetMapping(value={"/client/metadata/{type}/{id}", "/internal/metadata/{type}/{id}"})
    public MetaData get(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return this.metaDataService.getMetaDataAndValidate(type, id);
    }

    @PreAuthorize(value="hasRole('USER')")
    @GetMapping(value={"/client/metadata/configuration"})
    public List<Map<String, Object>> configuration() {
        return this.metaDataAutoConfiguration.schemaRepresentations();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/metadata"})
    public MetaData post(@Validated @RequestBody MetaData metaData, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.doPost(metaData, federatedUser.getUid(), false);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/includeInPush/{type}/{id}"})
    public MetaData includeInPush(@PathVariable(value="type") String type, @PathVariable(value="id") String id, FederatedUser federatedUser) throws JsonProcessingException {
        MetaData metaData = this.get(type, id);
        Map metaDataFields = metaData.metaDataFields();
        metaDataFields.remove("coin:exclude_from_push");
        return this.metaDataService.doPut(metaData, federatedUser.getUid(), false);
    }

    @PreAuthorize(value="hasRole('USER')")
    @GetMapping(value={"/client/metadata/stats"})
    public List<StatsEntry> stats() {
        return this.metaDataRepository.stats();
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/metadata"})
    public MetaData postInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.metaDataService.doPost(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/new-sp"})
    public MetaData newSP(@Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        Map innerJson = this.importerService.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.metaDataService.addDefaultSpData(innerJson);
        MetaData metaData = new MetaData(EntityType.SP.getType(), innerJson);
        return this.metaDataService.doPost(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @DeleteMapping(value={"/client/delete/feed"})
    public Map<String, Long> deleteFeed() {
        long deleted = this.metaDataRepository.deleteAllImportedServiceProviders();
        return Collections.singletonMap("deleted", deleted);
    }

    @PreAuthorize(value="hasRole('USER')")
    @GetMapping(value={"/client/count/feed"})
    public Map<String, Long> countFeed() {
        long count = this.metaDataRepository.countAllImportedServiceProviders();
        return Collections.singletonMap("count", count);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/import/feed"})
    public Map<String, List> importFeed(@Validated @RequestBody Import importRequest) {
        return this.metaDataService.importFeed(importRequest);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"/internal/update-sp/{id}/{version}"})
    public MetaData updateSP(@PathVariable(value="id") String id, @PathVariable(value="version") Long version, @Validated @RequestBody XML container, APIUser apiUser) throws IOException, XMLStreamException {
        MetaData metaData = this.metaDataService.getMetaDataAndValidate(EntityType.SP.getType(), id);
        Map innerJson = this.importerService.importXML((Resource)new ByteArrayResource(container.getXml().getBytes()), EntityType.SP, Optional.empty());
        this.metaDataService.addDefaultSpData(innerJson);
        metaData.setData(innerJson);
        metaData.setVersion(version);
        return this.metaDataService.doPut(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('READ')")
    @GetMapping(value={"/internal/sp-metadata/{id}"})
    public String exportXml(@PathVariable(value="id") String id) throws IOException {
        MetaData metaData = this.metaDataService.getMetaDataAndValidate(EntityType.SP.getType(), id);
        return this.exporterService.exportToXml(metaData);
    }

    @PreAuthorize(value="hasRole('READ')")
    @GetMapping(value={"/internal/xml/metadata/{type}/{id}"}, produces={"text/xml"})
    public String exportMetadataXml(@PathVariable(value="type") String type, @PathVariable(value="id") String id) throws IOException {
        MetaData metaData = this.metaDataService.getMetaDataAndValidate(EntityType.fromType((String)type).getType(), id);
        return this.exporterService.exportToXml(metaData);
    }

    @PreAuthorize(value="hasRole('READ')")
    @PostMapping(value={"/internal/validate/metadata"})
    public ResponseEntity<Object> validateMetaData(@Validated @RequestBody MetaData metaData) throws JsonProcessingException {
        this.metaDataService.validate(metaData);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata/{type}/{id}"})
    public boolean remove(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @RequestBody(required=false) Map body, FederatedUser user) {
        String defaultValue = "Deleted by " + user.getUid();
        String revisionNote = body != null ? (String)((Object)body.getOrDefault("revisionNote", defaultValue)) : defaultValue;
        revisionNote = StringUtils.hasText((String)revisionNote) ? revisionNote : defaultValue;
        return this.metaDataService.doRemove(type, id, user.getUid(), revisionNote);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @DeleteMapping(value={"/internal/metadata/{type}/{id}"})
    public boolean removeInternal(@PathVariable(value="type") String type, @PathVariable(value="id") String id, APIUser apiUser) {
        return this.metaDataService.doRemove(type, id, apiUser.getName(), "Deleted by APIUser " + apiUser.getName());
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/metadata"})
    @Transactional
    public MetaData put(@Validated @RequestBody MetaData metaData, Authentication authentication) throws JsonProcessingException {
        return this.metaDataService.doPut(metaData, authentication.getName(), false);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"/internal/metadata"})
    @Transactional
    public MetaData putInternal(@Validated @RequestBody MetaData metaData, APIUser apiUser) throws JsonProcessingException {
        return this.metaDataService.doPut(metaData, apiUser.getName(), !apiUser.getScopes().contains(Scope.TEST));
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"/internal/delete-metadata-key"})
    @Transactional
    public List<String> deleteMetaDataKey(@Validated @RequestBody MetaDataKeyDelete metaDataKeyDelete, APIUser apiUser) throws IOException {
        return this.metaDataService.deleteMetaDataKey(metaDataKeyDelete, apiUser);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"internal/merge"})
    @Transactional
    public MetaData update(@Validated @RequestBody MetaDataUpdate metaDataUpdate, APIUser apiUser) throws JsonProcessingException {
        String name = apiUser.getName();
        return (MetaData)this.metaDataService.doMergeUpdate((PathUpdates)metaDataUpdate, name, "Internal API merge", true).get();
    }

    @GetMapping(value={"/client/change-requests/{type}/{metaDataId}"})
    public List<MetaDataChangeRequest> changeRequests(@PathVariable(value="type") String type, @PathVariable(value="metaDataId") String metaDataId) {
        return this.metaDataRepository.changeRequests(metaDataId, type.concat("_change_request"));
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @GetMapping(value={"/internal/change-requests/{type}/{metaDataId}"})
    public List<MetaDataChangeRequest> internalChangeRequests(@PathVariable(value="type") String type, @PathVariable(value="metaDataId") String metaDataId) {
        return this.metaDataRepository.changeRequests(metaDataId, type.concat("_change_request"));
    }

    @GetMapping(value={"/client/change-requests/all"})
    public List<MetaDataChangeRequest> allChangeRequests() {
        return this.metaDataRepository.allChangeRequests();
    }

    @GetMapping(value={"client/change-requests/count"})
    public long openChangeRequests() {
        return this.metaDataRepository.openChangeRequests();
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PostMapping(value={"internal/change-requests"})
    @Transactional
    public MetaDataChangeRequest changeRequestInternal(@Validated @RequestBody MetaDataChangeRequest metaDataChangeRequest, APIUser apiUser) throws JsonProcessingException {
        return this.metaDataService.doChangeRequest(metaDataChangeRequest, (AbstractUser)apiUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"client/change-requests"})
    @Transactional
    public MetaDataChangeRequest changeRequestClient(@Validated @RequestBody MetaDataChangeRequest metaDataChangeRequest, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.doChangeRequest(metaDataChangeRequest, (AbstractUser)federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/change-requests/accept"})
    @Transactional
    public MetaData acceptChangeRequest(@RequestBody @Validated ChangeRequest changeRequest, FederatedUser user) throws JsonProcessingException {
        String name = user.getName();
        String collectionName = changeRequest.getType().concat("_change_request");
        MetaDataChangeRequest metaDataChangeRequest = (MetaDataChangeRequest)this.metaDataRepository.getMongoTemplate().findById((Object)changeRequest.getId(), MetaDataChangeRequest.class, collectionName);
        MetaData metaData = (MetaData)this.metaDataService.doMergeUpdate((PathUpdates)metaDataChangeRequest, name, changeRequest.getRevisionNotes(), true).get();
        this.metaDataRepository.getMongoTemplate().remove((Object)metaDataChangeRequest, collectionName);
        return metaData;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/change-requests/reject"})
    @Transactional
    public MetaData rejectChangeRequest(@RequestBody @Validated ChangeRequest changeRequest, FederatedUser user) {
        return this.metaDataService.doRejectChangeRequest(changeRequest, (AbstractUser)user);
    }

    @PreAuthorize(value="hasRole('WRITE')")
    @PutMapping(value={"/internal/change-requests/reject"})
    @Transactional
    public MetaData internalRejectChangeRequest(@RequestBody @Validated ChangeRequest changeRequest, APIUser user) {
        return this.metaDataService.doRejectChangeRequest(changeRequest, (AbstractUser)user);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreDeleted"})
    @Transactional
    public MetaData restoreDeleted(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.restoreDeleted(revisionRestore, federatedUser);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping(value={"/client/restoreRevision"})
    @Transactional
    public MetaData restoreRevision(@Validated @RequestBody RevisionRestore revisionRestore, FederatedUser federatedUser) throws JsonProcessingException {
        return this.metaDataService.restoreRevision(revisionRestore, federatedUser);
    }

    @PreAuthorize(value="hasRole('USER')")
    @GetMapping(value={"/client/revisions/{type}/{parentId}"})
    public List<MetaData> revisions(@PathVariable(value="type") String type, @PathVariable(value="parentId") String parentId) {
        return this.metaDataRepository.revisions(type.concat("_revision"), parentId);
    }

    @PreAuthorize(value="hasRole('USER')")
    @GetMapping(value={"/client/autocomplete/{type}"})
    public Map<String, List<Map>> autoCompleteEntities(@PathVariable(value="type") String type, @RequestParam(value="query") String query) {
        return this.metaDataService.autoCompleteEntities(type, query);
    }

    @PreAuthorize(value="hasRole('USER')")
    @GetMapping(value={"/client/whiteListing/{type}"})
    public List<Map> whiteListing(@PathVariable(value="type") String type, @RequestParam(value="state") String state) {
        return this.metaDataRepository.whiteListing(type, state);
    }

    @PreAuthorize(value="hasAnyRole('USER', 'READ')")
    @PostMapping(value={"/client/uniqueEntityId/{type}", "/internal/uniqueEntityId/{type}"})
    public List<Map> uniqueEntityId(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties) {
        String entityId = (String)properties.get("entityid");
        return this.metaDataService.uniqueEntityId(type, entityId);
    }

    @PreAuthorize(value="hasAnyRole('USER', 'READ')")
    @PostMapping(value={"/client/search/{type}", "/internal/search/{type}"})
    public List<Map> searchEntities(@PathVariable(value="type") String type, @RequestBody Map<String, Object> properties, @RequestParam(required=false, defaultValue="false") boolean nested) {
        return this.metaDataService.searchEntityByType(type, properties, nested);
    }

    @PreAuthorize(value="hasAnyRole('USER', 'READ')")
    @GetMapping(value={"/client/rawSearch/{type}", "/internal/rawSearch/{type}"})
    public List<MetaData> rawSearch(@PathVariable(value="type") String type, @RequestParam(value="query") String query) throws UnsupportedEncodingException {
        return this.metaDataService.retrieveRawSearch(type, query);
    }

    @PreAuthorize(value="hasAnyRole('USER', 'READ')")
    @PostMapping(value={"/client/recent-activity", "/internal/recent-activity"})
    public List<MetaData> recentActivity(@RequestBody(required=false) Map<String, Object> properties) {
        return this.metaDataService.retrieveRecentActivity(properties);
    }

    @Secured(value={"ROLE_WRITE"})
    @PutMapping(value={"/internal/connectWithoutInteraction"})
    public HttpEntity<HttpStatus> connectWithoutInteraction(@RequestBody Map<String, String> connectionData, APIUser apiUser) throws JsonProcessingException {
        LOG.debug("connectWithoutInteraction, connectionData: " + connectionData);
        this.metaDataService.createConnectWithoutInteraction(connectionData, apiUser);
        return new HttpEntity((Object)HttpStatus.OK);
    }
}

