/*
 * Decompiled with CFR 0.152.
 */
package manage.repository;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.MetaDataChangeRequest;
import manage.model.StatsEntry;
import manage.mongo.Sequence;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MetaDataRepository {
    private static final int AUTOCOMPLETE_LIMIT = 16;
    private final MongoTemplate mongoTemplate;
    private final List<String> supportedLanguages;
    private final FindAndModifyOptions options = FindAndModifyOptions.options().returnNew(true);

    @Autowired
    public MetaDataRepository(MongoTemplate mongoTemplate, @Value(value="${product.supported_languages}") String supportedLanguages) {
        this.mongoTemplate = mongoTemplate;
        this.supportedLanguages = Stream.of(supportedLanguages.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public MetaData findById(String id, String type) {
        return (MetaData)this.mongoTemplate.findById((Object)id, MetaData.class, type);
    }

    public MetaData save(MetaData metaData) {
        metaData.trimSpaces();
        this.mongoTemplate.insert((Object)metaData, metaData.getType());
        return metaData;
    }

    public MetaDataChangeRequest save(MetaDataChangeRequest metaDataChangeRequest) {
        return (MetaDataChangeRequest)this.mongoTemplate.insert((Object)metaDataChangeRequest, metaDataChangeRequest.getType().concat("_change_request"));
    }

    public void remove(MetaData metaData) {
        this.mongoTemplate.remove((Object)metaData, metaData.getType());
    }

    public List<MetaData> revisions(String type, String parentId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"revision.parentId").is((Object)parentId));
        return this.mongoTemplate.find(query, MetaData.class, type);
    }

    public List<MetaDataChangeRequest> changeRequests(String metaDataId, String collectionName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"metaDataId").is((Object)metaDataId));
        return this.mongoTemplate.find(query, MetaDataChangeRequest.class, collectionName);
    }

    public List<MetaDataChangeRequest> allChangeRequests() {
        ArrayList<MetaDataChangeRequest> results = new ArrayList<MetaDataChangeRequest>();
        Stream.of(EntityType.values()).forEach(entityType -> results.addAll(this.mongoTemplate.findAll(MetaDataChangeRequest.class, entityType.getType().concat("_change_request"))));
        return results;
    }

    public long openChangeRequests() {
        AtomicLong count = new AtomicLong(0L);
        Query query = new Query();
        Stream.of(EntityType.values()).forEach(entityType -> count.addAndGet(this.mongoTemplate.count(query, entityType.getType().concat("_change_request"))));
        return count.get();
    }

    public void update(MetaData metaData) {
        metaData.trimSpaces();
        this.mongoTemplate.save((Object)metaData, metaData.getType());
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public List<Map> autoComplete(String type, String search) {
        Query query = this.queryWithSamlFields();
        if ("*".equals(search)) {
            return this.mongoTemplate.find(query, Map.class, type);
        }
        String escapedSearch = this.escapeSpecialChars(search);
        query.limit(16);
        Criteria criteria = new Criteria();
        List<String> parts = Arrays.asList(escapedSearch.split(" "));
        criteria.andOperator((Criteria[])parts.stream().map(part -> {
            ArrayList<Criteria> orCriterias = new ArrayList<Criteria>();
            orCriterias.add(this.regex("data.entityid", part));
            this.supportedLanguages.forEach(lang -> {
                orCriterias.add(this.regex("data.metaDataFields.name:" + lang, part));
                orCriterias.add(this.regex("data.metaDataFields.displayName:" + lang, part));
                orCriterias.add(this.regex("data.metaDataFields.keywords:" + lang, part));
                orCriterias.add(this.regex("data.metaDataFields.OrganizationName:" + lang, part));
            });
            return new Criteria().orOperator(orCriterias.toArray(new Criteria[orCriterias.size()]));
        }).toArray(Criteria[]::new));
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Map.class, type);
    }

    public List<Map> allServiceProviderEntityIds() {
        Query query = new Query();
        query.fields().include("data.entityid").include("data.metaDataFields.name:en").include("data.metaDataFields.coin:imported_from_edugain").include("data.metaDataFields.coin:publish_in_edugain");
        return this.mongoTemplate.find(query, Map.class, EntityType.SP.getType());
    }

    public long deleteAllImportedServiceProviders() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"data.metaDataFields.coin:imported_from_edugain").is((Object)true));
        return this.mongoTemplate.remove(query, EntityType.SP.getType()).getDeletedCount();
    }

    public long countAllImportedServiceProviders() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"data.metaDataFields.coin:imported_from_edugain").is((Object)true));
        return this.mongoTemplate.count(query, EntityType.SP.getType());
    }

    protected String escapeSpecialChars(String query) {
        return query.replaceAll("([\\Q\\/$^.?*+{}()|[]\\E])", "\\\\$1");
    }

    private Criteria regex(String key, String search) {
        try {
            return Criteria.where((String)key).regex(".*" + search + ".*", "i");
        }
        catch (IllegalArgumentException e) {
            return Criteria.where((String)"nope").exists(true);
        }
    }

    private String escapeMetaDataField(String key) {
        if (key.startsWith("metaDataFields")) {
            return "metaDataFields." + key.substring("metaDataFields.".length()).replaceAll("\\.", "@");
        }
        if (key.startsWith("arp.attributes")) {
            return "arp.attributes." + key.substring("arp.attributes.".length()).replaceAll("\\.", "@");
        }
        return key;
    }

    public List<Map> search(String type, Map<String, Object> properties, List<String> requestedAttributes, Boolean allAttributes, Boolean logicalOperatorIsAnd) {
        Query query;
        Query query2 = query = allAttributes != false ? new Query() : this.queryWithSamlFields();
        if (!allAttributes.booleanValue()) {
            requestedAttributes.forEach(requestedAttribute -> {
                String key = this.escapeMetaDataField(requestedAttribute);
                query.fields().include("data.".concat(key));
            });
            if (type.contains("revision")) {
                query.fields().include("revision").include("data.revisionnote");
            }
        }
        ArrayList<Criteria> criteriaDefinitions = new ArrayList<Criteria>();
        properties.forEach((key, value) -> {
            key = this.escapeMetaDataField(key);
            if (value instanceof Boolean && ((Boolean)value).booleanValue() && key.contains("attributes")) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).exists(true));
            } else if (value instanceof String && !StringUtils.hasText((String)((String)value))) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).exists(false));
            } else if (value instanceof String && StringUtils.hasText((String)((String)value)) && ("true".equalsIgnoreCase((String)value) || "false".equalsIgnoreCase((String)value))) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).is((Object)Boolean.parseBoolean((String)value)));
            } else if (value instanceof String && StringUtils.hasText((String)((String)value)) && this.isNumeric((String)value)) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).is((Object)Integer.parseInt((String)value)));
            } else if ("*".equals(value)) {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).regex(".*", "i"));
            } else if (value instanceof String && ((String)value).contains("*")) {
                String queryString = (String)value;
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).regex(queryString, "i"));
            } else if (value instanceof List && !((List)value).isEmpty()) {
                List l = (List)value;
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).in((Collection)l));
            } else {
                criteriaDefinitions.add(Criteria.where((String)"data.".concat((String)key)).is(value));
            }
        });
        if (criteriaDefinitions.isEmpty()) {
            criteriaDefinitions.add(Criteria.where((String)"data").exists(true));
        }
        Criteria[] criteria = criteriaDefinitions.toArray(new Criteria[0]);
        if (logicalOperatorIsAnd.booleanValue()) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(criteria));
        } else {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(criteria));
        }
        return this.mongoTemplate.find(query, Map.class, type);
    }

    private boolean isNumeric(String value) {
        return value.matches("\\d+");
    }

    public List<MetaData> findRaw(String type, String query) {
        return this.mongoTemplate.find((Query)new BasicQuery(query), MetaData.class, type);
    }

    public List<Map> findByEntityId(String type, String entityId) {
        Document document = new Document("data.entityid", (Object)entityId);
        Query query = new BasicQuery(document).collation(Collation.of((String)"en").strength(2));
        query.fields().include("_id");
        return this.mongoTemplate.find(query, Map.class, type);
    }

    public List<MetaData> recentActivity(List<EntityType> types, int max) {
        max = Math.min(max, 100);
        Query query = new Query().with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"revision.created")})).limit(max);
        Field fields = query.fields();
        fields.include("type").include("data.state").include("data.entityid").include("data.metaDataFields.name:en").include("data.metaDataFields.OrganizationName:en").include("data.metaDataFields.OrganizationName:en").include("data.revisionnote").include("revision.created").include("revision.terminated").include("revision.updatedBy");
        List metaData = types.stream().map(entityType -> this.mongoTemplate.find(query, MetaData.class, entityType.getType())).flatMap(Collection::stream).collect(Collectors.toList());
        List<Object> results = metaData.stream().sorted(Comparator.comparing(md -> md.getRevision().getCreated(), Comparator.reverseOrder())).collect(Collectors.toList()).subList(0, Math.min(max, metaData.size()));
        Instant firstActivity = ((MetaData)results.get(results.size() - 1)).getRevision().getCreated();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"revision.terminated").gte((Object)firstActivity));
        List revisionMetaData = types.stream().map(entityType -> this.mongoTemplate.find(query, MetaData.class, entityType.getType().concat("_revision"))).flatMap(Collection::stream).map(arg_0 -> this.updateCreatedRevision(arg_0)).collect(Collectors.toList());
        results.addAll(revisionMetaData);
        if (!revisionMetaData.isEmpty()) {
            results = results.stream().sorted(Comparator.comparing(md -> md.getRevision().getCreated(), Comparator.reverseOrder())).collect(Collectors.toList()).subList(0, Math.min(max, metaData.size()));
        }
        return results;
    }

    private MetaData updateCreatedRevision(MetaData metaData) {
        metaData.getRevision().markCreatedWithTerminatedInstant();
        return metaData;
    }

    public List<Map> whiteListing(String type, String state) {
        Query query = this.queryWithSamlFields().addCriteria((CriteriaDefinition)Criteria.where((String)"data.state").is((Object)state));
        query.fields().include("data.allowedall").include("data.allowedEntities").include("data.metaDataFields.coin:stepup:requireloa");
        List metaData = this.mongoTemplate.find(query, Map.class, type);
        if (type.equals(EntityType.SP.getType())) {
            List oidcMetaData = this.mongoTemplate.find(query, Map.class, EntityType.RP.getType());
            metaData.addAll(oidcMetaData);
        }
        return metaData;
    }

    public synchronized Long incrementEid() {
        Update updateInc = new Update();
        updateInc.inc("value", (Number)1L);
        Sequence res = (Sequence)this.mongoTemplate.findAndModify((Query)new BasicQuery("{\"_id\":\"sequence\"}"), (UpdateDefinition)updateInc, this.options, Sequence.class);
        return res.getValue();
    }

    public List<StatsEntry> stats() {
        return this.mongoTemplate.getCollectionNames().stream().map(name -> new StatsEntry(name, Long.valueOf(this.mongoTemplate.count(new Query(), name)))).collect(Collectors.toList());
    }

    private Query queryWithSamlFields() {
        Query query = new Query();
        Field fields = query.fields();
        fields.include("version").include("type").include("data.state").include("data.entityid").include("data.notes");
        this.supportedLanguages.forEach(lang -> {
            fields.include("data.metaDataFields.name:" + lang);
            fields.include("data.metaDataFields.OrganizationName:" + lang);
        });
        return query;
    }
}

