/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.util.StringUtils;

public class RequiredAttributesHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;

    public RequiredAttributesHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        this.validate(newMetaData);
        return super.prePut(previous, newMetaData);
    }

    public MetaData prePost(MetaData metaData) {
        this.validate(metaData);
        return super.prePost(metaData);
    }

    private void validate(MetaData newMetaData) {
        Map metaDataFields = newMetaData.metaDataFields();
        Map schemaRepresentation = this.metaDataAutoConfiguration.schemaRepresentation(EntityType.fromType((String)newMetaData.getType()));
        Schema schema = this.metaDataAutoConfiguration.schema(newMetaData.getType());
        Map schemaMetaDataFields = (Map)Map.class.cast(((Map)Map.class.cast(schemaRepresentation.get("properties"))).get("metaDataFields"));
        Map<String, Object> properties = schemaMetaDataFields.getOrDefault("properties", Collections.emptyMap());
        Map<String, Object> patternProperties = schemaMetaDataFields.getOrDefault("patternProperties", Collections.emptyMap());
        ArrayList failures = new ArrayList();
        properties.forEach((key, value) -> {
            if (value instanceof Map && ((Map)value).containsKey("requiredAttributes")) {
                List requiredAttributes = (List)((Map)value).get("requiredAttributes");
                this.ensureMetaDataFieldIsPresent(requiredAttributes, metaDataFields, schema, key, failures);
            }
        });
        patternProperties.forEach((key, value) -> {
            if (value instanceof Map && ((Map)value).containsKey("requiredAttributes")) {
                Map requiredAttributesMap = (Map)((Map)value).get("requiredAttributes");
                requiredAttributesMap.forEach((attr, requiredAttributes) -> this.ensureMetaDataFieldIsPresent(requiredAttributes, metaDataFields, schema, attr, failures));
            }
        });
        ValidationException.throwFor((Schema)schema, failures);
    }

    private void ensureMetaDataFieldIsPresent(List<String> names, Map<String, Object> metaDataFields, Schema schema, String parentKey, List<ValidationException> failures) {
        if (metaDataFields.containsKey(parentKey)) {
            names.forEach(name -> {
                Object value = metaDataFields.get(name);
                if (value == null || value instanceof String && !StringUtils.hasText((String)((String)value))) {
                    failures.add(new ValidationException(schema, String.format("Missing required attribute %s defined as required by %s", name, parentKey), name));
                }
            });
        }
    }
}

