/*
 * Decompiled with CFR 0.152.
 */
package manage.validations;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.TypeSafetyHook;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetaDataValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataValidator.class);
    private final TypeSafetyHook metaDataHook;
    private MetaDataRepository metaDataRepository;
    private MetaDataAutoConfiguration metaDataAutoConfiguration;

    @Autowired
    public MetaDataValidator(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataHook = new TypeSafetyHook(metaDataAutoConfiguration);
    }

    public Map<String, Object> validateMigration() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Stream.of(EntityType.values()).map(EntityType::getType).forEach(type -> this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, type).stream().forEach(metaData -> this.validate(metaData, type, results)));
        return results;
    }

    private void validate(MetaData metaData, String type, Map<String, Object> results) {
        this.doValidate(metaData, type, results, true);
    }

    private void doValidate(MetaData metaData, String type, Map<String, Object> results, boolean tryToMigrate) {
        if (((Map)Map.class.cast(metaData.getData())).get("state").equals("testaccepted")) {
            return;
        }
        try {
            this.metaDataAutoConfiguration.validate(metaData.getData(), type);
        }
        catch (ValidationException e) {
            if (tryToMigrate) {
                MetaData transformedMetaData = this.metaDataHook.preValidate(metaData);
                this.metaDataRepository.update(transformedMetaData);
                this.doValidate(transformedMetaData, type, results, false);
            } else {
                Map data = (Map)Map.class.cast(metaData.getData());
                Map resultsMap = e.toJSON().toMap();
                LOG.info("ValidationException for id {} eid {} entityId {} type {} with exception {}", new Object[]{data.get("id"), data.get("eid"), data.get("entityid"), type, resultsMap});
                results.put((String)String.class.cast(data.get("entityid")), resultsMap);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

