/*
 * Decompiled with CFR 0.152.
 */
package manage.web;

import java.util.Collection;
import java.util.List;
import manage.conf.Features;
import manage.conf.Product;
import manage.conf.Push;
import manage.shibboleth.FederatedUser;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class BasicAuthenticationManager
implements AuthenticationManager {
    private final String userName;
    private final String password;
    private final List<Features> featureToggles;
    private final Product product;
    private final Push push;

    public BasicAuthenticationManager(String userName, String password, List<Features> featureToggles, Product product, Push push) {
        Assert.notNull((Object)userName, (String)"userName is required");
        Assert.notNull((Object)password, (String)"password is required");
        this.userName = userName;
        this.password = password;
        this.featureToggles = featureToggles;
        this.product = product;
        this.push = push;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.userName.equals(authentication.getPrincipal())) {
            throw new UsernameNotFoundException("Unknown user: " + authentication.getPrincipal());
        }
        if (!this.password.equals(authentication.getCredentials())) {
            throw new BadCredentialsException("Bad credentials");
        }
        String name = (String)String.class.cast(authentication.getPrincipal());
        return new UsernamePasswordAuthenticationToken((Object)new FederatedUser(name, name, name, AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_ADMIN"}), this.featureToggles, this.product, this.push), authentication.getCredentials(), (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_ADMIN"}));
    }
}

