/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import manage.hook.CompositeMetaDataHook;
import manage.hook.MetaDataHook;
import manage.model.MetaData;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CompositeMetaDataHook
implements MetaDataHook {
    private List<MetaDataHook> hooks;

    public CompositeMetaDataHook(List<MetaDataHook> hooks) {
        Assert.isTrue((!CollectionUtils.isEmpty(hooks) ? 1 : 0) != 0, (String)"Hooks may not be empty");
        this.hooks = hooks;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return true;
    }

    public MetaData postGet(MetaData metaData) {
        return this.callback(metaData, (md, hook) -> hook.postGet(md));
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        AtomicReference<MetaData> ref = new AtomicReference<MetaData>(newMetaData);
        this.hooks.stream().filter(hook -> hook.appliesForMetaData(newMetaData)).forEach(hook -> ref.set(hook.prePut(previous, (MetaData)ref.get())));
        return ref.get();
    }

    public MetaData prePost(MetaData metaData) {
        return this.callback(metaData, (md, hook) -> hook.prePost(md));
    }

    public MetaData preDelete(MetaData metaData) {
        return this.callback(metaData, (md, hook) -> hook.preDelete(md));
    }

    public MetaData preValidate(MetaData metaData) {
        return this.callback(metaData, (md, hook) -> hook.preValidate(md));
    }

    private MetaData callback(MetaData metaData, Callback callback) {
        AtomicReference<MetaData> ref = new AtomicReference<MetaData>(metaData);
        this.hooks.stream().filter(hook -> hook.appliesForMetaData(metaData)).forEach(hook -> ref.set(callback.doHook((MetaData)ref.get(), hook)));
        return ref.get();
    }
}

