/*
 * Decompiled with CFR 0.152.
 */
package manage.shibboleth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.List;
import manage.api.AbstractUser;
import manage.conf.Features;
import manage.conf.Product;
import manage.conf.Push;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class FederatedUser
extends User
implements Serializable,
AbstractUser {
    private final String uid;
    private final String displayName;
    private final String schacHomeOrganization;
    private final List<Features> featureToggles;
    private final Product product;
    private final Push push;

    public FederatedUser(String uid, String displayName, String schacHomeOrganization, List<GrantedAuthority> authorities, List<Features> featureToggles, Product product, Push push) {
        super(uid, "N/A", authorities);
        this.uid = uid;
        this.displayName = displayName;
        this.schacHomeOrganization = schacHomeOrganization;
        this.featureToggles = featureToggles;
        this.product = product;
        this.push = push;
    }

    public boolean isGuest() {
        return this.getAuthorities().stream().noneMatch(authority -> authority.getAuthority().equalsIgnoreCase("ROLE_ADMIN"));
    }

    public boolean featureAllowed(Features feature) {
        return this.featureToggles.contains(feature);
    }

    public String getName() {
        return this.uid;
    }

    public boolean isAPIUser() {
        return false;
    }

    @JsonIgnore
    public String getPassword() {
        return super.getPassword();
    }

    public String getUid() {
        return this.uid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public List<Features> getFeatureToggles() {
        return this.featureToggles;
    }

    public Product getProduct() {
        return this.product;
    }

    public Push getPush() {
        return this.push;
    }
}

