/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import crypto.KeyStore;
import java.util.List;
import java.util.Map;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.springframework.util.CollectionUtils;

public class EncryptionHook
extends MetaDataHookAdapter {
    private final KeyStore keyStore;
    private final List<String> decryptionAttributes = List.of("scim_password", "eva_token", "graph_secret");

    public EncryptionHook(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.PROV.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData) {
        return this.encryptSecrets(newMetaData);
    }

    public MetaData prePost(MetaData metaData) {
        return this.encryptSecrets(metaData);
    }

    private MetaData encryptSecrets(MetaData newMetaData) {
        Map data = newMetaData.metaDataFields();
        if (!CollectionUtils.isEmpty((Map)data)) {
            this.decryptionAttributes.forEach(attr -> {
                String secret;
                if (data.containsKey(attr) && !this.isEncryptedSecret(secret = (String)data.get(attr))) {
                    try {
                        String encoded = this.keyStore.encryptAndEncode(secret);
                        data.put(attr, encoded);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return newMetaData;
    }

    boolean isEncryptedSecret(String secret) {
        return this.keyStore.isEncryptedSecret(secret);
    }
}

