/*
 * Decompiled with CFR 0.152.
 */
package manage.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import manage.model.PathUpdateType;
import manage.model.PathUpdates;
import manage.model.Revision;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.util.Assert;

public class MetaData
implements Serializable {
    @Id
    private String id;
    @Version
    private Long version;
    @NotNull
    private String type;
    private Revision revision;
    @NotNull
    private Map<String, Object> data;

    public MetaData(String type, Map<String, Object> data) {
        this.type = type;
        this.data = data;
    }

    public void initial(String id, String createdBy, Long eid) {
        this.id = id;
        this.revision = new Revision(0, Instant.now(), null, createdBy);
        this.data.put("eid", eid);
    }

    public void revision(String newId) {
        this.type = this.type.contains("_revision") ? this.type : this.type.concat("_revision");
        this.getNonNullRevision().setParentId(this.id);
        this.id = newId;
    }

    public void terminate(String newId, String revisionNote, String uid) {
        this.id = newId;
        this.getData().put("revisionnote", revisionNote);
        this.revision.terminate(uid);
    }

    private Revision getNonNullRevision() {
        if (this.revision == null) {
            this.revision = new Revision(0, Instant.now(), null, "system");
        }
        return this.revision;
    }

    public void promoteToLatest(String updatedBy, String revisionNote) {
        this.revision = new Revision(this.getNonNullRevision().getNumber() + 1, Instant.now(), null, updatedBy);
        this.getData().put("revisionnote", revisionNote);
    }

    public void restoreToLatest(String newId, Long version, String updatedBy, int latestRevisionNumber, String newType) {
        this.type = newType;
        this.id = newId;
        this.version = version;
        this.getData().put("revisionnote", "Restore of revision: " + this.getNonNullRevision().getNumber());
        this.revision = new Revision(latestRevisionNumber + 1, Instant.now(), null, updatedBy);
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void merge(PathUpdates pathUpdates) {
        pathUpdates.getPathUpdates().forEach((path, value) -> {
            List<String> parts = Arrays.asList(path.split("\\."));
            Iterator<String> iterator = parts.iterator();
            String part = iterator.next();
            Map<String, HashMap<String, Cloneable>> reference = parts.size() == 1 ? this.data : this.data.get(part);
            String property = path;
            while (iterator.hasNext()) {
                Assert.notNull((Object)reference, (String)String.format("Invalid metadata path %s. %s part does not exists", value, part));
                part = iterator.next();
                if (iterator.hasNext()) {
                    reference = reference.get(part);
                    continue;
                }
                property = part;
            }
            if (pathUpdates.isIncrementalChange()) {
                Object rawReferenceValue = reference.get(property);
                if (rawReferenceValue instanceof String) {
                    if (value == null) {
                        reference.remove(property);
                    } else {
                        reference.put(property, (HashMap<String, Cloneable>)value);
                    }
                } else if (rawReferenceValue instanceof List || rawReferenceValue == null) {
                    List valueList;
                    ArrayList<Map> referenceValue = (ArrayList<Map>)rawReferenceValue;
                    List list = valueList = value instanceof Map ? List.of(value) : (List)value;
                    if (PathUpdateType.ADDITION.equals((Object)pathUpdates.getPathUpdateType())) {
                        referenceValue = referenceValue == null ? new ArrayList<Map>() : new ArrayList(referenceValue);
                        reference.put(property, (HashMap<String, Cloneable>)((Object)referenceValue));
                        referenceValue.removeIf(ref -> valueList.stream().anyMatch(m -> ref.get("name").equals(((Map)m).get("name"))));
                        referenceValue.addAll(valueList);
                    } else if (referenceValue != null) {
                        referenceValue.removeIf(m -> valueList.stream().anyMatch(ms -> ((Map)ms).get("name").equals(m.get("name"))));
                    }
                } else if (rawReferenceValue instanceof Map) {
                    HashMap referenceValue = (HashMap)rawReferenceValue;
                    Map valueMap = (Map)value;
                    if (PathUpdateType.ADDITION.equals((Object)pathUpdates.getPathUpdateType())) {
                        referenceValue = referenceValue == null ? new HashMap() : new HashMap(referenceValue);
                        reference.put(property, referenceValue);
                        referenceValue.putAll(valueMap);
                    } else if (referenceValue != null) {
                        referenceValue = referenceValue == null ? new HashMap() : new HashMap(referenceValue);
                        reference.put(property, referenceValue);
                        Iterator iter = referenceValue.keySet().iterator();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            if (!valueMap.containsKey(key)) continue;
                            iter.remove();
                        }
                    }
                }
            } else if (value == null) {
                reference.remove(property);
            } else {
                reference.put(property, (HashMap<String, Cloneable>)value);
            }
        });
    }

    @Transient
    public Map<String, Object> metaDataFields() {
        return (Map)this.data.get("metaDataFields");
    }

    @Transient
    public Map<String, Object> summary() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("entityid", this.data.get("entityid"));
        results.put("state", this.data.get("state"));
        Map metaDataFields = this.metaDataFields();
        results.put("name", metaDataFields.get("name:en"));
        results.put("organizationName", metaDataFields.get("OrganizationName:en"));
        return results;
    }

    private Object doTrimSpaces(Object value) {
        if (value instanceof String) {
            return ((String)value).trim();
        }
        if (value instanceof Map) {
            try {
                ((Map)value).replaceAll((key, val) -> this.doTrimSpaces(val));
                return value;
            }
            catch (UnsupportedOperationException e) {
                return value;
            }
        }
        if (value instanceof List) {
            try {
                return ((List)value).stream().map(o -> this.doTrimSpaces(o)).collect(Collectors.toList());
            }
            catch (UnsupportedOperationException e) {
                return value;
            }
        }
        return value;
    }

    public void trimSpaces() {
        this.data.replaceAll((key, value) -> this.doTrimSpaces(value));
    }

    @Transient
    @JsonIgnore
    public boolean isExcludedFromPush() {
        Object excludedFromPush = this.metaDataFields().get("coin:exclude_from_push");
        return null != excludedFromPush && (Boolean)excludedFromPush != false;
    }

    @Transient
    @JsonIgnore
    public boolean isMetadataRefreshEnabled() {
        Map autoRefresh = this.getAutoRefresh();
        return null != autoRefresh && autoRefresh.containsKey("enabled") && Boolean.parseBoolean(autoRefresh.get("enabled").toString());
    }

    @Transient
    @JsonIgnore
    public boolean isMetadataRefreshAllowAllEnabled() {
        Map autoRefresh = this.getAutoRefresh();
        return null != autoRefresh && autoRefresh.containsKey("allowAll") && Boolean.parseBoolean(autoRefresh.get("allowAll").toString());
    }

    @Transient
    @JsonIgnore
    public Map<String, Object> getAutoRefresh() {
        return (Map)this.data.get("autoRefresh");
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public Revision getRevision() {
        return this.revision;
    }

    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    public MetaData() {
    }

    public MetaData(String id, Long version, @NotNull String type, Revision revision, @NotNull Map<String, Object> data) {
        this.id = id;
        this.version = version;
        this.type = type;
        this.revision = revision;
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaData)) {
            return false;
        }
        MetaData other = (MetaData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

