/*
 * Decompiled with CFR 0.152.
 */
package manage.service.jobs;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import manage.conf.Features;
import manage.conf.MetaDataAutoConfiguration;
import manage.model.EntityType;
import manage.model.Import;
import manage.model.MetaData;
import manage.service.FeatureService;
import manage.service.ImporterService;
import manage.service.MetaDataService;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MetadataAutoRefreshRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataAutoRefreshRunner.class);
    private static final String LOG_ALREADY_RUNNING = "Metadata auto refresh is already running";
    private static final String LOG_UPDATE_START = "Start metadata auto refresh";
    private static final String LOG_UPDATE_FINISHED = "Metadata auto refresh finished";
    public static final String METADATA_ENTITYID_KEY = "entityid";
    public static final String METADATA_URL_KEY = "metadataurl";
    public static final String METADATA_FIELDS_KEY = "metaDataFields";
    public static final String AUTO_REFRESH_KEY = "autoRefresh";
    private static final String IMPORT_ERROR_KEY = "errors";
    public static final String PROPERTIES_KEY = "properties";
    public static final String FIELDS_KEY = "fields";
    private static final String REFRESH_UPDATE_USER = "Metadata reaper";
    public static final String AUTO_REFRESH_REVISION_NOTE = "Metadata updated by auto refresh";
    private static final Lock execLock = new ReentrantLock();
    private static boolean running = false;
    private final MetaDataService metaDataService;
    private final ImporterService importerService;
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final FeatureService featureService;
    private final boolean cronJobResponsible;

    public MetadataAutoRefreshRunner(MetaDataService metaDataService, ImporterService importerService, MetaDataAutoConfiguration metaDataAutoConfiguration, FeatureService featureService, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.metaDataService = metaDataService;
        this.importerService = importerService;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.featureService = featureService;
        this.cronJobResponsible = cronJobResponsible;
    }

    @Override
    @Scheduled(cron="${metadata_import.auto_refresh.cronSchedule}")
    public void run() {
        if (this.cronJobResponsible && this.featureService.isFeatureEnabled(Features.AUTO_REFRESH)) {
            if (running || !execLock.tryLock()) {
                LOG.warn(LOG_ALREADY_RUNNING);
                return;
            }
            running = true;
            try {
                this.execute();
            }
            catch (Error | Exception e) {
                LOG.error("Error during thread: {}, stacktrace: {}", (Object)e.getMessage(), (Object)e.getStackTrace());
            }
            running = false;
            execLock.unlock();
        }
    }

    private void execute() {
        LOG.info(LOG_UPDATE_START);
        LOG.info("Updating Service Providers");
        this.metaDataService.findAllByType(EntityType.SP.getType()).forEach(arg_0 -> this.doUpdate(arg_0));
        LOG.info("Updating Identity Providers");
        this.metaDataService.findAllByType(EntityType.IDP.getType()).forEach(arg_0 -> this.doUpdate(arg_0));
        LOG.info(LOG_UPDATE_FINISHED);
    }

    private void doUpdate(MetaData metaData) {
        String entityId = metaData.getData().get(METADATA_ENTITYID_KEY).toString();
        if (!metaData.isMetadataRefreshEnabled()) {
            LOG.info("Auto refresh is disabled - skipping for {}: {}", (Object)metaData.getType(), (Object)entityId);
            return;
        }
        if (!metaData.getData().containsKey(METADATA_URL_KEY) || null == metaData.getData().get(METADATA_URL_KEY)) {
            LOG.info("No metadata URL found - skipping for {}: {}", (Object)metaData.getType(), (Object)entityId);
            return;
        }
        LOG.info("Running auto refresh for {}: {}", (Object)metaData.getType(), (Object)entityId);
        List allowedFields = this.getAllowedFields(metaData, entityId);
        if (null == allowedFields) {
            return;
        }
        String metadataUrl = metaData.getData().get(METADATA_URL_KEY).toString();
        Map importXMLUrlMetaData = this.importerService.importXMLUrl(EntityType.fromType((String)metaData.getType()), new Import(metadataUrl, null));
        if (importXMLUrlMetaData.containsKey(IMPORT_ERROR_KEY)) {
            LOG.info("Failed to parse metadata from url for {} {} and url {} with error: {}", new Object[]{metaData.getType(), entityId, metadataUrl, importXMLUrlMetaData.get(IMPORT_ERROR_KEY)});
            return;
        }
        Map fieldsToUpdate = this.getUpdatedFields(importXMLUrlMetaData, allowedFields);
        List fieldsToRemove = this.getRemovedFields(importXMLUrlMetaData, allowedFields);
        if ((null == fieldsToUpdate || fieldsToUpdate.isEmpty()) && (null == fieldsToRemove || fieldsToRemove.isEmpty())) {
            LOG.info("No fields in the retrieved metadata that contain enabled auto refresh fields - skipping");
            return;
        }
        metaData.getData().put("revisionnote", AUTO_REFRESH_REVISION_NOTE);
        if (null != fieldsToUpdate && !fieldsToUpdate.isEmpty()) {
            fieldsToUpdate.forEach((key, value) -> metaData.metaDataFields().put(key, value));
        }
        if (null != fieldsToRemove && !fieldsToRemove.isEmpty()) {
            fieldsToRemove.forEach(key -> metaData.metaDataFields().remove(key));
        }
        try {
            this.metaDataService.doPut(metaData, REFRESH_UPDATE_USER, metaData.isExcludedFromPush());
        }
        catch (JsonProcessingException exception) {
            LOG.info("Failed to save changes for {} {}: {}", new Object[]{metaData.getType(), entityId, exception.getMessage()});
        }
        catch (ValidationException exception) {
            if (exception.getMessage().contains("No data is changed")) {
                LOG.info("No changes for {}: {}", (Object)metaData.getType(), (Object)entityId);
            }
            LOG.info("Failed to save changes for {} {}: {}", new Object[]{metaData.getType(), entityId, exception.getMessage()});
        }
    }

    private List<String> getAllowedFields(MetaData metaData, String entityId) {
        List<String> allowedFields;
        if (metaData.isMetadataRefreshAllowAllEnabled()) {
            Map map = this.metaDataAutoConfiguration.schemaRepresentation(EntityType.fromType((String)metaData.getType()));
            Map allFields = ((Map)((Map)((Map)((Map)map.getOrDefault(PROPERTIES_KEY, new HashMap())).getOrDefault(AUTO_REFRESH_KEY, new HashMap())).getOrDefault(PROPERTIES_KEY, new HashMap())).getOrDefault(FIELDS_KEY, new HashMap())).getOrDefault(PROPERTIES_KEY, new HashMap());
            allowedFields = new ArrayList(allFields.keySet());
        } else {
            Map configuredFields;
            Map map = configuredFields = null != metaData.getAutoRefresh() ? (Map)metaData.getAutoRefresh().get(FIELDS_KEY) : null;
            if (null == configuredFields || configuredFields.isEmpty()) {
                LOG.info("No fields configured for auto refresh and allow all is disabled - skipping for {}: {}", (Object)metaData.getType(), (Object)entityId);
                return null;
            }
            allowedFields = configuredFields.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return allowedFields;
    }

    private Map<String, Object> getUpdatedFields(Map<String, Object> newMetaData, List<String> allowedFields) {
        Map metadataFields = (Map)newMetaData.get(METADATA_FIELDS_KEY);
        return metadataFields.entrySet().stream().filter(entry -> allowedFields.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<String> getRemovedFields(Map<String, Object> newMetaData, List<String> allowedFields) {
        Map metaDataFields = (Map)newMetaData.get(METADATA_FIELDS_KEY);
        return allowedFields.stream().filter(fieldKey -> !metaDataFields.containsKey(fieldKey)).collect(Collectors.toList());
    }
}

